#-*-coding:utf-8*-*
"""
Tests unitaires sur le module pyeole.encode
"""
from py.test import raises
from pyeole.encode import normalize

string = "é"
uni = u"é"

import sys
if sys.version_info[0] >= 3:
    unicode = str

def test_type():
    """
    Tests des types retournés par la fonction normalize
    """
    assert type(normalize(string)) is unicode
    assert type(normalize(uni)) is unicode

if sys.version_info[0] < 3:
    def test_format():
        """
        Tests sur la fonction normalize
        """
        with raises(UnicodeEncodeError):
            '{0}t{1}'.format(string, uni)
        with raises(UnicodeEncodeError):
            '{0}t{1}'.format(normalize(string), normalize(uni))
        with raises(UnicodeDecodeError):
            u'{0}t{1}'.format(string, uni)
        u'{0}t{1}'.format(normalize(string), normalize(uni))
