#!/usr/bin/env python3
from os import listdir, unlink
from os.path import join, islink
from scribe.eolegroup import Group
from scribe.eleves import Eleve
from scribe.ldapconf import CLASS_PATH

eleve = Eleve()
ldapgroup = Group()
ldapgroup.ldap_admin.connect()
all_groups = ldapgroup._get_groups('classe')+ldapgroup._get_groups('option')
all_groups.sort()
for group in all_groups:
    cl_dir = join(CLASS_PATH, group)
    for link in listdir(cl_dir):
        link_dir = join(cl_dir, link)
        if islink(link_dir):
            unlink(link_dir)
    usrs = ldapgroup._get_members(group)
    for login in usrs:
        eleve.add_link_class(login, group, eleve.get_perso(login))
