#-*-coding:utf-8-*-
from scribe import eoleldap
from ldap import MOD_REPLACE, MOD_ADD, INVALID_CREDENTIALS
from py.test import raises

data = [('objectClass', 'person'),
       ('cn', 'test'),
       ('sn', 'test'),
       ('userPassword', '{SSHA}BzuC3Vqy6GxwUM9Ss5a6Jzpwr7AUj0bp')]

def setup_module(module):
    module.myldap = eoleldap.Ldap()

def test_reload():
    """
       L{scribe.eoleldap.Ldap.reload_pwd} rechargement du mot de passe ldap


    """
    oldpasswd = myldap.passwd
    myldap.passwd = "tototot"
    assert oldpasswd != myldap.passwd
    myldap.reload_pwd()
    assert oldpasswd == myldap.passwd

def test_connect():
    myldap.connect()
    myldap.close()

def test_add():
    myldap.connect()
    myldap._add("cn=test,o=gouv,c=fr", data)
    myldap.close()

def test_connect_user():
    userldap = eoleldap.Ldap(binddn='cn=test,o=gouv,c=fr', passwd='eole')
    userldap.connect()
    userldap.close()
    userldap = eoleldap.Ldap(binddn='cn=test,o=gouv,c=fr', passwd='badpass')
    raises(INVALID_CREDENTIALS, userldap.connect)
    userldap.close()

def test_modify():
    myldap.connect()
    myldap._modify('cn=test,o=gouv,c=fr',
                    [(MOD_REPLACE, 'sn', 'azerty'),
                     (MOD_ADD, 'telephoneNumber', '0380448907')],
                  )
    myldap.close()

def test_search():
    myldap.connect()
    sn = myldap._search('(&(cn=test)(objectClass=person))', 'sn')[0][1]['sn']
    assert sn == ['azerty']
    telephoneNumber = myldap._search(
                      '(&(cn=test)(objectClass=person))',
                      ['telephoneNumber', 'sn'])[0][1]['telephoneNumber']
    assert telephoneNumber == ['0380448907']
    result = myldap._search('(&(cn=test)(objectClass=person))')[0][1]
    assert result['telephoneNumber'] == ['0380448907']
    assert result['sn'] == ['azerty']
    result = myldap._search('(&(cn=inconnu)(objectClass=person))')
    assert result == []
    myldap.close()

def test_searchone():
    myldap.connect()
    result = myldap._search_one('(&(cn=test)(objectClass=person))', 'sn')
    assert result == {'sn':['azerty']}
    result = myldap._search_one('(&(cn=inconnu)(objectClass=person))')
    assert result == {}
    result = myldap._search_one('(&(cn=test)(objectClass=person))', ['attrinconnu'])
    assert result == {}
    result = myldap._search_one('(&(cn=test)(objectClass=person))', ['attrinconnu', 'sn'])
    assert result == {'sn':['azerty']}
    myldap.close()

def test_delete():
    myldap.connect()
    myldap._delete("cn=test,o=gouv,c=fr")
    myldap.close()
