# -*- coding: utf-8 -*-
###########################################################################
# EOLE - 2011
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# modifié par Cadoles (http://www.cadoles.com/)
# contact@cadoles.com
#
###########################################################################

import time, sys
from shutil import rmtree
from os import system, makedirs, symlink, chown, fchmod
from os.path import join, islink, isfile, isdir, getmtime
from datetime import datetime
import ldap
import MySQLdb

from scribe.ldapconf import ROOT_DN, ldap_server, ldap_passwd, SUFFIX, \
        HOME_PATH, USER_FILTER, GROUP_FILTER, SHARE_FILTER

sys.path.append('/usr/share/eole/controlevnc/')
from config import mysql_host, mysql_password

PATH_SCRIPTS = '/home/netlogon/scripts'
SCRIPTS_EXT = '.txt'

class Ldap():
    def __init__(self):
        self.ldap_conn = ldap.open(ldap_server)
        self.ldap_conn.simple_bind_s(ROOT_DN, ldap_passwd)

    def ldap_search(self, ldap_filter, attrib=None, one=False):
        result = self.ldap_conn.search_s(SUFFIX, ldap.SCOPE_SUBTREE,
                                    ldap_filter, attrib)
        if len(result) > 0 and len(result[0]) == 2:
            if one:
                return result[0][1]
            else:
                return result
        else:
            return {}
    def get_user_attributs(self, user):
        return self.ldap_search("(&%s(uid=%s))" % (USER_FILTER, user),
                ['objectClass', 'homeDirectory', 'sambaHomeDrive', 'uidNumber',
                'gidNumber', 'displayName', 'sambaSID'], True)

    def get_groups(self, user):
        return self.ldap_search("(&%s(memberUid=%s))" % (GROUP_FILTER, user),
                attrib=['cn', 'gidNumber'])

    def get_group_name(self, gidnumber):
        return self.ldap_search("(&%s(gidNumber=%s))" % (GROUP_FILTER,
                gidnumber), ['displayName'], True)['displayName'][0]

    def get_shares_filtred(self, group_filter):
        return self.ldap_search('(&%s(|%s))' % (SHARE_FILTER, group_filter),
                    ['sambaShareName', 'sambaFilePath', 'sambaShareURI',
                    'sambaShareDrive'])

    def __del__(self):
        self.ldap_conn.unbind()
        del(self)

def logon(user, ostype, machine, adresse_ip, pid):

    ldap_conn = Ldap()
    user_attrib = ldap_conn.get_user_attributs(user)
    userclass = get_userclass_name(user_attrib.get('objectClass', None))


    if not userclass:
        raise Exception("utilisateur %s inconnu" % user)

    if userclass not in ['administratif', 'eleve', 'enseignant']:
        raise Exception("l'utilisateur %s n'est pas autorisé à se connecter" % user)

    # si le fichier existe déjà et qu'il a moins de 1min on loggue juste la
    # connexion
    netlogon = '/home/netlogon/%s%s.txt' % (user, ostype)
    if isfile(netlogon):
        diff = time.time() - getmtime(netlogon)
    else:
        diff = 600
    prim_group = None
    gidnumber = user_attrib['gidNumber'][0].strip()
    display_name = user_attrib['displayName'][0].strip()
    sid = user_attrib['sambaSID'][0].strip()
    groups = []
    if diff > 60:
        """ construction des scripts de connexion windows
        le fichier est du format .bat pour Win95 et .txt pour le reste
        """
        homedir = user_attrib['homeDirectory'][0].strip()
        homedrive = user_attrib['sambaHomeDrive'][0].strip()
        uid = int(user_attrib['uidNumber'][0].strip())

        group_filter = ''
        for dn, grp in ldap_conn.get_groups(user):
            name = grp['cn'][0]
            if grp['gidNumber'][0] == gidnumber:
                prim_group = name
            groups.append(name)
            group_filter += '(sambaShareGroup=%s)' % name

        shares = []
        for share in ldap_conn.get_shares_filtred(group_filter):
            if share[1].has_key('sambaShareDrive'):
                drive = share[1]['sambaShareDrive'][0]
            else:
                drive = ''
            shares.append({'name': share[1]['sambaShareName'][0],
                            'path': share[1]['sambaFilePath'][0],
                            'uri': share[1]['sambaShareURI'][0],
                            'drive': drive})

        # génération du fichier client
        gen_fich(user, groups, shares, machine, ostype, homedrive, userclass,
                netlogon)
        # mise à jour de /home/u/user/.ftp/
        gen_ftpdir(uid, homedir, shares)
        # mise à jour de /home/u/user/groupes/
        gen_groupedir(uid, homedir, shares)
        # répertoire devoirs
        gen_devdir(user, uid, homedir, userclass)
        # met à jour la base de donnée
        log_connexion_db(user, sid, display_name, prim_group, groups, machine,
                ostype, adresse_ip)

    if not prim_group:
        prim_group = ldap_conn.get_group_name(gidnumber)

    del(ldap_conn)
    # enregistrement de la connexion
    # après puisque si l'utilisateur n'est pas censé se connecter
    # le script n'arrive pas jusqu'à là
    log_connexion(user, prim_group, machine, ostype, adresse_ip, pid)

def get_userclass_name(objectClass):
    """
        Renvoie le nom du module gérant les objets de classe : objectClass
    """
    if objectClass == None:
        return None
    users_objectClass = {
            'Eleves': 'eleve',
            'administrateur': 'enseignant',
            'responsable': 'responsable',
            'administratif': 'administratif',
            'autre': 'autre',
            }
    for objectclass, module in users_objectClass.items():
        if objectclass in objectClass:
            return module
    return None

def gen_devdir(login, uid, homedir, userclass):
    """
        Partie commune pour _gen_devoirdir
    """
    if userclass not in ['eleve', 'enseignant']:
        return
    perso = join(homedir, 'perso')
    # le partage "devoirs" /home/l/login/devoirs
    dev_part = join(homedir, 'devoirs')
    # le dossier U:\devoirs /home/l/login/perso/devoirs
    dev_perso = join(perso, 'devoirs')
    cmd = ""
    for rep in [dev_part, dev_perso]:
        if not isdir(rep):
            makedirs(rep, 0750)
            cmd += '/bin/chown -PR %s %s;' % (login, rep)
            cmd += '/usr/bin/setfacl -PRm u:%s:rwx %s;'%(uid, rep)
            cmd += '/usr/bin/setfacl -dPRm u:%s:rwx %s;'%(uid, rep)

    if userclass == 'enseignant':
        # dossier contenant les devoirs et les données à distribuer du prof
        # U:\devoirs\.distribues ou \\scribe\devoirs\.distribues
        dev_dist_dir = join(HOME_PATH, 'workgroups/devoirs', login)
        if not isdir(dev_dist_dir):
            makedirs(dev_dist_dir, 0755)
            cmd += '/usr/bin/setfacl -PRbk %s;' % dev_dist_dir
            cmd += '/usr/bin/setfacl -PRm u:%s:rwx %s;' % (uid, dev_dist_dir)
            cmd += '/usr/bin/setfacl -dPRm u:%s:rwx %s;' % (uid, dev_dist_dir)
        for rep in [dev_part, dev_perso]:
            link = join(rep, '.distribues') # le cacher avec un "."
            if not islink(link):
                symlink(dev_dist_dir, link)
    if cmd != '':
        system(cmd)

def gen_ftpdir(uid, homedir, shares):
    """
        Gestion du répertoire ".ftp"
    """
    ftpdir = join(homedir, '.ftp')
    homedir = join(HOME_PATH, homedir[6:])
    def create_ftpsymlink():
        symlink(join(homedir, 'perso'), join(ftpdir, 'perso'))
        for share in shares:
            if share['name'] not in ['icones$', 'groupes']:
                if HOME_PATH != '/home':
                    share['path'] = share['path'].replace('/home',
                            HOME_PATH)
                symlink(share['path'], join(ftpdir, share['name']))
    if not isdir(ftpdir):
        makedirs(ftpdir, 0500)
        chown(ftpdir, uid, -1)
        create_ftpsymlink()
    elif not islink(join(ftpdir, 'perso')):
        rmtree(join(ftpdir, 'perso'))
        create_ftpsymlink()

def gen_groupedir(uid, homedir, shares):
    """
        Gestion du répertoire "groupes"
    """
    groupedir = join(homedir, 'groupes')
    if isdir(groupedir):
        rmtree(groupedir)
    makedirs(groupedir, 0500)
    chown(groupedir, uid, -1)
    #les ACLs ne sont pas mise
    #system('setfacl -bk %s' % groupedir)
    for share in shares:
        # sinon partage avec lettre de lecteur
        if share['drive'] == "":
            # lien dans le répertoire "groupes"
            symlink(share['path'], join(groupedir, share['name']))

def log_connexion_db(user, sid, display_name, primgrp, groups, netbios,
        ostype, ip):
    #groups = ',%s,' % ','.join(groups)
    db = MySQLdb.connect(host=mysql_host, user='controlevnc',
            passwd=mysql_password, db='controlevnc')
    c = db.cursor()
    #FIXME : suffisamment de test ?
    c.execute("SELECT ip FROM log WHERE ip='%s'" % ip)
    if c.fetchone(): # l'IP existe dans la BDD
        c.execute("SELECT ip FROM log WHERE netbios='%s'" % netbios)
        ip_base = c.fetchone() # IP correspondant à <netbios>
        if ip_base and ip_base[0] != ip: # le poste <netbios> a changé d'IP (dhcp)
            # cas où le poste possède déjà une entrée SQL mais avec la mauvaise IP
            c.execute("DELETE FROM `log` WHERE netbios='%s'" % netbios)
        c.execute("UPDATE log SET netbios='%s', user='%s', sid='%s', display_name='%s', prim_group='%s', os='%s' WHERE ip='%s'" % (netbios, user, sid, display_name,primgrp, ostype, ip))
    else: # l'IP n'existe pas dans la BDD
        c.execute("SELECT ip FROM log WHERE netbios='%s'" % netbios)
        if c.fetchone(): # par contre <netbios> existe, avec une mauvaise IP donc
            # cas où le poste possède déjà une entrée SQL mais avec la mauvaise IP
            # le nom NETBIOS pour la bonne IP est à ''
            c.execute("DELETE FROM `log` WHERE netbios='%s'" % netbios)
        c.execute("INSERT INTO log (netbios, ip, user, sid, display_name, prim_group, os) VALUES ('%s', '%s', '%s', '%s', '%s', '%s', '%s')" % (netbios, ip, user, sid, display_name, primgrp, ostype))
    c.execute("DELETE FROM `group` WHERE ip='%s'" % ip)
    for group in groups:
        c.execute("INSERT INTO `group` (ip, groupname) VALUES ('%s', '%s')" %
                    (ip, group))
    try:
        db.commit()
    except Exception, e:
        db.rollback()
        raise Exception('erreur de la base de donnée : %s' % str(e))
    db.close()


def log_connexion(user, primgrp, machine, ostype, adresse_ip, pid):
    """
    Enregistrement de la connexion
    """
    try:
        sdate = datetime.now().strftime("%a %d %b %Y %H:%M").capitalize()
        cmd = 'echo CONNECTION %s %s %s %s %s %s %s' % (sdate, user,
                primgrp, machine, ostype, adresse_ip, pid)
        system('%s >> /var/log/samba/%s.log' % (cmd, machine))
        system('%s >> /var/log/samba/connexions.log' % (cmd))
    except:
        pass

#############################################################
## Génération des fichiers de logon
#############################################################

def gen_fich(user, groups, shares, machine, ostype, homedrive, userclass,
        netlogon):
    """
    Génération du fichier lu par le client
    """
    script = ""
    # gestion des groupes et des partages
    for share in shares:
        # sinon créé un lien symbolique
        if share['drive'] != "":
            # partage avec lettre de lecteur
            script += gen_lecteur_bloc(share['drive'], share['uri'])

    # gestion des scripts additionnels
    debut, fin = get_scripts(user, machine, ostype, groups)
    # écriture du fichier
    write_fich(netlogon, debut + script + fin)

def gen_letter_share(lettre, share):
    """lettre : supprime les ":", juste la lettre
    share : le partage sans \ à la fin
    """
    while share[-1] == '\\':
        share = share[:-1]
    return lettre[:1], share

def gen_lecteur_bloc(lettre, share):
    """Génère un bloc de ligne pour le montage
    d'un lecteur réseau "share" sur la lettre "lettre"
    ou sur * sinon (sauf pour win95)
    """
    lettre, share = gen_letter_share(lettre, share)
    return 'lecteur,%s:,%s\r\n' % (lettre, share)

def gen_cmd_line(line, hide=False, nowait=False):
    """génère une ligne DOS (avec le bon retour chariot) (pas win95)
    """
    chaine = 'cmd,%s' % line
    if hide:
        chaine += ',HIDDEN'
    if nowait:
        chaine += ',NOWAIT'
    return chaine + '\r\n'

def get_scripts(user, machine, ostype, user_groups):
    """Gestion des scripts externes
    """
    # motif à rechercher dans les fichiers externes
    # (debut_script %motif% fin_script)
    motif_include = [ "%%NetUse%%", "%NetUse%" ]
    # chemin par défaut des scripts externes
    buffer_debut,  buffer_fin = '', ''
    # on traite ceux qui sont présents
    for chemin in get_scripts_list(user, machine, ostype, user_groups):
        if isfile(chemin):
            debut = 1
            for line in file(chemin,"r"):
                line = line.strip()
                if line in motif_include:
                    debut = 0
                else:
                    if debut == 1:
                        buffer_debut += parse_line(ostype, line)
                    else:
                        buffer_fin += parse_line(ostype, line)
    return (buffer_debut, buffer_fin)

def get_scripts_list(user, machine, ostype, user_groups):
    """On créé la liste des fichiers possibles
    +--PATH_SCRIPTS/users/<user>.txt
    +--PATH_SCRIPTS/groups/<group>.txt
    +--PATH_SCRIPTS/machines/<machine>.txt
    +--PATH_SCRIPTS/os/<os>.txt
    +--PATH_SCRIPTS/os/<os>/<group>.txt
    +--PATH_SCRIPTS/os/<os>/<user>.txt
    """
    chemins = [join(PATH_SCRIPTS, 'users', '%s%s' % (user, SCRIPTS_EXT))]
    chemins.append(join(PATH_SCRIPTS, 'machines', '%s%s' %
                (machine, SCRIPTS_EXT)))
    for group in user_groups:
        chemins.append(join(PATH_SCRIPTS, 'groups', '%s%s' %
                    (group, SCRIPTS_EXT)))
        chemins.append(join(PATH_SCRIPTS, 'os', '%s' % ostype, '%s%s' %
                    (group, SCRIPTS_EXT)))
    chemins.append(join(PATH_SCRIPTS, 'os', '%s%s' % (ostype, SCRIPTS_EXT)))
    chemins.append(join(PATH_SCRIPTS, 'os', ostype, '%s%s' %
                (user, SCRIPTS_EXT)))
    return chemins

def parse_line(ostype, line):
    items = [ i.strip() for i in line.split(',') ]
    script_type = items[0].upper()
    options = [opt.upper() for opt in items[2:]]
    if script_type == 'CMD':
        # exécuter une commande
        # cmd,"C:\Windows\notepad.exe",NOWAIT,HIDDEN
        #  0     1                       2      3
        hide = 'HIDDEN' in options
        nowait = 'NOWAIT' in options
        return gen_cmd_line(items[1], hide, nowait)
    elif script_type == 'LECTEUR':
        # monter un partage
        lettre, partage = items[1], items[2]
        return gen_lecteur_bloc(lettre, partage)
    return ''

def write_fich(netlogon, lines):
    """Ecrit le fichier
    """
    fic = file(netlogon, 'w')
    fchmod(fic.fileno(), 0644)
    #convert to DOS format
    #lines = lines.replace('\n', '\r\n')
    lines = lines.decode('utf8').encode('cp437')
    fic.write(lines)
    fic.close()
