# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2010
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr
###########################################################################
"""
    librairies pour la gestion des postes de travail
"""
from pyeole.process import system_out
from scribe.ldapconf import COMPUTER_FILTER
from scribe.eoleldap import LdapEntry

class Station(LdapEntry):
    """
    Gestion des postes de travail
    """

    def get_workstations(self):
        """
        liste des postes de travail
        """
        stats = []
        self.ldap_admin.connect()
        res = self.ldap_admin._search("(&%s)" % COMPUTER_FILTER, ['uid'])
        self.ldap_admin.close()
        for stat in res:
            # les postes se terminent par $
            stats.append(stat[1]['uid'][0].replace("$",""))
        stats.sort()
        return stats

    def add_workstation(self, workstation):
        """
        [ ne devrait pas être utilisé ]
        """
        cmd = ['/usr/sbin/smbldap-useradd', '-w', workstation]
        ret = system_out(cmd, container='fichier')
        if ret[0] != 0:
            raise Exception("Erreur d'ajout de la station : %s" % ' '.join(ret[1:]))


    def del_workstation(self, workstation):
        """
        suppression d'une station de travail
        """
        if not workstation.endswith('$'):
            workstation = workstation+'$'
        cmd = ['/usr/sbin/smbldap-userdel', workstation]
        ret = system_out(cmd, container='fichier')
        if ret[0] != 0:
            raise Exception("Erreur de suppression de la station : %s" % ' '.join(ret[1:]))

