# -*- coding: UTF-8 -*-
from py.test import raises
import exceptions
from glob import glob
from os.path import isdir, isfile, islink, lexists, exists
from os import system, listdir
from creole.client import CreoleClient
from time import sleep
import ftplib, imaplib

from pyeole.process import system_code, system_out
from fichier import quota
from scribe.eolegroup import Group
from scribe.eleves import Eleve
from scribe.enseignants import Enseignant
from scribe.eoleshare import Share
from scribe.errors import NotEmptyGroup

dico = CreoleClient().get_creole()
dyn_logon = '/usr/share/eole/fichier/dyn-logon.py --user=%s --os=%s --machine=%s --ip=%s'

smb = dico['container_ip_fichier']
imap = dico['container_ip_mail']
sympa_path = '%s/var/lib/sympa/expl/i-*/tclasse' % dico['container_path_mail']
mount_cmd = 'mount -t cifs'

# droits attendus pour le répertoire créé via FTP
ftpacl = """# file: home/t/televe/perso/testmkdirftp/
# owner: televe
# group: eleves
user::rwx
user:televe:rwx
group::---
group:professeurs:r-x
mask::rwx
other::---
default:user::rwx
default:user:televe:rwx
default:group::---
default:group:professeurs:r-x
default:mask::rwx
default:other::---

"""

def test_create_niveau():
    Group().add_niveau('tnivo')

def test_create_classe():
    grp = Group()
    grp.add_classe('tclasse', 'tnivo')
    assert isdir('/home/workgroups/tclasse/donnees')
    assert isdir('/home/workgroups/profs-tclasse')
    assert 'tnivo' == grp.get_niveau('tclasse')
    assert glob(sympa_path) != []

def test_create_groupe():
    Group().add_groupe('tgroupe', partage='dt')
    assert isdir('/home/workgroups/tgroupe/travail')

def test_create_eleve():
    Eleve().add_one(login='televe', password='tpass', nom='nom',
                    prenom='prenom', date='01021980', classe= 'tclasse',
                    numero='666', civilite='1', domaine='restreint',
                    quota='20', profil='3', shell=False, entlogin=False)
    assert isdir('/home/t/televe/perso/prive')
    sleep(0.5)
    assert isdir('/home/mail/televe')
    # liens classe -> eleves
    assert isdir('/home/workgroups/profs-tclasse/eleves/televe')

def test_create_prof():
    Enseignant().add_one(login='tprof', password='tpass', nom='nom',
                         prenom='prenom', date='01021980', civilite='1',
                         classe='tclasse', entlogin=False)
    assert isdir('/home/t/tprof/perso')
    sleep(0.5)
    assert isdir('/home/mail/tprof')

def test_inscription_prof():
    ens = Enseignant()
    ens.ldap_admin.connect()
    ens._inscription('tprof', 'profs-tclasse')
    ens.ldap_admin.close()
    assert isdir('/home/t/tprof/.ftp/profs-tclasse')

def test_inscription_eleve():
    ele = Eleve()
    ele.ldap_admin.connect()
    ele._inscription('televe', 'tgroupe')
    ele.ldap_admin.close()
    assert isdir('/home/t/televe/.ftp/tgroupe')

def test_smb_perso_eleve():
    system('mkdir -p /tmp/home')
    assert system('%s //%s/televe /tmp/home -o username=televe,password=tpass' % (mount_cmd, smb)) == 0
    system('touch /tmp/home/perso/fichier.txt')
    assert isfile('/tmp/home/perso/fichier.txt')
    system('rm -f /tmp/home/perso/fichier.txt')
    assert not isfile('/tmp/home/perso/fichier.txt')
    # test antivirus temps réel
    if dico.get('smb_vscan', 'non') == 'oui':
        system("""echo 'X5O!P%@AP[4\PZX54(P^)7CC)7}$EICAR-STANDARD-ANTIVIRUS-TEST-FILE!$H+H*' > /tmp/home/perso/virus.txt""")
        sleep(2)
        assert not isfile('/tmp/home/perso/virus.txt')
        system('rm -f /tmp/home/perso/virus.txt')

def test_smb_classe_eleve():
    system('mkdir -p /tmp/classe')
    assert system('%s //%s/tclasse /tmp/classe -o username=televe,password=tpass' % (mount_cmd, smb)) == 0
    system('touch /tmp/classe/travail/fichier.txt')
    assert isfile('/tmp/classe/travail/fichier.txt')
    system('rm -f /tmp/classe/travail/fichier.txt')
    assert not isfile('/tmp/classe/travail/fichier.txt')
    system('touch /tmp/classe/donnees/fichier.txt')
    assert not isfile('/tmp/classe/donnees/fichier.txt')
    system('rm -f /tmp/classe/donnees/fichier.txt')

def test_smb_equipe_prof():
    system('mkdir -p /tmp/equipe')
    assert system('%s //%s/profs-tclasse /tmp/equipe -o username=tprof,password=tpass' % (mount_cmd, smb)) == 0
    assert isdir('/tmp/equipe/eleves/televe')
    if dico['smb_unixextensions'] != 'yes':
        # pas le droit de scanner le privé (FIXME : problème avec unixextensions)
        print "FIXME : listdir #1025"
        raises(exceptions.OSError, listdir, '/tmp/equipe/eleves/televe/prive')

def test_demontage():
    # on regroupe tous les démontages
    system('umount /tmp/home/')
    system('umount /tmp/classe')
    system('umount /tmp/equipe')

def test_logonXP():
    plink = '/home/t/tprof/.ftp/perso'
    gdir = '/home/t/tprof/groupes'
    ptlink = '/home/t/tprof/.ftp/profs-tclasse'
    ptdir = '/home/workgroups/profs-tclasse'
    assert islink(plink)
    assert not isdir(gdir)
    system('rm -f {0}'.format(plink))
    cmd = dyn_logon % ('tprof', 'WinXP', 'testXP', '1.1.1.2')
    system_code(cmd.split(' '), container='fichier')
    assert islink(plink)
    assert islink(ptlink)
    assert isdir(ptdir)
    assert isdir(gdir)
    assert isfile('/home/netlogon/tprofWinXP.txt')
    assert "lecteur,P:,\\\\%s\professeurs" % dico['smb_netbios_name'] in \
           file('/home/netlogon/tprofWinXP.txt').read().splitlines()
    system('rm -f /home/netlogon/tprofWinXP.txt')
    system('rm -rf {0}'.format(gdir))

def test_logonXP_bad_link():
    plink = '/home/t/tprof/.ftp/perso'
    gdir = '/home/t/tprof/groupes'
    ptlink = '/home/t/tprof/.ftp/profs-tclasse'
    ptdir = '/home/workgroups/profs-tclasse'
    system('rm -rf {0}'.format(ptdir))
    assert not exists(ptlink)
    assert lexists(ptlink)
    assert not isdir(ptdir)
    cmd = dyn_logon % ('tprof', 'WinXP', 'testXP', '1.1.1.2')
    system_code(cmd.split(' '), container='fichier')
    assert not exists(ptlink)
    assert not lexists(ptlink)
    assert not isdir(ptdir)
    system('rm -f /home/netlogon/tprofWinXP.txt')
    system('mkdir {}'.format(ptdir))

def test_ftp_eleve():
    if dico['activer_proftpd'] == 'oui':
        system('rm -rf /home/t/televe/perso/testmkdirftp/')
        session = ftplib.FTP(smb, 'televe', 'tpass')
        session.cwd("perso")
        session.mkd("testmkdirftp")
        session.quit()
        assert system_out(['getfacl', '/home/t/televe/perso/testmkdirftp/'])[1] == ftpacl

def test_mail_eleve():
    mail = imaplib.IMAP4(imap)
    mail.login('televe', 'tpass')
    mail.select('inbox')
    assert 'Subject:' in mail.fetch(1, "(body[header])")[1][0][1]
    mail.close()
    mail.logout()

def test_mail_prof():
    mail = imaplib.IMAP4(imap)
    mail.login('tprof', 'tpass')
    mail.select('inbox')
    assert 'Subject:' in mail.fetch(1, "(body[header])")[1][0][1]
    mail.close()
    mail.logout()

def test_mod_mail():
    ens = Enseignant()
    ens.ldap_admin.connect()
    ens._mod_mail('tprof', mailtype='perso', mail='tprof@tprof.com')
    assert ens._get_attr('tprof', 'mail') == ['tprof@tprof.com']
    assert ens._get_attr('tprof', 'mailDir') == []
    assert ens._get_attr('tprof', 'mailHost') == []
    ens.ldap_admin.close()

def test_profils():
    ele = Eleve()
    ens = Enseignant()
    ele.ldap_admin.connect()
    ens.ldap_admin.connect()
    # profils à la création
    assert ele._get_attr('televe', 'sambaProfilePath') == ["\\\\%(smb_netbios_name)s\\netlogon\\profil2" % dico]
    assert ele._get_attr('tprof', 'sambaProfilePath') == []
    # modification de profils
    ens._set_profil('tprof', 2)
    assert ens._get_attr('tprof', 'sambaProfilePath') == ["\\\\%(smb_netbios_name)s\\netlogon\\profil" % dico]
    ens._set_profil('tprof', 4)
    assert ens._get_attr('tprof', 'sambaProfilePath') == ["\\\\%(smb_netbios_name)s\\tprof\\profil" % dico]
    ens._set_profil('tprof', 1)
    assert ens._get_attr('tprof', 'sambaProfilePath') == []
    ele.ldap_admin.close()
    ens.ldap_admin.close()

def test_quotas():
    # quotas à la création
    assert quota.get_quota('televe') == 20
    assert quota.get_quota('tprof') == 0
    # modification de quotas
    quota.set_quota('tprof', 50)
    assert quota.get_quota('tprof') == 50

def test_delete_not_empty_classe():
    raises(NotEmptyGroup, Group().delete, 'tclasse')

def test_desinscription():
    ele = Eleve()
    ele.ldap_admin.connect()
    ele._desinscription('televe', 'tgroupe')
    assert not isdir('/home/t/televe/.ftp/tgroupe')
    ele.ldap_admin.close()

def test_delete_eleve():
    Eleve().delete('televe', remove_data=True)
    assert not isdir('/home/t/televe')
    assert not islink('/home/tclasse/televe')

def test_delete_prof():
    Enseignant().delete('tprof', remove_data=True)
    assert not isdir('/home/t/tprof')

def test_delete_shares():
    sha = Share()
    sha.ldap_admin.connect()
    sha._delete('tclasse', rmdir=True, sync=False)
    assert not isdir('/home/workgroups/tclasse')
    sha._delete('profs-tclasse', rmdir=True, sync=False)
    assert not isdir('/home/workgroups/profs-tclasse')
    sha._delete('tgroupe', rmdir=True, sync=False)
    assert not isdir('/home/workgroups/tgroupe')
    sha.ldap_admin.close()

def test_delete_classe():
    grp = Group()
    grp.delete('tclasse', rmdir=True, sync=False)
    assert not isdir('/home/workgroups/profs-tclasse')
    assert not isdir('/home/classes/tclasse')
    assert glob(sympa_path) == []

def test_delete_groups():
    grp = Group()
    grp.delete('tnivo', rmdir=True, sync=False)
    grp.delete('tgroupe', rmdir=True, sync=False)

