#! /usr/bin/env python
# -*- coding: UTF-8 -*-

###########################################################################
#
# Eole NG - 2008
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
###########################################################################

"""
Utilitaire de génération de fichiers netlogon depuis LDAP
"""
import sys
from optparse import OptionParser
from os.path import isfile, getmtime
#pour evite un parsedico
#from scribe.cadoleseoletools import my_escape
from scribe.login import logon


def my_escape(string):
    """
    remplacement de caractères pour dyn-logon
    -> ne pas remplacer les "."
    """
    return string.strip().replace(' ','').replace('"', "\'").replace(';', '\;').replace("'", "\\'")

#############################################################
## Boucle principale du programme - gestion des options
#############################################################

def main():
    """
    boucle principale (gestion des options)
    """
    parser = OptionParser()
    parser.add_option("-u", "--user", dest="user", help=u"nom du login")
    parser.add_option("-o", "--os", dest="ostype", help=u"type OS")
    parser.add_option("-m", "--machine", dest="machine",
            help=u"Nom de la machine")
    parser.add_option("-i", "--ip", dest="adresse_ip", help=u"adresse IP")
    parser.add_option("-p", "--pid", dest="pid", help=u"numéro du PID", default="unknown")

    (options, args) = parser.parse_args()
    #all options are required
    if None in [options.user, options.ostype, options.machine,
            options.adresse_ip]:
        parser.print_help()
        sys.exit(1)

    user = my_escape(options.user.lower())
    from os import system
    #if first character is not alphanum set None
    if not user[0].isalnum():
        print "Le premier caractère du nom doit être alphanumérique"
        sys.exit(1)
    if user == "nobody":
        print "utilisateur nobody : ne rien faire"
        sys.exit(1)

    ostype = my_escape(options.ostype)
    machine = my_escape(options.machine.lower())
    adresse_ip = my_escape(options.adresse_ip)
    pid = my_escape(options.pid)

    try:
        logon(user, ostype, machine, adresse_ip, pid)
    except Exception, err:
        import traceback
        print traceback.print_exc()
        print err
        sys.exit(1)

if __name__ == '__main__':
    #import hotshot
    #from hotshot import stats

    #prof = hotshot.Profile("hotshot_stats")
    #prof.runcall(main)
    #prof.close()
    #s = stats.load("hotshot_stats")
    #s.sort_stats("time").print_stats()
    main()
