# -*- coding:utf8 -*-
from os.path import join, isfile
#from creole.client import CreoleClient

from configobj import ConfigObj

conffile = "/etc/eole/ldapconf.conf"
dico = ConfigObj(conffile)

#dico = CreoleClient().get_creole()

# chemin des conteneurs
CONTAINER_PATH_FICHIER = dico['container_path_fichier']
CONTAINER_PATH_MAIL = dico['container_path_mail']
if CONTAINER_PATH_FICHIER == '':
    CONTAINER_PATH_FICHIER = '/'
if CONTAINER_PATH_MAIL == '':
    CONTAINER_PATH_MAIL = '/'

# configuration LDAP
LDAPCONF = '/etc/eole/eoleldap.conf'
READERCONF = '/root/.reader'
if isfile(LDAPCONF):
    execfile(LDAPCONF)
else:
    raise Exception("Fichier %s non trouvé" % LDAPCONF)
if isfile(READERCONF):
    READER_PWD = file(READERCONF).read().rstrip()
else:
    READER_PWD = 'FIXME'

# initialisation de variables
num_etab = str(dico['numero_etab'])
acad = str(dico['nom_academie'])
domaine_mess = str(dico['domaine_messagerie_etab'])
SMB_SERVEUR = str(dico["smb_netbios_name"])
HOME_PATH = str(dico['home_path'])
GROUP_PATH = join(HOME_PATH, 'workgroups')
CLASS_PATH = join(HOME_PATH, 'classes')
RECYCLAGE_PATH = join(HOME_PATH, 'recyclage')
OPT_PATH = join(HOME_PATH, 'options')
MAILDIR_PATH = join(HOME_PATH, 'mail')
GROUPWARE = dico['activer_groupware'] == 'oui'

SUFFIX = 'o=gouv,c=fr'
ROOT_DN = 'cn=admin,%s' % SUFFIX

#ajoute l'etablissement par défaut si pas spécifié dans le dico
#templatisant la string
class EtabStr(str):
    def __mod__(self, dico):
        dico.setdefault('etab', num_etab)
        if dico['etab'] == None:
            dico['etab'] = num_etab
        return str.__mod__(self, dico)

# dn pour les différentes branches
RACINE = "ou=%s,ou=education,%s" % (acad, SUFFIX)
BRANCHE = "ou=%s,%s" % (num_etab, RACINE)
BRANCHE_ETAB = "ou=%%(etab)s,%s" % (RACINE)
BRANCHE_ETAB2 = EtabStr(BRANCHE_ETAB)
USERS_DN = EtabStr("ou=utilisateurs,%s" % BRANCHE_ETAB)
USER_DN = EtabStr("uid=%%(uid)s,ou=local,ou=%%(_type)s,ou=utilisateurs,%s" % BRANCHE_ETAB)
BRANCHE_GROUP_ETAB = "ou=local,ou=groupes,%s" % BRANCHE_ETAB
GROUP_DN = EtabStr("cn=%%(cn)s,%s" % BRANCHE_GROUP_ETAB)
SHARE_DN = EtabStr("cn=smb://%s/%%(share)s,ou=local,ou=partages,%s" % (SMB_SERVEUR, BRANCHE_ETAB))
# filtres pour les differentes branches
USER_FILTER = "(objectclass=inetOrgPerson)(!(description=Computer))"
GROUP_FILTER = "(objectclass=sambaGroupMapping)(objectclass=posixGroup)"
COMPUTER_FILTER = "(description=Computer)(objectclass=posixAccount)"
SHARE_FILTER = "(objectClass=sambaFileShare)"
ELEVE_FILTER = "%s(objectClass=Eleves)" % USER_FILTER
PROF_FILTER = "%s(objectClass=Administrateur)" % USER_FILTER
ADMINISTRATIF_FILTER = "%s(objectClass=administratif)" % USER_FILTER
RESPONSABLE_FILTER = "%s(objectClass=responsable)" % USER_FILTER
AUTRE_FILTER = "%s(objectClass=autre)" % USER_FILTER
# définition des 2 domaines de messagerie
MAIL_DOMAIN = {'restreint' : 'i-{0}'.format(domaine_mess),
          'internet'  : str(domaine_mess)}
MAIL_ADMIN = "admin@{0}".format(MAIL_DOMAIN['internet'])
# profil Windows disponibles
PROFILS = (('1', 'local'),
           ('2', "obligatoire - profil1"),
           ('3', "obligatoire - profil2"),
           ('4', 'itinérant'))
# équivalence entre les différents codes de civilité
CIVILITES = (
             {'code':'1', 'title':'M.', 'sexe':'M'},
             {'code':'2', 'title':'Mme', 'sexe':'F'},
             {'code':'3', 'title':'Mlle', 'sexe':'F'},
            )
# utilisateurs spéciaux à protéger
SPEC_USERS = ['admin', 'user.assr', 'Meta_*', 'Visiteur']

SUPPORT_ETAB = dico['ead_support_multietab'] == 'oui'
EOLE_AD = dico['activer_ad'] == 'oui'
MIN_PASSWORD_CLASS = int(dico['smb_min_password_class'])
