# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# templates python pour le backend ScribeNg
#
###########################################################################

# template de configuration d'une liste Sympa
tmpl = """subject liste %(type)s %(groupe)s

status open

topics %(type)s

visibility noconceal

subscribe open_notify

unsubscribe open_notify

send public

owner
  email %(email)s
  profile privileged

web_archive
  access private

archive
  access owner
  period week

digest 1,4 12:00

review owner

creation
  date %(date)s
  email %(email)s
  date_epoch 998698638

ttl 7200

user_data_source include
"""

# template sympa pour les groupes Eole
liste_tmpl = tmpl + """
include_ldap_2level_query
port 389
host %(host)s
timeout1 30
suffix1 %(branche)s
filter1 (objectClass=posixGroup)
attrs1 memberUid
select1 all
scope1 base
timeout2 30
suffix2 %(racine)s
filter2 (uid=[attrs1])
attrs2 mail
select2 first
scope2 sub
"""

# template sympa pour les responsables Eole
resp_list_tmpl = tmpl + """
include_ldap_2level_query
port 389
host %(host)s
user cn=reader,o=gouv,c=fr
passwd %(pwd)s
timeout1 30
suffix1 %(branche)s
filter1 (&(objectClass=eleves)(Divcod=%(groupe)s))
attrs1 uid
select1 all
scope1 sub
timeout2 30
suffix2 %(branche)s
filter2 (&(objectClass=responsable)(eleve=[attrs1]))
attrs2 mail
select2 all
scope2 sub
"""

# alias mail pour une liste Sympa
alias_tmpl =  """%(ldomaine)s-%(groupe)s: \"|/usr/lib/sympa/bin/queue %(groupe)s@%(ldomaine)s\"
%(ldomaine)s-%(groupe)s-request: \"|/usr/lib/sympa/bin/queue %(groupe)s-request@%(ldomaine)s\"
%(ldomaine)s-%(groupe)s-editor: \"|/usr/lib/sympa/bin/queue %(groupe)s-editor@%(ldomaine)s\"
%(ldomaine)s-%(groupe)s-owner: \"|/usr/lib/sympa/bin/bouncequeue %(groupe)s@%(ldomaine)s\"
"""

