#-*-coding:utf-8*-*
from scribe.administratifs import Administratif
from scribe.eolegroup import Group

admin_test = {'login':'__admin__test__',
              'password':'Profeole$',
             'nom':'__administratif__',
             'prenom':'__test__',
             'date':'12/03/1954',
             'civilite':'1',
             'mail':'internet',
             'quota':'0',
             'profil':'1',
             'shell':False,
            }

class TestAdministratif:
    """
        Test de la classe Personnel Administratif
    """
    username = admin_test['login']
    grname = "__groupe__administratif__"

    def setup_class(cls):
        cls.admin = Administratif()
        cls.group = Group()
        cls.admin.ldap_admin.connect()
        cls.group.ldap_admin.connect()

    def test_add(self):
        self.admin._add(**admin_test)
        self.group._add("Service", self.grname,
                description="les agents administratifs")

    def test_is_user(self):
        assert self.admin._is_user(self.username)
        assert self.admin._get_attr(self.username, 'typeadmin')
        assert self.admin._get_attr(self.username, 'loginShell')[0] == '/bin/false'
        assert self.admin._get_attr(self.username, 'ENTPersonProfils') == ['administratif']

    def test_inscription(self):
        self.admin._inscription(self.username, self.grname, sync=False)
        assert self.username in self.group._get_attr(self.grname, 'memberUid')

    def test_get_members(self):
        assert self.group._get_members(self.grname) == [self.username]

    def test_get_user_groups(self):
        assert self.grname in self.group._get_user_groups(self.username)
        assert 'administratifs' in self.group._get_user_groups(self.username)

    def test_desinscription(self):
        self.admin._desinscription(self.username, self.grname, sync=False)
        assert self.username not in self.group._get_attr(self.grname, 'memberUid')

    def test_delete(self):
        self.admin._delete(self.username, remove_data=True)
        assert not self.admin._is_user(self.username)
        self.group._delete(self.grname, rmdir=True, sync=False)
        assert not self.group._is_group(self.grname)

    def teardown_class(cls):
        cls.admin.ldap_admin.close()
        cls.group.ldap_admin.close()

