from creole.client import CreoleClient
from pyeole.process import system_code
from creole.loader import creole_loader, config_save_values
from time import sleep


client = CreoleClient()

def test_dhcp():
    if client.get_creole('activer_dhcp') == 'non':
        return
    assert system_code(["pgrep", "-u", "dhcpd", "dhcpd"]) == 0
    config = creole_loader(rw=True, owner='test')
    del config.creole.dhcp.global_domain_wpad_dhcp
    config_save_values(config, 'creole')
    assert system_code(['CreoleCat', '-t', 'dhcpd.conf']) == 0
    assert system_code(['systemctl', 'restart', 'isc-dhcp-server.service']) == 0
    sleep(2)
    assert system_code(["pgrep", "-u", "dhcpd", "dhcpd"]) == 0
