#-*-coding:utf-8-*-
"""
    Configuration de l'importation scribe
"""
from os.path import join

from scribe.ldapconf import CHECK_FOR_USERNAME, EAD_IMPORT_WRITE_PRIVE, EAD_IMPORT_WRITE_OPTIONS

NO_USERNAME_IN_PASSWORD = CHECK_FOR_USERNAME

# options de parsing
DATA_TYPE = [('sconet', 'Sconet'),
             ('aaf', 'AAF'),
             ('be1d', 'ONDE/BE1D'),
             ('csv2', 'Texte'),
            ]

CATEGORIES = dict(
sconet=[('eleve', "élèves et responsables"),
        ('eleve_ss_resp', "élèves seulement"),
        ('enseignant', "enseignants et personnels administratifs"),],
aaf=[('eleve',"élèves et responsables"),
     ('eleve_ss_resp', "élèves seulement"),
     ('enseignant', "enseignants et personnels administratifs"),],
be1d=[('eleve_ss_resp', "élèves"),
      ('eleve', "élèves et responsables"),
     ],
csv2=[('eleve_ss_resp', "élèves"),
      ('enseignant', "enseignants"),
      ('administratif', "personnels administratifs"),
      ('autre', "comptes invités"),
     ]
)

SCONET_FILES = dict(eleve=(
        ('eleve', """Fichier Sconet Eleves<br />
(ExportXML_ElevesSansAdresses.zip ou ElevesSansAdresses.xml)""",),
        ('nomenclature', """Fichier Sconet Nomenclature<br />
(ExportXML_Nomenclature.zip ou Nomenclature.xml)""",),
        ('responsable', """Fichier Sconet Responsables<br />
(ExportXML_ResponsablesAvecAdresses.zip ou ResponsablesAvecAdresses.xml)""",),
        ('structure', """Fichier Sconet Structures<br />
(ExportXML_Structures.zip ou Structures.xml)""",),),
        eleve_ss_resp=(
        ('eleve', """Fichier Sconet Eleves<br />
(ExportXML_ElevesSansAdresses.zip ou ElevesSansAdresses.xml)""",),
        ('nomenclature', """Fichier Sconet Nomenclature<br />
(ExportXML_Nomenclature.zip ou Nomenclature.xml)""",),
        ('structure', """Fichier Sconet Structures<br />
(ExportXML_Structures.zip ou Structures.xml)""",),),
        enseignant=(
        ('enseignant',"Fichier STS Personnels<br />(exemple : sts_emp_xxx_xxx.xml)"),))

AAF_FILES = dict(eleve=(
        ('eleve', "Fichier AAF Eleves<br />(exemple : ENT_xxx_Eleve_0000.xml)"),
        ('responsable', "Fichier AAF Responsables<br />(ENT_xxx_PersRelEleve_0000.xml)")),
                 eleve_ss_resp=(
        ('eleve', "Fichier AAF Eleves<br />(exemple : ENT_xxx_Eleve_0000.xml)"),),
                 enseignant=(
        ('enseignant', "Fichier AAF Personnels<br />(exemple : ENT_xxx_PersEducNat_0000.xml)"),))

BE1D_FILES = dict(eleve_ss_resp=(
        ('eleve', "Fichier CSV ONDE/BE1D élèves<br />(exemple : CSVExtraction.csv)"),),
                  eleve=(
        ('eleve', "Fichier CSV ONDE/BE1D élèves<br />(exemple : CSVExtraction.csv)"),
        ('responsable', "Fichier CSV ONDE/BE1D responsables<br />(exemple : parents.csv)"),))

CSV2_FILES = dict(eleve_ss_resp=(
        ('eleve', "Fichier CSV Elèves<br />(exemple : eleves.csv)"),),
                  enseignant=(
        ('enseignant', "Fichier CSV Enseignants<br />(exemple : enseignants.csv)"),),
                 administratif=(
        ('administratif', "Fichier CSV des personnels administratifs<br />(exemple : personnels.csv)"),),
                 autre=(
        ('autre', "Fichier CSV des comptes invités<br />(exemple : comptes.csv)"),))

SCONET_FILEVARNAMES = dict(eleve=['eleve', 'nomenclature', 'responsable', 'structure'],
                           eleve_ss_resp=['eleve', 'nomenclature', 'structure'],
                           enseignant=['enseignant'])

AAF_FILEVARNAMES = dict(eleve=['eleve', 'responsable'],
                        eleve_ss_resp=['eleve'],
                        enseignant=['enseignant'])

BE1D_FILEVARNAMES = dict(eleve_ss_resp=['eleve'],
                         eleve=['eleve', 'responsable'])

CSV2_FILEVARNAMES = dict(eleve_ss_resp=['eleve'],
                         enseignant=['enseignant'],
                         administratif=['administratif'],
                         autre=['autre'])

TMP_DIR = '/usr/share/ead2/backend/tmp/importation'
REPORTS_DIR = '/var/lib/eole/reports'


# log pour debug
LOGFILE = '/var/log/eole/importation.log'
RAPPORTFILE = join(REPORTS_DIR, 'importation.txt')

# destination des fichier de synchronisation AAF
AAF_IMPORT_DIR = '/var/lib/eole/aaf'
# fichier listant tous les fichiers AAF associés au serveur (pour affichage dans l'agent de surveillance aaf)
AAF_LIST_AGENT = join(AAF_IMPORT_DIR, 'aaf_list.txt')
# fichier de notification des fichiers AAF réceptionnés (pour lancement depuis EAD)
AAF_LIST_EAD = join(AAF_IMPORT_DIR, 'aaf_files')

# nombres d'entrées à lire avant d'afficher un message
DEBUG_NUM = 100

# base Axiom pour le transfert
DB_DIR = join(TMP_DIR, 'import-scribe')

# préférences d'importation
PREF_FILES = dict(eleve=join(TMP_DIR, 'eleve.pref'),
                  enseignant=join(TMP_DIR, 'enseignant.pref'),
                  administratif=join(TMP_DIR, 'administratif.pref'),
                  responsable=join(TMP_DIR, 'responsable.pref'),
                  invite=join(TMP_DIR, 'invite.pref'),)
CSV_PREFIX = join(TMP_DIR, 'etabprefix.csv')

WRITE_OPTS = EAD_IMPORT_WRITE_OPTIONS
WRITE_PRIVE = EAD_IMPORT_WRITE_PRIVE == 'oui'
# fichiers de listing des comptes
DEFAULT_USER="admin"
DEST_DIR = "/home/a/admin/perso/importation"
ELE_INFO = join(TMP_DIR, 'eleves.csv')
ELE_HEADER = "CLASSE;NOM;PRENOM;LOGIN;MOT DE PASSE;NUMERO ELEVE;INE;"
RES_INFO = join(TMP_DIR, 'responsables.csv')
RES_HEADER = "CIVILITE;NOM;PRENOM;LOGIN;MOT DE PASSE;ADRESSE;CODE POSTAL;VILLE;PAYS;"
RES_HEADER += ";".join(["PELEVE%d;NELEVE%d;CELEVE%d" % (num, num, num) for num in range(1, 4)])
ENS_INFO = join(TMP_DIR, 'enseignants.csv')
ENS_HEADER = "NOM;PRENOM;LOGIN;MOT DE PASSE"
ADM_INFO = join(TMP_DIR, 'administratifs.csv')
ADM_HEADER = "NOM;PRENOM;LOGIN;MOT DE PASSE"
INV_INFO = join(TMP_DIR, 'invites.csv')
INV_HEADER = "NOM;PRENOM;LOGIN;MOT DE PASSE"
