#!/usr/bin/env python3
# -*- coding: UTF-8 -*-

#########################################################
# utilitaire d'attribution des modeles Windows pour Scribe
# licence GPL Eole
# Joël Cuissinat <joel.cuissinat@ac-dijon.fr>
#########################################################

###################
# modules importés
###################
import sys
import ldap
from os import system
from scribe.backend_conf import *
import os
from creole import parsedico

#####################
# variables globales
#####################
passwd = ldap_passwd
dicoEole = parsedico.parse_dico()

domaine = dicoEole['domaine_messagerie_etab']

tmpl = """dn:%s
changetype: modify
add: mail
mail: %s@%s

"""


## liste des groupes
def main():
    ldif = ""
    try:
        query=ldap.open(serveur)
        query.simple_bind_s("cn=admin,o=gouv,c=fr", passwd)
        result_g=query.search_s("o=gouv, c=fr", ldap.SCOPE_SUBTREE, \
               "(&(objectclass=posixGroup)(!(mail=*)))")
        query.unbind()	
    except:
        result_g=[]
    
    for g in result_g:
        name = g[1]['cn'][0]
        if os.path.isdir('/var/lib/sympa/expl/i-%s/%s' % (domaine,name.lower())):
            ldif += tmpl % (g[0], name, 'i-'+domaine)
        elif os.path.isdir('/var/lib/sympa/expl/%s' % name.lower()):
            ldif += tmpl % (g[0], name, domaine)

    if ldif != "":
        cmd = "echo \""+ldif+"\" | ldapadd -x -D cn=admin,o=gouv,c=fr -w "+ldap_passwd +" > /dev/null 2>&1 "
        r = system(cmd)
        if r != 0 :
            if r==17408 :
                print("erreur d'ajout ldif")
            elif r==5120 :
                print("erreur de modification ldif")
            else :
                print("erreur inconnue sur lors de la modification LDAP")
        

if __name__ == "__main__":
    main()

