# coding: utf-8
import pwd
import sys
from os.path import isdir, join, islink, realpath
from glob import glob
from os import makedirs, stat
from shutil import rmtree
from posix1e import ACL

import pathvnc
from scribe import login

#homedir doit etre dans home pour les ACLs
homedir = '/home/tmp'
workgroupdir = '/home/workgroups/devoirs'

if isdir(homedir):
    #le repertoire doit ne pas exister puisqu'on le manipule ...
    print('Le repertoire %s existe, supprimer le avant de lancer ce test' % \
            homedir)
    sys.exit(1)

def setup_function(function):
    makedirs(homedir)

def teardown_function(function):
    rmtree(homedir)

def test_devdir_eleve():
    try:
        info=pwd.getpwnam('eole')
        user = 'eole'
    except:
        info=pwd.getpwnam('scribe')
        user = 'scribe'
    uid = info.pw_uid
    userclass = 'eleve'
    login.gen_devdir(user, uid, homedir, userclass)

    wgdir = join(workgroupdir, user)
    if isdir(wgdir):
        raise Exception('Le repertoire %s ne doit pas exister' % wgdir)

    dirnames = set([join(homedir, 'devoirs'), join(homedir, 'perso')])
    assert set(glob(join(homedir, '*'))) == dirnames
    assert glob(join(homedir, 'devoirs', '*')) == []
    assert glob(join(homedir, 'devoirs', '.*')) == []
    dirname = [join(homedir, 'perso', 'devoirs')]
    assert glob(join(homedir, 'perso', '*')) == dirname
    assert glob(join(homedir, 'perso', 'devoirs', '*')) == []
    assert glob(join(homedir, 'perso', 'devoirs', '.*')) == []
    assert stat(homedir).st_mode == 16877
    assert stat(homedir).st_uid == 0
    assert stat(homedir).st_gid == 0
    assert stat(join(homedir, 'perso')).st_mode == 16872
    assert stat(join(homedir, 'perso')).st_uid == 0
    assert stat(join(homedir, 'perso')).st_gid == 0
    for dirname in [join(homedir, 'devoirs'),
            join(homedir, 'perso', 'devoirs')]:
        assert stat(dirname).st_mode == 16888
        assert stat(dirname).st_uid == uid
        assert stat(dirname).st_gid == 0

    a=ACL(file=homedir)
    b="user::rwx\ngroup::r-x\nother::r-x\n"
    assert str(a) == b

    a=ACL(file=join(homedir, 'devoirs'))
    b='user::rwx\nuser:%s:rwx\ngroup::r-x\nmask::rwx\nother::---\n' % user
    assert str(a) == b

    a=ACL(file=join(homedir, 'perso'))
    b='user::rwx\ngroup::r-x\nother::---\n'
    assert str(a) == b

    a=ACL(file=join(homedir, 'perso', 'devoirs'))
    b='user::rwx\nuser:%s:rwx\ngroup::r-x\nmask::rwx\nother::---\n' % user
    assert str(a) == b

def test_devdir_enseignant():
    try:
        info=pwd.getpwnam('eole')
        user = 'eole'
    except:
        info=pwd.getpwnam('scribe')
        user = 'scribe'
    uid = info.pw_uid
    userclass = 'enseignant'
    wgdir = join(workgroupdir, user)
    assert not isdir(wgdir)

    login.gen_devdir(user, uid, homedir, userclass)
    dirnames = set([join(homedir, 'devoirs'), join(homedir, 'perso')])
    assert set(glob(join(homedir, '*'))) == dirnames

    dirname = join(homedir, 'devoirs', '.distribues')
    assert glob(join(homedir, 'devoirs', '*')) == []
    assert glob(join(homedir, 'devoirs', '.*')) == [dirname]
    assert islink(dirname)
    assert realpath(dirname) == wgdir

    dirname = [join(homedir, 'perso', 'devoirs')]
    assert glob(join(homedir, 'perso', '*')) == dirname

    dirname = join(homedir, 'perso', 'devoirs', '.distribues')
    assert glob(join(homedir, 'perso', 'devoirs', '*')) == []
    assert glob(join(homedir, 'perso', 'devoirs', '.*')) == [dirname]
    assert islink(dirname)
    assert realpath(dirname) == wgdir

    assert stat(homedir).st_mode == 16877
    assert stat(homedir).st_uid == 0
    assert stat(homedir).st_gid == 0
    assert stat(join(homedir, 'perso')).st_mode == 16872
    assert stat(join(homedir, 'perso')).st_uid == 0
    assert stat(join(homedir, 'perso')).st_gid == 0
    for dirname in [join(homedir, 'devoirs'),
            join(homedir, 'perso', 'devoirs')]:
        assert stat(dirname).st_mode == 16888
        assert stat(dirname).st_uid == uid
        assert stat(dirname).st_gid == 0

    assert stat(homedir).st_mode == 16877
    assert stat(homedir).st_uid == 0
    assert stat(homedir).st_gid == 0

    a=ACL(file=homedir)
    b="user::rwx\ngroup::r-x\nother::r-x\n"
    assert str(a) == b

    a=ACL(file=join(homedir, 'devoirs'))
    b='user::rwx\nuser:%s:rwx\ngroup::r-x\nmask::rwx\nother::---\n' % user
    assert str(a) == b

    a=ACL(file=join(homedir, 'perso'))
    b='user::rwx\ngroup::r-x\nother::---\n'
    assert str(a) == b

    a=ACL(file=join(homedir, 'perso', 'devoirs'))
    b='user::rwx\nuser:%s:rwx\ngroup::r-x\nmask::rwx\nother::---\n' % user
    assert str(a) == b

    a=ACL(file=wgdir)
    b='user::rwx\nuser:%s:rwx\ngroup::---\nmask::rwx\nother::---\n' % user
    assert str(a) == b

    rmtree(wgdir)

def test_devdir_administratif():
    try:
        info=pwd.getpwnam('eole')
        user = 'eole'
    except:
        info=pwd.getpwnam('scribe')
        user = 'scribe'
    uid = info.pw_uid
    userclass = 'administratif'
    login.gen_devdir(user, uid, homedir, userclass)

    assert glob(join(homedir, '*')) == []

    wgdir = join(workgroupdir, user)
    assert not isdir(wgdir)
