# -*- coding: UTF-8 -*-
from os.path import isfile
from pyeole.process import system_out

def test_admin():
    """
    Vérification des groupes AD pour admin
    """
    groups = system_out(['id', 'admin'])[1]
    assert '(domain admins)' in groups
    assert '(professeurs)' in groups

def test_eole_workstation_manager():
    """
    Vérification des groupes AD pour eole-workstation-manager
    """
    groups = system_out(['id', 'eole-workstation-manager'])[1]
    assert '(domain users)' in groups
    assert '(domain admins)' not in groups

def test_eole_workstation_reader():
    """
    Vérification des groupes AD pour eole-workstation-reader
    """
    groups = system_out(['id', 'eole-workstation-reader'])[1]
    assert '(domain users)' in groups

def test_gpo_addc():
    """
    Vérification des groupes AD pour gpo-addc (EOLE >= 2.7.2)
    """
    groups = system_out(['id', 'gpo-addc'])[1]
    assert '(domain admins)' in groups
    assert '(gpoadmins)' in groups

def test_eole_sasl():
    """
    Vérification des groupes AD pour eole-sasl (EOLE >= 2.8.0)
    """
    if isfile('/etc/saslauthd.conf'):
        groups = system_out(['id', 'eole-sasl'])[1]
        assert '(domain users)' in groups
