# -*- coding: UTF-8 -*-
from os import unlink
from os.path import join
from creole.client import CreoleClient
from pyeole.process import system_out, system_code

dico = CreoleClient().get_creole()

def test_php_cli():
    """
    Vérifie la fonctionnalité short_open_tag (#15534)
    """
    if dico['activer_apache'] == 'oui':
        fname = 'tmp/phpcli'
        clifile = open(join('/', dico['container_path_web'], fname), 'w+')
        clifile.write("<? echo 'OK'; ?>")
        clifile.close()
        assert system_out(['php', join('/', fname)], container='web')[1] == 'OK'
        unlink(join('/', dico['container_path_web'], fname))

def test_php_imap():
    """
    Vérifie que l'extension imap est bien activée (#16874)
    """
    if dico['activer_apache'] == 'oui':
        fname = 'tmp/phpimap'
        clifile = open(join('/', dico['container_path_web'], fname), 'w+')
        clifile.write("<? imap_errors(); ?>")
        clifile.close()
        assert system_code(['php', join('/', fname)], container='web') == 0
        unlink(join('/', dico['container_path_web'], fname))
