#!/usr/bin/env python3
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
script pour ajouter un groupe sur Scribe
"""

import sys
import getopt
from scribe.eolegroup import Group
from scribe.errors import LdapExistingGroup
from scribe.eoletools import is_empty

def main():
    """
    boucle principale
    """
    try:
        options, args = getopt.getopt(sys.argv[1:],
            'g:t:n:l:m:prdh',
            ['groupe=',
            'type=',
            'niveau=',
            'liste=',
            'mail=',
            'partage',
            'readonly',
            'donnees',
            'help'])

    except getopt.GetoptError:
        er_type, er_value, er_traceback = sys.exc_info()
        er_msg = str(er_value)
        sys.exit("l'option -%s est inconnue ou nécessite un argument" % er_msg[er_msg.index('-')+1])

    groupe = {}
    for (opt, val) in options:
        # nom du groupe
        if (opt == '-g') or (opt == '--groupe'):
            groupe['name'] = val.lower()
        # avec partage (lecture seule élève)
        if (opt == '-r') or (opt == '--readonly'):
            groupe['partage'] = 'ro'
        # avec partage (RW membres)
        if (opt == '-p') or (opt == '--partage'):
            groupe['partage'] = 'rw'
        # avec partage (donnees/travail)
        if (opt == '-d') or (opt == '--donnees'):
            groupe['partage'] = 'dt'
        # avec liste (domaine restreint/internet)
        if (opt == '-l') or (opt == '--liste'):
            groupe['domaine'] = val
        # type du groupe
        if (opt == '-t') or (opt == '--type'):
            groupe['_type'] = val
        # niveau associé à la classe
        if (opt == '-n') or (opt == '--niveau'):
            groupe['niveau'] = val
        # mail du propriétaire de la liste (DEPRECATED)
        #if (opt == '-m') or (opt == '--mail'):

        # et... l'aide
        elif (opt == '-h') or (opt == '--help'):
            sys.exit("""options :
                -g nom du groupe
                -t type du groupe (Classe|Niveau|Matiere|Groupe|Option|Service)
                [-p (avec partage RW)]
                [-r (avec partage RO)]
                [-d (avec partage donnees/travail)]
                [-l domaine si liste (restreint|internet)]
                [-n niveau associé (si type=Classe)]
                -h (aide)
                """)

    for arg in ['name', '_type']:
        if is_empty(groupe, arg):
            print("Erreur : Il manque un argument obligatoire (%s)" % arg)
            sys.exit(1)

    if groupe['_type'] == 'Classe' and is_empty(groupe, 'niveau'):
        print("Erreur : Il manque le niveau associé à la classe")
        sys.exit(1)

    ldapgroup = Group()
    try:
        ldapgroup.add(**groupe)
    except LdapExistingGroup:
        print("Erreur : Le nom %(name)s n'est pas disponible" % groupe)
        sys.exit(1)
    except Exception as msg:
        print("Erreur : %s" % str(msg))
        sys.exit(1)

    print("Le groupe %(name)s a été ajouté" % groupe)
    sys.exit(0)

if __name__ == "__main__":
    main()
