#!/bin/bash

. /etc/eole/samba4-vars.conf

if [[ $# < 3  ]]
then
    echo "La commande prend trois arguments : un nom d’utilisateur, une action parmi verifies, adds ou deletes, et le chemin vers un fichier csv contenant les enregistrements DNS"
    exit 1
fi

user="$1"
action="$2"
dns_entries="$3"
LOG_FILE="$(realpath ${dns_entries}.log)"

echo "$(date) : Création du fichier de log pour le fichier $dns_entries" > $LOG_FILE

if [[ -z "$user" ]]
then
    echo "Nom de l’utilisateur nécessaire"
    exit 1
fi

if [[ -z "$action" ]]
then
    echo "Action nécessaire"
fi

if [[ -z "$dns_entries" ]]
then
    echo "Fichier des entrées DNS nécessaire"
    exit 1
fi

function verifies {
    server_name=$1
    dns_records="$(samba-tool dns query ${AD_HOST_NAME} ${AD_REALM} @ ALL | awk '$1=="CNAME:" || $1=="A:" { gsub(/:/,"",$1); gsub(/Name=/,"",f); print $1 "," f $2} {f=$1}' | awk -v server_name="$server_name" '{if ($0 ~ server_name) {print $1 $2}}')"
    echo $dns_records
    if [ -n "$dns_record" ]
    then
        return 1
    else
        return 0
    fi
}

function exists {
    if verifies $1 2>&1 >/dev/null
    then
        echo "$1 n’existe pas dans le DNS"
        return 0
    else
        echo "$1 existe dans le DNS"
        return 1
    fi
}

function deletes {
    server_name=$1
    records="$(verifies $server_name)"
    if [ -n "$records" ]
    then
        for record in $records
        do
            echo "Suppression de l’enregistrement $record avec la commande samba-tool dns delete ${AD_HOST_NAME} ${AD_REALM} $record_name $record_type $record_data -k yes" >> $LOG_FILE
            read record_type record_name record_data <<< $(echo $record | awk -F',' '{print $1, $2, $3}')
            samba-tool dns delete ${AD_HOST_NAME} ${AD_REALM} $record_name $record_type $record_data -k yes
        done
    fi
}

function adds {
    server_name=$1
    shift
    ip=$1
    shift
    cnames="$@"
    deletes $server_name
    echo "Ajout de l’enregistrement de type A pour $server_name avec la commande samba-tool dns add ${AD_HOST_NAME} ${AD_REALM} $server_name A $ip -k yes" >> $LOG_FILE
    samba-tool dns add ${AD_HOST_NAME} ${AD_REALM} $server_name A $ip -k yes
    if [[ -n "$cnames" ]]
    then
        for cname in $cnames
        do
            echo "Ajout de l’enregistrement $cname avec la commande samba-tool dns adds ${AD_HOST_NAME} ${AD_REALM} $cname.${AD_REALM} CNAME $server_name.${AD_REALM} -k yes" >> $LOG_FILE
            samba-tool dns add ${AD_HOST_NAME} ${AD_REALM} $cname.${AD_REALM} CNAME $server_name.${AD_REALM} -k yes
        done
    fi
}

kinit $user

if [[ $? -ne 0 ]]
then
    exit 1
fi


while read dns_entry server_name ip cname
 do
     server_name=$(echo $dns_entry | cut -d';' -f1)
     ip=$(echo $dns_entry | cut -d';' -f2)
     cnames="$(echo $dns_entry | cut -d';' -f3 | cut -d',' -f1- --output-delimiter=' ' )"
case "$action" in
    'verifies')
        echo "Lancement de la commande verifies par l’utilisateur $user avec les données $dns_entry" >> $LOG_FILE
        exists $server_name
        ;;
    'adds')
        echo "Lancement de la commande adds par l’utilisateur $user avec les données $dns_entry" >> $LOG_FILE
        deletes $server_name

        adds $server_name $ip "$cnames"
        ;;
    'deletes')
        echo "Lancement de la commande deletes par l’utilisateur $user avec les données $dns_entry" >> $LOG_FILE
        deletes $server_name $ip "$cnames"
        ;;
    *)
        echo "L’action $action n’est pas prise en charge."
        ;;
esac
 done < "$dns_entries"

 echo "$(date) : Fermeture du fichier de log pour le fichier $dns_entries" >> $LOG_FILE

exit 0
