# Utilisation des couleurs et autres
. /usr/lib/eole/ihm.sh

opt=$1
if [ "${opt^^}" == "-F" ]
then
	FullSync="--full-sync"
fi

Domaine=$(CreoleGet ad_domain)
Racine=$(ldbsearch -H /var/lib/samba/private/sam.ldb '(&(objectclass=OrganizationalUnit))'|grep dn|grep Control|cut -d, -f2-)

#recuperation des serveurs
#srv=( $(host -t SRV _ldap._tcp.${Domaine}.ad.e2.rie.gouv.fr| cut -d" " -f8 | cut -d. -f1) )
srv=( $(ldbsearch -H /var/lib/samba/private/sam.ldb '(&(objectclass=Computer))'| perl -p00e 's/\r?\n //g'|grep serverReferenceBL | cut -d"," -f1| cut -d"=" -f2) )

#definition serveur source
serv_source=$(hostname)
serv_source=${serv_source^^}

#initialisation des partitions
partition=("${Racine}" "DC=ForestDnsZones,${Racine}" "CN=Configuration,${Racine}" "DC=DomainDnsZones,${Racine}" "CN=Schema,CN=Configuration,${Racine}")

echo
EchoGras "Les contrôleurs du domaine :"
for ((i=0 ; ${#srv[*]} - $i ; i++))
do
	if [ "${srv[i]}" != $serv_source ] ; then
		printf ".  %${len_pf}s " "- contrôleur"
		EchoVert "n° $i -> "${srv[i]}
	fi
done

echo
EchoCyan "Replication de $serv_source"
EchoCyan "vers quel n° de DC ? (aucun n° => replication vers tous les DCs)"
read destination

echo
EchoGras "Les partitions du domaine :"
for ((i=0 ; ${#partition[*]} - $i ; i++))
do
	printf ".  %${len_pf}s " "- partition"
	EchoVert "n° $i -> "${partition[i]}
done

echo
EchoCyan "n° de la partition à repliquer ? (aucun n° => replication de toutes les partitions)"
read num_repl

echo
EchoGras "=========================================================================================="
EchoGras "REPLICATION du"
printf ".  %${len_pf}s " "serveur source => "
EchoVert $serv_source
#
EchoGras "          vers"
if [ ${destination} ]
then
	serv_dest="${srv[${destination}]}"
	printf ".  %${len_pf}s " "serveur destination => "
	EchoVert $serv_dest
else
	printf ".  %${len_pf}s " "TOUS les serveurs"
	echo
fi
#
EchoGras "           de"
if [ ${num_repl} ]
then
	part_repl="${partition[${num_repl}]}"
	printf ".  %${len_pf}s " "la partition => "
	EchoVert $part_repl
else
	printf ".  %${len_pf}s " "TOUTES les partitions"
	echo
fi
#
echo
if [ ${FullSync} ]
then
	EchoGras "AVEC l'option --full-sync"
else
	EchoGras "SANS l'option --full-sync"
fi
EchoGras "=========================================================================================="

echo

if [ ${destination} ]
then
	# replication vers un seul serveur
	serv_dest="${srv[${destination}]}"
	EchoCyan "REPLICATION DU SERVEUR ${serv_source} VERS LE SERVEUR ${serv_dest} de :"

	if [ ${num_repl} ]
	then
		# replication d une seule partition
		part_repl="${partition[${num_repl}]}"
		echo
		EchoCyan "- la partition => ${part_repl}"
		printf ".  %${len_pf}s " ; EchoGras "samba-tool drs replicate $serv_dest $serv_source ${part_repl} ${FullSync}"
		echo
		d1=$(date +%s) ; samba-tool drs replicate $serv_dest $serv_source ${part_repl} ${FullSync} ; d2=$(date +%s)
		EchoVert "durée => "$(($d2-$d1))" secondes"
		echo
	else
		# replication de toutes les partitions
		echo
		EchoCyan "- la partition => Domaine : ${Racine}"
		printf ".  %${len_pf}s " ; EchoGras "samba-tool drs replicate $serv_dest $serv_source ${Racine} ${FullSync}"
		echo
		d1=$(date +%s) ; samba-tool drs replicate $serv_dest $serv_source ${Racine} ${FullSync} ; d2=$(date +%s)
		EchoVert "durée => "$(($d2-$d1))" secondes"
		echo

		EchoCyan "- la partition => DC=ForestDnsZones,${Racine}"
		printf ".  %${len_pf}s " ; EchoGras "samba-tool drs replicate $serv_dest $serv_source DC=ForestDnsZones,${Racine} ${FullSync}"
		echo
		d1=$(date +%s) ; samba-tool drs replicate $serv_dest $serv_source DC=ForestDnsZones,${Racine} ${FullSync} ; d2=$(date +%s)
		EchoVert "durée => "$(($d2-$d1))" secondes"
		echo

		EchoCyan "- la partition => DC=Configuration,${Racine}"
		printf ".  %${len_pf}s " ; EchoGras "samba-tool drs replicate $serv_dest $serv_source CN=Configuration,${Racine} ${FullSync}"
		echo
		d1=$(date +%s) ; samba-tool drs replicate $serv_dest $serv_source CN=Configuration,${Racine} ${FullSync} ; d2=$(date +%s)
		EchoVert "durée => "$(($d2-$d1))" secondes"
		echo

		EchoCyan "- la partition => DC=DomainDnsZones,${Racine}"
		printf ".  %${len_pf}s " ; EchoGras "samba-tool drs replicate $serv_dest $serv_source DC=DomainDnsZones,${Racine} ${FullSync}"
		echo
		d1=$(date +%s) ; samba-tool drs replicate $serv_dest $serv_source DC=DomainDnsZones,${Racine} ${FullSync} ; d2=$(date +%s)
		EchoVert "durée => "$(($d2-$d1))" secondes"
		echo

		EchoCyan "- la partition => CN=Schema,CN=Configuration,${Racine}"
		printf ".  %${len_pf}s " ; EchoGras "samba-tool drs replicate $serv_dest $serv_source CN=Schema,CN=Configuration,${Racine} ${FullSync}"
		echo
		d1=$(date +%s) ; samba-tool drs replicate $serv_dest $serv_source CN=Schema,CN=Configuration,${Racine} ${FullSync} ; d2=$(date +%s)
		EchoVert "durée => "$(($d2-$d1))" secondes"
		echo
	fi
else
	# replication vers TOUS les serveurs
	for ((i=0 ; ${#srv[*]} - $i ; i++))
	do
		if [ "${srv[i]}" != $serv_source ] ; then
			serv_dest="${srv[i]}"
			echo
			EchoCyan "REPLICATION DU SERVEUR ${serv_source} VERS LE SERVEUR ${serv_dest} de :"
			echo
			if [ ${num_repl} ]
			then
				# replication d une seule partition
				part_repl="${partition[${num_repl}]}"
				EchoCyan "- la partition => ${part_repl}"
				printf ".  %${len_pf}s " ; EchoGras "samba-tool drs replicate $serv_dest $serv_source ${part_repl} ${FullSync}"
				echo
				d1=$(date +%s) ; samba-tool drs replicate $serv_dest $serv_source ${part_repl} ${FullSync} ; d2=$(date +%s)
				EchoVert "durée => "$(($d2-$d1))" secondes"
				echo
			else
				# replication de toutes les partitions
				EchoCyan "Partition => Domaine : ${Racine}"
				printf ".  %${len_pf}s " ; EchoGras "samba-tool drs replicate $serv_dest $serv_source ${Racine} ${FullSync}"
				echo
				d1=$(date +%s) ; samba-tool drs replicate $serv_dest $serv_source ${Racine} ${FullSync} ; d2=$(date +%s)
				EchoVert "durée => "$(($d2-$d1))" secondes"
				echo

				EchoCyan "Partition => DC=ForestDnsZones,${Racine}"
				printf ".  %${len_pf}s " ; EchoGras "samba-tool drs replicate $serv_dest $serv_source DC=ForestDnsZones,${Racine} ${FullSync}"
				echo
				d1=$(date +%s) ; samba-tool drs replicate $serv_dest $serv_source DC=ForestDnsZones,${Racine} ${FullSync} ; d2=$(date +%s)
				EchoVert "durée => "$(($d2-$d1))" secondes"
				echo

				EchoCyan "Partition => DC=Configuration,${Racine}"
				printf ".  %${len_pf}s " ; EchoGras "samba-tool drs replicate $serv_dest $serv_source CN=Configuration,${Racine} ${FullSync}"
				echo
				d1=$(date +%s) ; samba-tool drs replicate $serv_dest $serv_source CN=Configuration,${Racine} ${FullSync} ; d2=$(date +%s)
				EchoVert "durée => "$(($d2-$d1))" secondes"
				echo

				EchoCyan "Partition => DC=DomainDnsZones,${Racine}"
				printf ".  %${len_pf}s " ; EchoGras "samba-tool drs replicate $serv_dest $serv_source DC=DomainDnsZones,${Racine} ${FullSync}"
				echo
				d1=$(date +%s) ; samba-tool drs replicate $serv_dest $serv_source DC=DomainDnsZones,${Racine} ${FullSync} ; d2=$(date +%s)
				EchoVert "durée => "$(($d2-$d1))" secondes"
				echo

				EchoCyan "Partition => CN=Schema,CN=Configuration,${Racine}"
				printf ".  %${len_pf}s " ; EchoGras "samba-tool drs replicate $serv_dest $serv_source CN=Schema,CN=Configuration,${Racine} ${FullSync}"
				echo
				d1=$(date +%s) ; samba-tool drs replicate $serv_dest $serv_source CN=Schema,CN=Configuration,${Racine} ${FullSync} ; d2=$(date +%s)
				EchoVert "durée => "$(($d2-$d1))" secondes"
				echo
			fi
			EchoCyan "****************************************************************************"
		fi
	done
fi

exit
