#!/bin/bash

# Utilisation des couleurs et autres
. /usr/lib/eole/ihm.sh

# Initialisation variables
# Fichier de configuration des comptes administrateurs psin et pnesr
Fichier="ConfAdmins.cf"
# Groupe à traiter
Groupe="admin-psin"
# Groupes d'appartenance
ListeGroupes=("Denied RODC Password Replication Group" "DnsAdmins")
# Compte psin pour la supervision
Compte_psin="psin"

# Récupération du dn du domaine
dnDomaine="$(ldbsearch -H /var/lib/samba/private/sam.ldb '(&(objectclass=OrganizationalUnit)(ou=Services))' cn | awk '/dn: / {print $2}'|cut -d, -f2-)"

# Création du compte Compte_psin s'il n'existe pas
echo
EchoVert "Creation du compte $Compte_psin"
Existe_Compte_psin=$(samba-tool user list|grep -i ${Compte_psin})
if [ -z "$Existe_Compte_psin" ]; then 
	# creation du compte
	res=$(samba-tool user create $Compte_psin password='$eole&123456$')
	ret=${?}
	if [ ${ret} -eq 0 ] ; then 
		printf ".  %$((len_pf+1))s creation => OK\n"
		# son mot de passe n'expire jamais
		res=$(samba-tool user setexpiry $Compte_psin --noexpiry)
		ret=${?}
		if [ ${ret} -eq 0 ] ; then printf ".  %$((len_pf+1))s son mot de passe n'expire jamais => OK\n" ; fi
	fi
	EchoRouge "!!!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!!!"
	EchoRouge "!!!! Il faudra modifier le mot de passe du compte $Compte_psin avec les outils RSAT !!!!"
	EchoRouge "!!!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!!!"
else
	printf ".  %$((len_pf+1))s Le compte $Compte_psin existe déjà => OK\n"
	printf ".  %$((len_pf+1))s Aucune modification n'est faite sur ce compte\n"
fi
echo

# Creation du groupe s'il n'existe pas
EchoVert "Creation du groupe $Groupe"
Existe_Groupe=$(samba-tool group list|grep -i ${Groupe})
if [ -z "$Existe_Groupe" ]; then 
	res=$(samba-tool group add $Groupe)
	ret=${?}
	if [ ${ret} -eq 0 ] ; then printf ".  %$((len_pf+1))s creation => OK\n" ; fi
else
	printf ".  %$((len_pf+1))s le groupe existe deja => OK\n"
fi
echo

# Ajout des comptes listés dans "Fichier" pour le "Groupe"
if [ -f $Fichier ]; then
	EchoVert "Initilisation du groupe $Groupe"
    while read line
    do
		compte=$(echo $line|cut -d" " -f1)
		GroupeFichier=$(echo $line|cut -d" " -f2)
		if [ "$GroupeFichier" = "$Groupe" ]; then
			Existe_Compte=$(samba-tool user list|grep -i ${compte})
			if [ -z "$Existe_Compte" ]; then
				EchoRouge "Le compte $compte n'existe pas"
			else
				printf ".  %$((len_pf+1))s ajout de $compte dans le groupe $Groupe\n"
				res=$(samba-tool group addmembers $Groupe $compte)
				ret=${?}
				#EchoRouge "retour commande ${ret}"
			fi
		fi
    done < $Fichier
else
    EchoRouge "Le fichier $Fichier n'existe pas"
    exit 1
fi
echo

# Ajout du "Groupe" dans les groupes listés dans "ListeGroupes"
EchoVert "Ajout de $Groupe dans le groupe :"
for index in "${!ListeGroupes[@]}"
	do
		echo "- ${ListeGroupes[$index]}"
		res=$(samba-tool group addmembers "${ListeGroupes[$index]}" $Groupe)
		if [ ${ret} -eq 0 ] ; then printf ".  %$((len_pf+1))s ajout => OK\n"; fi
	done
echo

exit 0

