﻿##./#REQUIRES -Version 4.0

<#
.SYNOPSIS
    Script de changement de droit des répertoires utilisateurs
.DESCRIPTION
    ...
.NOTES
    File Name      : changeright.ps1
    Author         : Emmanuel Garette (egarette@cadoles.com)
    Requires       : PowerShell V4
.EXAMPLE
    Example 1
.EXAMPLE
    Example 2
#>

function reportStatus
{
    <#
        .DESCRIPTION
        Append message to file, creating it if non existent.

        .PARAMETER message
        Message to write.
    #>
        param([string]$message)
        $statusfile = "changeright.txt"
        write-host $message
        if (Test-Path $statusfile)
        {
                $message | Add-Content $statusfile
        }
        else
        {
                $message | Set-Content $statusfile
        }
}


function changedirectoryrights
{
    <#
        .DESCRIPTION
        Change rights for the HOME user directory

        .PARAMETER Path
        Directory path

        .PARAMETER Old_sid
        OLD SID number

        .PARAMETER username
        Name of user

        .EXAMPLE
        reportMigrationStatus '\\FILER\rapport\migration_OK' 'my_computer`t192.168.0.10'
    #>
    param([string]$Path, [string]$Old_sid, [string]$username)
    $Inherit = [System.Security.AccessControl.InheritanceFlags]"ContainerInherit,ObjectInherit"
    #$Inherit = [System.Security.AccessControl.InheritanceFlags]"ContainerInherit"
    $Propagation = [System.Security.AccessControl.PropagationFlags]"None"
    #$Propagation = [System.Security.AccessControl.PropagationFlags]"InheritOnly"
    
    ##########################################
    $Acl = (Get-item $Path).GetAccessControl('Access')
    # Remove old access
    $found = $false
    foreach($Access in $Acl.Access) {
        if($Access.IdentityReference.Value -eq $Old_sid) {
            reportStatus "Suppression des droits pour $Old_sid sur le répertoire $Path"
            $Acl.RemoveAccessRuleAll($Access) | Out-Null
            $found = $true
        }
    }
    # Add new access only if old SID is found
    if($found -eq $true) {
        $Ar = New-Object System.Security.AccessControl.FileSystemAccessRule($Username, 'FullControl', $Inherit, $Propagation, 'Allow')
        #$objUser = New-Object System.Security.Principal.NTAccount("Cadoles", $Username)
        #$Acl.SetOwner($objUser)
        $Acl.SetAccessRule($Ar)
        $Acl.SetAccessRuleProtection($true, $false)
        reportStatus "Ajout des droits pour $Username sur le répertoire $Path"
        Set-Acl -Path $Path -AclObject $Acl
    }
}

function changeregistryrights
{
   <#
        .DESCRIPTION
        Change rights in registery

        .PARAMETER Path
        Directory path

        .PARAMETER Old_sid
        OLD SID number

        .PARAMETER username
        Name of user

        .EXAMPLE
        reportMigrationStatus '\\FILER\rapport\migration_OK' 'my_computer`t192.168.0.10'
    #>
    param([string]$Path, [string]$Old_sid, [string]$username, [string]$Path_dat)
    ###############################
    $Path_reg = "hklm\sourceuser"
    $Path_acl = "hklm:\sourceuser"
    $Inherit2 = [System.Security.AccessControl.InheritanceFlags]"ContainerInherit"
    #$Inherit2 = [System.Security.AccessControl.InheritanceFlags]"ContainerInherit,ObjectInherit"
    $Propagation = [System.Security.AccessControl.PropagationFlags]"None"
    #$Propagation = [System.Security.AccessControl.PropagationFlags]"InheritOnly"
    reg load $Path_reg $Path_dat
    $Ar = New-Object System.Security.AccessControl.RegistryAccessRule($Username, 'FullControl', $Inherit2, $Propagation, 'Allow')
    $Acl = Get-Acl -path "$Path_acl"
    $found = $false
    foreach($Access in $Acl.Access) {
        if($Access.IdentityReference.Value -eq $Old_sid) {
            reportStatus "Suppression des droits pour $Old_sid dans $Path_dat"
            $Acl.RemoveAccessRule($Access) | Out-Null
            $found = $true
        }
    }
    # Add new access only if old sid is found
    if($found -eq $true) {
        $Acl.AddAccessRule($Ar)
        $Acl.SetAccessRuleProtection($true, $false)
        reportStatus "Ajout des droits pour $Username dans $Path_dat"
        Set-Acl -Path "$Path_acl" -AclObject $Acl
    }
    do {
        Start-Sleep -s 10
        # Déchargement de la base de registre
        reg unload $Path_reg | Out-Null
    } while (test-path $Path_acl)
}

function removefiles
{
<#
        .DESCRIPTION
        Append message to file, creating it if non existent.

        .PARAMETER Path
        Path to HOME directory
    #>
    param([string]$Path)
    reportStatus "suppression de fichiers dans le profile"
    Remove-Item "$Path\NTUSER.DAT.L*" | Out-Null
    Remove-Item "$Path\NTUSER.DAT.{*" | Out-Null
    Remove-Item "$Path\AppData\Local\Microsoft\Windows\usrclass*" | Out-Null
}
function copyregistry{
<#
        .DESCRIPTION
        Append message to file, creating it if non existent.

        .PARAMETER Old_sid
        Old SID for user.

        .PARAMETER New_sid
        Message to write.
    #>
    param([string]$Old_sid, [string]$New_sid)
    # Sauvegarge et copie de la clef de registre puis modification du SID
    $KEY_ROOT = "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion"
    $ProfileList = "$KEY_ROOT\ProfileList"
    $Old_sid_path = "$ProfileList\$Old_sid"
    $New_sid_path = "$ProfileList\$New_sid"
    if((Test-Path $Old_sid_path) -And -Not (Test-Path $New_sid_path)) {
        reportStatus "Copie les clefs de registre $Old_sid_path vers $New_sid"
        Copy-Item "$Old_sid_path" -Destination "$old_sid_path.old"
        Rename-Item -Path "$Old_sid_path" -NewName $New_sid
        #Remove-Item "$Old_sid_path.old"
        $ProfileGUID = Get-ItemPropertyValue -Path "$Old_sid_path" -Name Guid
        if ($ProfileGUID) {
            reportStatus "changement de la valeur de $KEY_ROOT\ProfileGuid\$ProfileGUID"
            New-ItemProperty -Path "$KEY_ROOT\ProfileGuid\$ProfileGUID" -Name "SidString" -value $New_sid -Force
        } else {
            reportStatus "la clé $Old_sid_path/Guid est vide ou inexistante"
        }
    }
}

function getoldsid {
<#
        .DESCRIPTION
        Get OLDSID in registry

        .PARAMETER Path
        HOME for an user.
    #>
    param([string]$Path)
    $ProfileList = "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\ProfileList"
    $found = $false
    Get-ChildItem -Path "$ProfileList" | ForEach-Object {
        if($found -eq $false) {
            $old_sid = ([io.fileinfo]"$_").basename
            $homedir = $false
            if(Test-Path "$ProfileList\$old_sid") {
                $homedir = (Get-ItemProperty -Path "$ProfileList\$old_sid" -Name "ProfileImagePath").ProfileImagePath
            }
            if(Test-Path "$ProfileList\$old_sid.old") {
                $homedir = (Get-ItemProperty -Path "$ProfileList\$old_sid.old" -Name "ProfileImagePath").ProfileImagePath
            }
            if($homedir -eq $Path) {
                $found = $true
                return $old_sid
                
            }
        }
    }
}
function changeright
{
<#
        .DESCRIPTION
        Change right

        .PARAMETER Domain
        Domain name.

        .PARAMETER Username
        Name of user.

        .PARAMETER Path
        HOME PATH.
    #>
    param([string]$Domain, [string]$Username, [string]$Path)
    $found = $false
    Try {
        $objUser = New-Object System.Security.Principal.NTAccount($Domain, $Username)
        $New_sid = $objUser.Translate([System.Security.Principal.SecurityIdentifier]).Value
        $found = $true
    } Catch {
        reportStatus "utilisateur $Username inconnu dans le domaine $Domain"
    }
    if($found -eq $true) {
        $Old_sid = getoldsid "$Path"
        if(-Not $Old_sid) {
            reportStatus "impossible de retrouver l'ancien SID de $Username"
        } elseif ($New_sid -eq $Old_sid) {
            reportStatus "impossible de migrer $Username le SID est identique ($Old_sid)"
        } else {
            reportStatus "migration de $Username avec l'ancien SID $Old_sid vers le nouveau $New_sid"
            changeregistryrights "$Path" "$Old_sid" "$Username" "$Path\NTUSER.DAT"
            changeregistryrights "$Path" "$Old_sid" "$Username" "$Path\appdata\local\microsoft\windows\usrclass.DAT"
            changedirectoryrights "$Path" "$Old_sid" "$Username"
            removefiles "$Path"
            copyregistry "$Old_sid" "$New_sid"
            # Ajoute l'utilisateur au groupe Utilisateurs
            net localgroup /add Utilisateurs "$Domain\$Username"
            #Add-LocalGroupMember -Group Utilisateurs -Member  "$Domain\$Username"
        }
    }
}

function Main() {
    $Domain = (Get-WmiObject Win32_ComputerSystem).Domain
    Get-ChildItem -Path "c:\Users" | ForEach-Object {
        $basename = $_.BaseName
        $fullname = $_.fullname
        changeright "$Domain" "$basename" "$fullname"
    }
}

Main
#exit 0
