#!/bin/bash
. /usr/lib/eole/ihm.sh

#debut agu
LogUsersNoExist="/tmp/initPasswords-UsersNoExist-$(date +'%Y-%m-%d-%Hh%Mmn%Ss').log"
LogMachinesExist="initPasswords-MachinesExist-$(date +'%Y-%m-%d-%Hh%Mmn%Ss').log"
LogMachinesNew="initPasswords-MachinesNew-$(date +'%Y-%m-%d-%Hh%Mmn%Ss').log"
#fin agu

LDIF=$(mktemp)
PWDSCRIPT=$(mktemp)
DRYRUN=0
ENCODE=0

function usage()
{
   echo "usage: $(basename $0) -i inputfile.txt inputfile.txt -b /var/samba/dbfile.ldb"
   echo "       options : -d dry run don't do anything and don't cleanup temporary files"
   echo "       options : -e enable base64 encoding of the objectSID"
   return 0
}

while getopts :i:b:hde FLAG; do
  case $FLAG in
    i)  #set option "i"
      INPUT=$OPTARG
      ;;
    b)  #set option "b"
      DBFILE=$OPTARG
      ;;
	e) ENCODE=1 ;;
	d) DRYRUN=1 ;;
    h)  #show help
      usage
      exit 1
      ;;
    \?) #unrecognized option - show help
      echo -e \\n"Option -${BOLD}$OPTARG${NORM} not allowed."
      usage
      exit 2
      ;;
  esac
done

if [[ -z ${INPUT} ]]
then
	usage
	echo "Input files are mandatory"
	exit 1
fi

if [[ -z ${DBFILE} ]]
then
	usage
	echo "Database file is mandatory"
	exit 1
fi

for file in ${INPUT}
do
	EchoVert "**** Exploitation du fichier ${file} ****"
	while read -r line
	do
		data=(${line//;/ })
		machine=0
		#si $ en fin de chaine data[0] alors c'est une machine => machine=1
		[[ "${data[0]: -1}" == "$" ]] && machine=1
		if [[ ${machine} -eq 1 ]]
		then
			# Test d'affichage du compte machine => si le retour de la commande ( ${ret} ) est egal a 0 la machine existe
			res=$(samba-tool computer show ${data[0]} 2>&1 /dev/null )
			ret=${?}
			if [ ${ret} -ne 0 ]
			then
				# Creation du compte machine car le compte n'existe pas MAIS PAS de modification SID et mot de passe
				if [[ ${DRYRUN} -eq 0 ]]
				then
					echo "Création compte ${data[0]}"
					samba-tool computer create ${data[0]}  > /dev/null
				else
					echo "samba-tool computer create ${data[0]}"
				fi
				# Fin de creation des comptes machines
				echo "Creation du compte machine ${data[0]} " >> ${LogMachinesNew}
			else
				# Pas de creation du compte machine car le compte existe déjà
				echo "Machine ${data[0]} déja existante => pas de creation">>${LogMachinesExist}
			fi
		else
			# Gestion des comptes utilisateurs
			# Pas de creation de compte pour les utilisateurs MAIS modification SID et mot de passe
			#
			# recherche du dn de l'utilisateur
			dn=$(samba-tool user getpassword ${data[0]} --attributes dn 2> /dev/null | head -1)
			if [[ ${#dn} -ne 0 ]]
			then
				pwd=${data[1]}
				if [[ ${ENCODE} -eq 1 ]]
				then
					sid=$(echo ${data[2]} | base64)
				else
					sid=${data[2]}
				fi
				if [[ -n ${dn} ]] && [[ -n ${sid} ]]
				then
					#Création du fichier ${LDIF} pour modification du SID
					echo -e "${dn}\nchangetype: modify\nreplace: objectSid\nobjectSid: ${sid}\n" >> ${LDIF}
					#
					#Création du fichier ${PWDSCRIPT} pour modification du mot de passe
					echo "pdbedit -d 0 --set-nt-hash=${pwd} ${data[0]}" >> ${PWDSCRIPT}
				fi
			else
				EchoRouge "utilisateur inexistant : ${data[0]}"
				echo "utilisateur inexistant : ${data[0]}">> ${LogUsersNoExist}
			fi
			# Fin de gestion des comptes utilisateurs
		fi
	done < "${file}"
	
	#debut agu
	#
	if [[ ${machine} -eq 0 ]]
	then
		if [[ ${DRYRUN} -eq 0 ]]
		then
			# Changement de SID
			EchoVert "**** Changement de SID ****"
			ldbmodify -v -H "${DBFILE}" ${LDIF}
			# Changement de mot de passe
			EchoVert "**** Changement de mot de passe ****"
			EchoOrange "Attente ... en cours ..."
			source ${PWDSCRIPT} |grep "Unix username"|cut -d":" -f2
			rm -rf ${LDIF}
			rm -rf ${PWDSCRIPT}
		else
			cat ${LDIF}
			cat ${PWDSCRIPT}
			echo "ldif file is : ${LDIF}"
			echo "password script is ${PWDSCRIPT}"
		fi
	fi
	#fin agu
	echo
done

