#!/bin/bash

# Utilisation des couleurs et autres
. /usr/lib/eole/ihm.sh

Domaine=$(CreoleGet ad_domain)

DnDomaine=$(ldbsearch -H /var/lib/samba/private/sam.ldb '(&(objectclass=OrganizationalUnit))'|grep dn|grep Control|cut -d, -f2-)
Racine="OU=Services,"$DnDomaine

Niveau=$1
Suffixe="OU="$Niveau","$Racine

if [ -f $Domaine.ldif ] ; then rm -f $Domaine.ldif ; fi

if [ $2 == "-i" ]
then
	echo
	#	Début de l'indexation de l attribut Destination-Indicator
	#
	# !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!! ATTENTION !!!
	#   L'indexation de l attribut Destination-Indicator est déplacée dans le script "add_admin-PNESR.sh"
	#   => on indexe ainsi avec un domaine synchronise avec le ldap et donc des comptes !
	#
	#EchoVert "Indexation de l attribut Destination-Indicator pour le domaine $Domaine"
		#Indexation de l'attribut Destination-Indicator :
		# - Cet attribut fait le lien entre un objet AD et un objet LDAP
		# - son indexation optimise les performances de mise à jour par le script PNE-AM
	#echo "dn: CN=Destination-Indicator,CN=Schema,CN=Configuration,"$DnDomaine > searchflagsDI.ldif
	#echo "changetype: modify" >> searchflagsDI.ldif
	#echo "replace: searchFlags" >> searchflagsDI.ldif
	#echo "searchFlags: 1" >> searchflagsDI.ldif
	#fichier_schema=$(ls -l /var/lib/samba/private/sam.ldb.d/ |grep SCHEMA|awk '{print $NF}')
	#res=$(ldbmodify -H "/var/lib/samba/private/sam.ldb.d/"$fichier_schema searchflagsDI.ldif)
	#ret=${?}
	#if [ ${ret} -eq 0 ] ; then 
	#	printf ".  %$((len_pf+1))s indexation => OK\n"
	#else
	#	EchoRouge "Erreur d indexation sur le fichier $fichier_schema"
	#fi
	#
	#echo
	#   Fin de l'indexation de l attribut Destination-Indicator
	#
	# On supprime le fichier $Domaine-bak.ldif s il existe car on est dans l initialisation et il ne doit pas y avoir de bak
	if [ -f $Domaine-bak.ldif ] ; then rm -f $Domaine-bak.ldif ; fi
	
	# Politique de mot de passe du domaine
	#
	# Durée minimum avant de pouvoir changer son mot de passe (0 = pas de duree)
	samba-tool domain passwordsettings set --min-pwd-age=0
	# Duree maximum d un mot de passe apres laquelle l utilisateur doit le changer (0 = illimite, ici 245 jours)
	samba-tool domain passwordsettings set --max-pwd-age=245
	# Longueur minimale du mot de passe
	samba-tool domain passwordsettings set --min-pwd-length=8
	
	# Création du groupe integrateurs
	Groupe="integrateurs"
	EchoVert "Creation du groupe $Groupe"
	Existe_Groupe=$(samba-tool group list|grep -i ${Groupe})
	if [ -z "$Existe_Groupe" ]; then 
		res=$(samba-tool group add $Groupe)
		ret=${?}
		if [ ${ret} -eq 0 ] ; then printf ".  %$((len_pf+1))s création => OK\n" ; fi
	else
		printf ".  %$((len_pf+1))s le groupe existe deja => OK\n"
	fi
	echo

	# INITIALISATION DE LA FORET
	# Création du 1er niveau OU=Services,OU=$Niveau avec la sous OU Defaut
	test=`ldbsearch -H /var/lib/samba/private/sam.ldb '(&(objectclass=OrganizationalUnit))'|grep "dn: OU=Services"`

	EchoVert "Création des OU avec leurs sous-OU Amande, HorsAmande et Machines"
    if [ -z "$test" ]
    then
		printf ".  %$((len_pf+1))s - $Racine\n"
        echo "dn: "$Racine >> $Domaine.ldif
    	echo "objectClass: organizationalUnit" >> $Domaine.ldif
    	echo "" >> $Domaine.ldif
    fi
	#
	printf ".  %$((len_pf+1))s - $Suffixe\n"
	echo "dn: "$Suffixe >> $Domaine.ldif
	echo "objectClass: organizationalUnit" >> $Domaine.ldif
	echo "" >> $Domaine.ldif
	printf ".  %$((len_pf+1))s - OU=Defaut,$Suffixe\n"
	echo "dn: OU=Defaut,"$Suffixe >> $Domaine.ldif
	echo "objectClass: organizationalUnit" >> $Domaine.ldif
	echo "" >> $Domaine.ldif
	echo "dn: OU=Amande,OU=Defaut,"$Suffixe >> $Domaine.ldif
	echo "objectClass: organizationalUnit" >> $Domaine.ldif
	echo "" >> $Domaine.ldif
	echo "dn: OU=HorsAmande,OU=Defaut,"$Suffixe >> $Domaine.ldif
	echo "objectClass: organizationalUnit" >> $Domaine.ldif
	echo "" >> $Domaine.ldif
	echo "dn: OU=Machines,OU=Defaut,"$Suffixe >> $Domaine.ldif
	echo "objectClass: organizationalUnit" >> $Domaine.ldif
	echo "" >> $Domaine.ldif
	#
	shift 2	# Pour ne pas prendre en compte dans les parametres l'option "-i" ou "-a" et la variable de 1er niveau $1
	#
	for unite in "$@"
	# Boucle pour créer les sous-OU sur le même principe que le 1er niveau Defaut
	do
	   printf ".  %$((len_pf+1))s - OU=$unite,$Suffixe\n"
	   echo "dn: OU=$unite,"$Suffixe >> $Domaine.ldif
	   echo "objectClass: organizationalUnit" >> $Domaine.ldif
	   echo "" >> $Domaine.ldif
	   echo "dn: OU=Amande,OU=$unite,"$Suffixe >> $Domaine.ldif
	   echo "objectClass: organizationalUnit" >> $Domaine.ldif
	   echo "" >> $Domaine.ldif
	   echo "dn: OU=HorsAmande,OU=$unite,"$Suffixe >> $Domaine.ldif
	   echo "objectClass: organizationalUnit" >> $Domaine.ldif
	   echo "" >> $Domaine.ldif
	   echo "dn: OU=Machines,OU=$unite,"$Suffixe >> $Domaine.ldif
	   echo "objectClass: organizationalUnit" >> $Domaine.ldif
	   echo "" >> $Domaine.ldif
	done
	# Application du fichier ldif cree precedemment
	res=$(ldbmodify -H /var/lib/samba/private/sam.ldb $Domaine.ldif)
	ret=${?}
	if [ ${ret} -eq 0 ] ; then 
		printf ".  %$((len_pf+1))s création => OK\n"
	else
		EchoRouge "Erreur dans la création (voir fichier $Domaine.ldif ou $Domaine-bak.ldif)"
	fi
	echo
	#
	# Gestion des fichiers ldif
	if [ -f $Domaine-bak.ldif ]
	then
		# Si le fichier $Domaine-bak.ldif existe
		# on concatene les fichiers $Domaine.ldif et $Domaine-bak.ldif dans le fichier $Domaine-bak.ldif
		# et on supprime le fichier $Domaine.ldif qui va être cree par la suite du script
		cat $Domaine-bak.ldif $Domaine.ldif >> $Domaine-bak2.ldif
		#rm -f $Domaine.ldif $Domaine-bak.ldif
		rm -f $Domaine-bak.ldif
		mv $Domaine-bak2.ldif $Domaine-bak.ldif
	else
		# On renomme $Domaine.ldif en $Domaine-back.ldif
		# le fichier $Domaine.ldif va être cree par la suite du script
		cp $Domaine.ldif $Domaine-bak.ldif
	fi
	# Fin de gestion des fichiers ldif
	#
	# Creation des groupes de 1er niveau
	EchoVert "Création des groupes de OU=Defaut,OU=$Niveau,OU=Services"
	res=$(samba-tool group add $Niveau"-Defaut-OUADM" --groupou="OU=Defaut,OU="$Niveau",OU=Services")
	ret=${?}
	if [ ${ret} -eq 0 ] ; then 
		printf ".  %$((len_pf+1))s création de $Niveau-Defaut-OUADM => OK\n"
	else 
		EchoRouge "Erreur dans la création de $Niveau-Defaut-OUADM"
	fi
	res=$(samba-tool group add $Niveau"-Defaut-PCADM" --groupou="OU=Defaut,OU="$Niveau",OU=Services")
	ret=${?}
	if [ ${ret} -eq 0 ] ; then 
		printf ".  %$((len_pf+1))s création de $Niveau-Defaut-PCADM => OK\n"
	else 
		EchoRouge "Erreur dans la création de $Niveau-Defaut-PCADM"
	fi
	res=$(samba-tool group add $Niveau"-Defaut-SRVADM" --groupou="OU=Defaut,OU="$Niveau",OU=Services")
	ret=${?}
	if [ ${ret} -eq 0 ] ; then 
		printf ".  %$((len_pf+1))s création de $Niveau-Defaut-SRVADM => OK\n"
	else 
		EchoRouge "Erreur dans la création de $Niveau-Defaut-SRVADM"
	fi
	printf "%$((len_pf+1))s Ajout du groupe $Niveau-Defaut-PCADM comme membre du groupe integrateurs\n"
	# Ajout du groupe "Services-Defaut-PCADM" comme membre du groupe integrateurs
	res=$(samba-tool group addmembers integrateurs $Niveau"-Defaut-PCADM")
	ret=${?}
	if [ ${ret} -eq 0 ] ; then printf ".  %$((len_pf+1))s ajout => OK\n\n"; else printf ".  %$((len_pf+1))s ajout => " ; EchoRouge "Erreur !!!" ; echo ; fi
	# Creation des groupes de sous-niveau
	for unite in "$@"
	do
		EchoVert "Création des groupes de OU=$unite,OU=$Niveau,OU=Services"
		res=$(samba-tool group add $Niveau"-"$unite"-OUADM" --groupou="OU="$unite",OU="$Niveau",OU=Services")
		ret=${?}
		if [ ${ret} -eq 0 ] ; then 
			printf ".  %$((len_pf+1))s création de $Niveau-$unite-OUADM => OK\n"
		else 
			EchoRouge "Erreur dans la création de $Niveau-$unite-OUADM"
		fi
		res=$(samba-tool group add $Niveau"-"$unite"-PCADM" --groupou="OU="$unite",OU="$Niveau",OU=Services")
		ret=${?}
		if [ ${ret} -eq 0 ] ; then 
			printf ".  %$((len_pf+1))s création de $Niveau-$unite-PCADM => OK\n"
		else 
			EchoRouge "Erreur dans la création de $Niveau-$unite-PCADM"
		fi
		res=$(samba-tool group add $Niveau"-"$unite"-SRVADM" --groupou="OU="$unite",OU="$Niveau",OU=Services")
		ret=${?}
		if [ ${ret} -eq 0 ] ; then 
			printf ".  %$((len_pf+1))s création de $Niveau-$unite-SRVADM => OK\n"
		else 
			EchoRouge "Erreur dans la création de $Niveau-$unite-SRVADM"
		fi
		# Ajout du groupes "Services-"$unite"-PCADM" comme membre du groupe integrateurs
		printf "%$((len_pf+1))s Ajout du groupe $Niveau-$unite-PCADM comme membre du groupe integrateurs\n"
		res=$(samba-tool group addmembers integrateurs $Niveau"-"$unite"-PCADM")
		ret=${?}
		if [ ${ret} -eq 0 ] ; then printf ".  %$((len_pf+1))s ajout => OK\n\n"; else printf ".  %$((len_pf+1))s ajout => " ; EchoRouge "Erreur !!!" ;echo ; fi
	done
elif [ $2 == "-a" ]
then
	# AJOUT D'UNITE(S) ET DES GROUPES CORRESPONDANTS A LA FORET EXISTANTE
	#
	shift 2	# pour ne pas prendre en compte dans les parametres l'option "-i" ou "-a" et la variable de 1er niveau $1
	#
	echo
	EchoVert "Création des OU avec leurs sous-OU Amande, HorsAmande et Machines"
	for unite in "$@"
		# Boucle pour créer les sous-OU sur le même principe que le 1er niveau Defaut
	do
	   printf ".  %$((len_pf+1))s - OU=$unite,$Suffixe\n"
	   echo "dn: OU=$unite,"$Suffixe >> $Domaine.ldif
	   echo "objectClass: organizationalUnit" >> $Domaine.ldif
	   echo "" >> $Domaine.ldif
	   echo "dn: OU=Amande,OU=$unite,"$Suffixe >> $Domaine.ldif
	   echo "objectClass: organizationalUnit" >> $Domaine.ldif
	   echo "" >> $Domaine.ldif
	   echo "dn: OU=HorsAmande,OU=$unite,"$Suffixe >> $Domaine.ldif
	   echo "objectClass: organizationalUnit" >> $Domaine.ldif
	   echo "" >> $Domaine.ldif
	   echo "dn: OU=Machines,OU=$unite,"$Suffixe >> $Domaine.ldif
	   echo "objectClass: organizationalUnit" >> $Domaine.ldif
	   echo "" >> $Domaine.ldif
	done
	# Application du fichier ldif cree precedemment
	# Remarque : si aucune OU n'a été précisée dans la commande, soit ./add_unite.sh -a ,
	#            alors le fichier $Domaine.ldif n'existe pas et il n'y a donc rien à faire => d'où le test ci-dessous
	if [ -f $Domaine.ldif ] ; then 
		res=$(ldbmodify -H /var/lib/samba/private/sam.ldb $Domaine.ldif)
		ret=${?}
		if [ ${ret} -eq 0 ] ; then 
			printf ".  %$((len_pf+1))s création => OK\n"
		else
			EchoRouge "Erreur dans la création (voir fichier $Domaine.ldif ou $Domaine-bak.ldif)"
		fi
		echo
	fi
	#
	# Gestion des fichiers ldif
	if [ -f $Domaine-bak.ldif ]
	then
		# Si le fichier $Domaine-bak.ldif existe
		# on concatene les fichiers $Domaine.ldif et $Domaine-bak.ldif dans le fichier $Domaine-bak.ldif
		# et on supprime le fichier $Domaine.ldif qui va être cree par la suite du script
		cat $Domaine-bak.ldif $Domaine.ldif >> $Domaine-bak2.ldif
		#rm -f $Domaine.ldif $Domaine-bak.ldif
		rm -f $Domaine-bak.ldif
		mv $Domaine-bak2.ldif $Domaine-bak.ldif
	else
		# On renomme $Domaine.ldif en $Domaine-back.ldif
		# le fichier $Domaine.ldif va être cree par la suite du script
		mv $Domaine.ldif $Domaine-bak.ldif
	fi
	# Fin de gestion des fichiers ldif
	#
	# Creation des groupes de sous-niveau
	for unite in "$@"
	do
		EchoVert "Création des groupes de OU=$unite,OU=$Niveau,OU=Services"
		res=$(samba-tool group add $Niveau"-"$unite"-OUADM" --groupou="OU="$unite",OU="$Niveau",OU=Services")
		ret=${?}
		if [ ${ret} -eq 0 ] ; then 
			printf ".  %$((len_pf+1))s création de $Niveau-$unite-OUADM => OK\n"
		else 
			EchoRouge "Erreur dans la création de $Niveau-$unite-OUADM"
		fi
		res=$(samba-tool group add $Niveau"-"$unite"-PCADM" --groupou="OU="$unite",OU="$Niveau",OU=Services")
		ret=${?}
		if [ ${ret} -eq 0 ] ; then 
			printf ".  %$((len_pf+1))s création de $Niveau-$unite-PCADM => OK\n"
		else 
			EchoRouge "Erreur dans la création de $Niveau-$unite-PCADM"
		fi
		res=$(samba-tool group add $Niveau"-"$unite"-SRVADM" --groupou="OU="$unite",OU="$Niveau",OU=Services")
		ret=${?}
		if [ ${ret} -eq 0 ] ; then 
			printf ".  %$((len_pf+1))s création de $Niveau-$unite-SRVADM => OK\n"
		else 
			EchoRouge "Erreur dans la création de $Niveau-$unite-SRVADM"
		fi
		# Ajout du groupes "Services-"$unite"-PCADM" comme membre du groupe integrateurs
		printf "%$((len_pf+1))s Ajout du groupe $Niveau-$unite-PCADM comme membre du groupe integrateurs\n"
		res=$(samba-tool group addmembers integrateurs $Niveau"-"$unite"-PCADM")
		ret=${?}
		if [ ${ret} -eq 0 ] ; then printf ".  %$((len_pf+1))s ajout => OK\n\n"; else printf ".  %$((len_pf+1))s ajout => " ; EchoRouge "Erreur !!!" ;echo ; fi
	done
else
	# Aide a la syntaxe du script
	# Se lance quand on execute le script sans les options -i ou -a (mauvaise syntaxe)
	Clear
	EchoRouge ".  !!! Attention a la syntaxe de la commande !!!"
	echo
	printf ".  %${len_pf}s => " "Ne pas utiliser la commande de cette façon"
	EchoOrange "$0 $1 $2 $3 $4 $5 $6 $7 $8 $9"
	echo
	EchoGras "Syntaxe de la commande : l'option -i ou -a est obligatoire"
	printf ".  %${len_pf}s => " "soit "
	EchoVert "$0 [niveau] (-i ou -a) [parametre1] [parametre2] ...   avec niveau = Unite d'Organisation sous Services et parametreX = Unite d'Organisation X"
	printf ".  %${len_pf}s => " "     "
	EchoVert "                                                     - il n'y a pas lieu de preciser l'OU Defaut, seules les autres OU sont a preciser"
	printf ".  %${len_pf}s => " "     "
	EchoVert "                                                     - si pas de parametre (avec option -i), seule l'OU Defaut sera cree"
	echo
	printf ".  %${len_pf}s => " "Si initialisation de la foret"
	if [ $# = 0 ] ;	then EchoVert "$0 -i [parametre1] [parametre2] ..."; else EchoVert "$0 $1 -i $2 $3 $4 $5 $6 $7 $8 $9"; fi
	printf ".  %${len_pf}s => " "Si ajout d'unite a la foret existante"
	if [ $# = 0 ] ;	then EchoVert "$0 -a [parametre1] [parametre2] ..."; else EchoVert "$0 $1 -a $2 $3 $4 $5 $6 $7 $8 $9"; fi
	echo -e "\n"
fi
