#!/bin/bash

# monitoring de squid3
# base des oid pour squid3 : "1.3.6.1.4.1.3495.1"
# données à surveiller:
#   - Ko/s en entrée (http)
#   - Ko/s en sortie (http)
# à la sortie de snmpget, on obtient un résultat de la forme 'Counter32: 27278049'
# On supprime donc tout ce qui n'est pas numérique
container_path_proxy=$(CreoleGet container_path_proxy)
container_ip_proxy=$(CreoleGet container_ip_proxy)

# traffic http
snmpget -v2c -Ov -Pe -m ${container_path_proxy}/usr/share/squid3/mib.txt ${container_ip_proxy}:3401 -c public enterprises.3495.1.3.2.1.4 | cut -d" " -f 2
snmpget -v2c -Ov -Pe -m ${container_path_proxy}/usr/share/squid3/mib.txt ${container_ip_proxy}:3401 -c public enterprises.3495.1.3.2.1.5 | cut -d" " -f 2
# hit ratio
snmpget -v2c -Ov -Pe -m ${container_path_proxy}/usr/share/squid3/mib.txt ${container_ip_proxy}:3401 -c public enterprises.3495.1.3.2.2.1.9.5 | cut -d" " -f 2
snmpget -v2c -Ov -Pe -m ${container_path_proxy}/usr/share/squid3/mib.txt ${container_ip_proxy}:3401 -c public enterprises.3495.1.3.2.2.1.10.5 | cut -d" " -f 2
# requêtes servies par le cache
snmpget -v2c -Ov -Pe -m ${container_path_proxy}/usr/share/squid3/mib.txt ${container_ip_proxy}:3401 -c public enterprises.3495.1.3.2.1.10 | cut -d" " -f 2
snmpget -v2c -Ov -Pe -m ${container_path_proxy}/usr/share/squid3/mib.txt ${container_ip_proxy}:3401 -c public enterprises.3495.1.3.2.1.1 | cut -d" " -f 2
