#!/usr/bin/env python
# -*- coding: UTF-8 -*-

"""Etat global de la mémoire (df + mem)
"""

import os, commands
from utils import list_to_table
from agent import Agent
# fixme : mettre mem et df dans ce fichier
import mem, df

class Memory(Agent):
    def __init__(self):
        self.name="memoire"
        self.description="""Bilan global de la mémoire"""
        self.memoire = mem.MemAgent()
        self.dfree = df.DiskFree()
        Agent.__init__(self)
        # écriture dans les fichiers
        # self.write_html()
        # self.write_xml()

    HTML = """
<table>
<tr>
 <td>%s</td>
 <td>%s</td>
</tr>
</table>
"""

    def _dump_xml(self):
        """sortie en xml
        """
        # fixme règler l'append_mode de manière à ce que la déclaration xml
        # n'apparaisse pas
        resultat = self.dfree._dump_xml() + self.memoire._dump_xml()
        return resultat

    def _dump_html(self):
        """Formatage html du résultat 
        """
        return self.HTML % (
            self.dfree._dump_xml(), self.memoire._dump_xml()
                             )
    
if __name__ == "__main__":
    memory = Memory()
    print str(memory._dump_xml())
