#!/bin/bash
# sauvegarde des donnees utilisateurs d'un Amon2.0

SAVEDIR='/usr/share/ead2/backend/tmp/sauvegarde_migrations/'

# fichiers lies a ipset
IPSET_SAVEDIR=$SAVEDIR'ipset/'
GROUP_FILENAME='/usr/share/ead2/backend/tmp/ipset_group.txt'
SCHEDULE_FILENAME='/usr/share/ead2/backend/tmp/ipset_schedules.pickle'

# fichiers lies a era
ERA_SAVEDIR=$SAVEDIR'era/'
POSTE_FILENAME1='/var/www/ead/tmp/horaires_ip.txt'
POSTE_FILENAME2='/var/www/ead/tmp/poste.txt'
DESTINATION_FILENAME='/var/www/ead/tmp/destination.txt'
REGLES_FILENAME='/var/www/ead/tmp/regles.csv'

# fichiers lies a dansguardian
DANS_SAVEDIR=$SAVEDIR'dansguardian/'
FGROUPLIST_FILENAME='/var/lib/blacklists/local/filtergroupslist'
GREY_FILENAME='/var/lib/blacklists/local/liste_blanche/greysitelist'
FILTRES_OPT='/etc/squid/filtres-users'
FILTRAGE='/var/www/ead/tmp/filtrage-contenu'
BLACK_FILENAME='/var/lib/blacklists/local/domains'
WHITE_FILENAME='/var/lib/blacklists/local/white'
EXT_FILENAME='/var/lib/blacklists/local/extensions'
MIME_FILENAME='/var/lib/blacklists/local/types_mime'

# creation des reps de sauvegarde transitoire
if [ ! -d $SAVEDIR ]
then
    mkdir $SAVEDIR
    mkdir $IPSET_SAVEDIR
    mkdir $ERA_SAVEDIR
    mkdir $DANS_SAVEDIR
fi

# copie des fichies groupe de machine (ipset)
for filename in $GROUP_FILENAME $SCHEDULE_FILENAME
do
    if [ -f $filename ]
    then
        cp -rf $filename $IPSET_SAVEDIR
    else
        FNAME=`basename $filename`
        if [ $filename == '/usr/share/ead2/backend/tmp/ipset_group.txt' ]
        then
            touch $IPSET_SAVEDIR$FNAME
        else
            echo '(dp0' > $IPSET_SAVEDIR$FNAME
            echo '.' >> $IPSET_SAVEDIR$FNAME
        fi
    fi
done
# copie des fichiers destinations, postes (era)
for filename in $POSTE_FILENAME1 $POSTE_FILENAME2 $DESTINATION_FILENAME $REGLES_FILENAME
do
    if [ -f $filename ]
    then
        cp -rf $filename $ERA_SAVEDIR
    else
        FNAME=`basename $filename`
        touch $ERA_SAVEDIR$FNAME
    fi
done
# copie des fichiers listes d'interdits/autorises pour le filtrage web (dansguardian)
for filename in $FGROUPLIST_FILENAME $GREY_FILENAME $FILTRES_OPT  $FILTRAGE $BLACK_FILENAME $WHITE_FILENAME $EXT_FILENAME $MIME_FILENAME
do
    if [ -f $filename ]
    then
        cp -rf $filename $DANS_SAVEDIR
    else
        FNAME=`basename $filename`
        touch $DANS_SAVEDIR$FNAME
    fi
done
exit 0
EOF
