#!/usr/bin/env python
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# zephir_client.py
#
# script principal de lancement d'actions par zephir
#
###########################################################################

import time,os,sys,shutil
from zephir.eolerpclib import xmlrpclib
try:
    if not '/usr/share/eole/' in os.environ['PYTHONPATH'].split(':'):
        os.environ['PYTHONPATH'] = os.environ['PYTHONPATH']+':/usr/share/eole'
except KeyError:
    os.environ['PYTHONPATH'] = '/usr/share/eole'
try:
    import zephir.zephir_conf.zephir_conf as config
    from zephir.lib_zephir import *
except:
    print("\n** Ce serveur n'est pas enregistré sur Zephir **\n")
    sys.exit("Utilisez la procédure enregistrement_zephir\n")

import logging
from logging.handlers import TimedRotatingFileHandler

# répertoire publique d'uucp
public_dir = '/var/spool/uucppublic'
glb = globals()

def reconfigure(zephir_proxy, delay="", *args):
    sudo_script("reconfigure.zephir %s" % delay)

def configure(*args):
    sudo_script("config.zephir")

def update_key(zephir_proxy, regen="", *args):
    if regen != "regen_certs":
        regen == ""
    sudo_script("update_key.zephir %s" % regen)

def service_restart(zephir_proxy, service="", delay="", *args):
    sudo_script("service_restart.zephir %s %s" % (service, delay))

def maj_auto(zephir_proxy, time="", options="", *args):
    """fonction de mise à jour via zephir"""
    sudo_script("maj_auto.zephir %s %s" % (time, options))

def maj_client(zephir_proxy):
    """fonction de mise à jour via zephir"""
    sudo_script("maj_client.zephir")

def download_upgrade(zephir_proxy, version="2.3", time="", *args):
    """fonction de téléchargement des paquets pour préparer un Upgrade-Auto"""
    sudo_script("download_upgrade.zephir %s %s" % (version, time))

def del_lock(zephir_proxy, tag=['maj','configure','reconfigure','sauvegarde','uucp']):
    """retire le fichier lock passé en paramètre
    et met à jour les logs zephir"""
    if is_locked(tag):
        # suppression du verrou
        unlock(tag)
        # log sur zephir
        log('LOCK',0,'supression des verrous dans /var/lock')
    else:
        log('LOCK',0,'verrous dans /var/lock déjà supprimés')

def change_ip(*args):
    """prépare le changement d'adresse de zephir
    """
    sudo_script("change_ip.zephir")

def purge_ip(*args):
    """annule le changement d'adresse de zephir
    """
    sudo_script("purge_ip.zephir")

def lock_maj(zephir_proxy):
    sudo_script("lock-maj.zephir")

def save_files(zephir_proxy, mode = 0):
    """lance la procédure d'envoi de la configuration du serveur sur zephir"""
    sudo_script("save_files.zephir %s" % mode)

def call(zephir_proxy, *args):
    """fonction qui vide le répertoire temporaire et synchronise l'état du serveur par uucp"""
    # gestion du changement d'adresse de zephir
    if os.path.isfile(new_addr_file):
        if update_zephir_ip():
            # redémarrage du service z_stats pour prendre en compte la nouvelle adresse
            print "Redémarrage du service zephir_client pour prise en compte de la nouvelle adresse dans 1 minute"
            os.system('/bin/echo "/etc/init.d/z_stats restart" | /usr/bin/at now + "1 minutes"')
            return
    # on interroge zephir pour savoir si les verrous doivent être annulés
    try:
        if convert(zephir_proxy.uucp.unlock(config.id_serveur))[1] == True:
            # suppression des verrous zephir si présents
            del_lock(zephir_proxy)
            # on indique à zephir que les verrous sont supprimés
            convert(zephir_proxy.uucp.unlock(config.id_serveur,True))
    except:
        # erreur d'accès zephir ou fonction non implémentée
        pass
    # on vérifie qu'aucune tache n'a demandé un bloquage des fichiers
    if is_locked('sauvegarde'):
        print "verrou sur les tâches zephir détecté (/var/run/sauvegarde)"
        # cas où une sauvegarde est en cours, on ne fait rien (juste un log)
        log('LOCK',0,'taches zephir retardees : sauvegarde en cours')
    elif is_locked('uucp'):
        print "verrou sur les tâches zephir détecté (/var/run/uucp)"
        # cas d'une tâche non terminée, on saute un tour
        log('LOCK',1,'taches zephir retardees : verrou sur certaines taches zephir')
    else:
        # on commence par vérifier la liste des fonctions bloquées sur zephir
        try:
            locks = convert(zephir_proxy.serveurs.get_locks(config.id_serveur))
        except:
            # on ne bloque pas si cette phase échoue
            pass
        else:
            # mise en place du fichier de droits
            try:
                content = "\n".join([lock[0] for lock in locks[1]]) + "\n"
                file_lock = file(zephir_dir + "/zephir_locks","w")
                file_lock.write(content)
                file_lock.close()
            except:
                pass
        # on vide le spool uucp (évite l'envoi de plusieurs archives
        # de statistiques si il y a eu un pb de connexion avec zephir)
        try:
            shutil.rmtree("/var/spool/uucp/zephir")
        except:
            pass
        # FIXME loguer la réussite à chaque fois ??
        #log('LOCK',0,'aucun verrou dans /var/lock')
        # supression des fichiers et répertoires dans '/var/spool/uucppublic'
        fichiers = os.listdir(public_dir)
        for fic in fichiers:
            if os.path.isdir(public_dir+os.sep+fic):
                shutil.rmtree(public_dir+os.sep+fic)
            else:
                os.unlink(public_dir+os.sep+fic)
        # envoi par uucp de l'archive du site de diagnostic

        if not os.path.isfile('/tmp/site%s.tar' % config.id_serveur):
            log('SURVEILLANCE',1,'pas de données de surveillance (z_stats arrêté ?)')
            site_ok = 0
        else:
            site_ok = 1
            # signature md5 de l'archive
            cmd_md5 = """cd /tmp; /usr/bin/md5sum -b site%s.tar""" % config.id_serveur
            output = os.popen(cmd_md5)
            # lecture du résultat de la commande
            res_md5 = output.readlines()
            output.close()
            # envoi par uucp de l'archive du site de diagnostic
            cmd_uucp = """/usr/bin/uucp -r '/tmp/site%s.tar' 'zephir!~'""" % config.id_serveur
            res = os.system(cmd_uucp)

        # lancement de uucico pour l'envoi des fichiers
        # et la réception des commandes zephir
        print "\n   ** synchronisation Zephir en cours **"
        print "   -- Transfert des fichiers"
        try:
            # dans le cas de l'appel par crontab, on ajoute un délai
            # défini à l'enregistrement (aléatoire)
            if '--delay' in sys.argv:
                # attente aléatoire pour éviter la surcharge des connexions sur zephir
                time.sleep(round(1 + random.random()*40,2))
        except:
            # pas de délai demandé
            pass
        res=os.system('/usr/sbin/uucico --nouuxqt -S zephir')
        if res != 0:
            print "erreur lors du transfert par uucp (uulog pour plus de détails)"
        print "   -- Execution des commandes"
        res = os.system('/usr/sbin/uuxqt -s zephir')
        if res != 0:
            print "erreur lors de l'execution des commandes par uucp (uulog pour plus de détails)"
        else:
            print "   ** OK **\n"

        if site_ok:
            # vérification de l'archive et mise en place du site sur zephir
            try:
                # vérification de la version des agents
                new_agents = 1
                try:
                    from zephir.monitor.agentmanager import status
                except:
                    new_agents = 0
                res = convert(zephir_proxy.uucp.maj_site(config.id_serveur,res_md5,new_agents))
            except:
                # erreur de communication xmlrpc avec zephir
                # si on a déjà logué le pb, on ne le refait pas
                if os.path.isfile("/var/spool/uucp/no_contact.lock"):
                    pass
                else:
                    # on crée un fichier permettant de savoir qu'on a déjà logué la perte de contact
                    try:
                        f=file("/var/spool/uucp/no_contact.lock","w")
                        f.close()
                    except:
                        pass
                    log('SURVEILLANCE',1,'impossible de contacter le serveur zephir')
                try:
                    os.unlink('/tmp/site%s.tar' % config.id_serveur)
                except:
                    print "erreur de suppression de l'archive temporaire"
            else:
                if os.path.isfile("/var/spool/uucp/no_contact.lock"):
                    os.unlink("/var/spool/uucp/no_contact.lock")
                    log('SURVEILLANCE',0,'reprise du contact avec zephir')
                if res[0] != 1:
                    print 'erreur : '+res[1]
                    log('SURVEILLANCE',1,'erreur de mise en place des données de surveillance')
                else:
                    pass
                    # on ne logue pas la réussite
                    # log('SURVEILLANCE',0,'mise en place des données de surveillance terminée ')
                # on supprime l'archive une fois celle-ci envoyée
                try:
                    os.unlink('/tmp/site%s.tar' % config.id_serveur)
                except:
                    print "erreur de suppression de l'archive temporaire"


def main(exec_func=None):
    """ programme principal """
    if exec_func is None:
        try:
            exec_func=sys.argv[1]
            args = sys.argv[2:]
        except:
            sys.exit("donner la fonction à exécuter en argument")

    # sauvegarde du log de la dernière action
    os.system('/bin/chown -R uucp.uucp /var/log/zephir >/dev/null')
    # initialisation du logger
    logger = logging.getLogger('zephir-client')
    logger.setLevel(logging.INFO)
    trf_handler = TimedRotatingFileHandler('/var/log/zephir/zephir-client.log', when='D', interval=7, backupCount=4, encoding=None, delay=False, utc=False)
    trf_formatter = logging.Formatter("%(name)s - %(message)s")
    trf_handler.setFormatter(trf_formatter)
    logger.addHandler(trf_handler)

    if os.path.isfile('/var/log/zephir/last_action.log'):
        log_data = file('/var/log/zephir/last_action.log').read()
        if log_data.strip() != "":
            f_log = file('/var/log/zephir/actions.log','a+')
            f_log.write(log_data)
            f_log.close()
    try:
        # vidage du fichier avant exécution
        log_msg = "%s : zephir_client %s(%s)" % (time.ctime(), exec_func, ",".join(args))
        f_log = file("/var/log/zephir/last_action.log","w")
        if exec_func != 'call':
            f_log.write("\n%s\n%s\n" % (log_msg, "-"*len(log_msg)))
        else:
            print "\n%s\n%s\n" % (log_msg, "-"*len(log_msg))
        f_log.close()
        os.system('/bin/chown -R uucp.uucp /var/log/zephir >/dev/null')
    except:
        pass
    try:
        exec_args = [zephir_proxy] + args
        func = glb[exec_func]
        func(*exec_args)
        logger.info("{0}({1})".format(exec_func, ','.join(args)))
    except KeyError, e:
        # permettre l'execution de scripts externes
        script_name = exec_func + '.zephir'
        # la fonction n'existe pas, on regarde si un script avec ce nom existe
        # dans /usr/share/zephir/scripts
        if os.path.isfile(os.path.join(os.path.abspath(zephir_dir), "scripts", script_name)):
            sudo_script(script_name + " " + " ".join(args))
        else:
            log('ZEPHIR',1,"fonction ou script inconnu : %s" % exec_func)
            print "fonction ou script inconnu : %s" % exec_func


if __name__ == '__main__':
    main()
