# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# lib_zephir.py
#
# librairie de fonctions pour le client Zephir
#
###########################################################################

registered = 1
try:
    import zephir.zephir_conf.zephir_conf as config
except:
    registered = 0

import os, sys, time, socket, getpass
#FIXME 2.4 !!!
#from creole.cfgparser import EoleDict
#from creole.config import eole_module, rsyslog_request_template
#from creole.cert import gen_request, gen_privkey
from creole.client import CreoleClient, NotFoundError
from creole.config import eoledirs, eoleroot, distrib_dir, VIRTMASTER
from pyeole.ihm import print_orange, print_red, print_green, print_line
from pyeole.service import manage_service
from pyeole.process import system_code, system_out
from glob import glob
import traceback
# imports locaux
from zephir.eolerpclib import xmlrpclib, EoleProxy
from zephir.prelude_options import get_options

# valeurs par défaut pour la fonction de saisie d'enregistrement_zephir
defaults = {'timeout':30,'interf':'eth0'}

# définition de l'encodage du texte
charset = 'UTF-8'
# répertoire publique d'uucp
public_dir = '/var/spool/uucppublic'
# définition du proxy XMLRPC
eole_dir = '/usr/share/eole'
zephir_dir = '/usr/share/zephir'
new_addr_file = os.path.join(zephir_dir, 'zephir_conf', 'new_pubkey')
# mode de sauvegarde des données locales
save_modes = {0:"Tout",
              1:"configuration",
              2:"configuration + patchs/dicos/templates",
              3:"fichiers divers locaux",
             }
# variables
creole_vars = CreoleClient()

# recherche du répertoire du module zephir
import zephir as zephir_lib
zephir_path = os.path.dirname(zephir_lib.__file__)

# redéfinition de la classe pour supporter les timeouts
class TransportEole(xmlrpclib.SafeTransport):

    def _parse_response(self, file, sock):
        """lit et parse la réponse du serveur
        modifié pour ne pas bloquer sur la lecture (file.read)
        dans le cas de l'utilisation de ssl
        """
        # read response from input file/socket, and parse it

        p, u = self.getparser()

        while 1:
            if sock:
                response = sock.recv(1024)
            else:
                response = file.read(1024)
            if not response:
                break
            if self.verbose:
                print "body:", repr(response)
            p.feed(response)
            if len(response) < 1024:
                break

        file.close()
        p.close()

        return u.close()

try:
    if os.path.isfile('/etc/init.d/zephir'):
        # on permet un temps d'attente plus long lors des requêtes sur Zephir
        socket.setdefaulttimeout(180)
    else:
        # timeout réduit sur les serveurs clients pour éviter de bloquer le système
        socket.setdefaulttimeout(15)
except:
    # non implémenté sur python 2.2
    pass

if registered:
    zephir_proxy = EoleProxy("https://zephir:zephir@"+config.adresse_zephir+":7080", transport=TransportEole())
    # pour compatibilité avec des programmes externes
    zephir = zephir_proxy

def convert(objet):
    """Transforme les objets unicode contenus dans un objet en chaines
    """
    if type(objet) == list:
        l = []
        for item in objet:
            l.append(convert(item))
        return l
    if type(objet) == dict:
        dico = {}
        for cle in objet.keys():
            dico[cle] = convert(objet[cle])
        return dico
    if type(objet) == unicode:
        string =  objet.encode(charset)
        return string
    return objet

def u(objet):
    if type(objet) == list:
        l = []
        for item in objet:
            l.append(u(item))
        return l
    if type(objet) == dict:
        dico = {}
        for cle in objet.keys():
            dico[cle] = u(objet[cle])
        return dico
    if type(objet) == str:
        string = unicode(objet, charset)
        return string
    return objet

def flushed_input(msg):
    sys.stdout.write(msg)
    sys.stdout.flush()
    return sys.stdin.readline().strip()

def log(action, etat, msg, date=''):
    """fonction de log local et distant (si disponible) des actions zephir effectuées sur le serveur
    """
    # on insère le log actuel à la liste des logs à envoyer
    failed_logs = []
    ignored_logs = []
    if date == '':
        date = str(time.ctime())
    liste_logs = [[str(date), action, str(etat), msg]]
    # on regarde si il y a des logs différés (erreur de contact avec zephir lors d'un log précédent)
    try:
        fic_logs = open('%s/deffered_logs' % zephir_dir, 'r')
        # rqe : on limite à 20 le nombre d'anciens logs à remonter (pour éviter de bloquer trop longtemps)
        deffered_logs = fic_logs.read().strip().split('\n')
        if len(deffered_logs) > 20:
            old_logs = deffered_logs[:20]
            ignored_logs = deffered_logs[20:]
        else:
            old_logs = deffered_logs
        for log in old_logs:
            # on stocke ces logs dans la liste
            if log.count(';') > 0:
                liste_logs.append(log.split(';'))
        fic_logs.close()
    except:
        # le fichier n'existe pas
        # (tous les logs sont passés)
        pass

    erreur_zephir = 0
    # on essaie d'envoyer tous les logs via xmlrpc
    for log in liste_logs:
        if erreur_zephir == 0:
            # on n'essaie pas de réinsérer les logs suivants si il y a eu une erreur
            # (évite de répeter les timeouts de la connexion)
            try:
                date, action, etat, msg = log
                try:
                    msg = u(msg)
                except:
                    pass
                if log[0] != '':
                    res = zephir_proxy.uucp.log_serveur(config.id_serveur, u(date), u(action), int(etat), msg)
                else:
                    res = zephir_proxy.uucp.log_serveur(config.id_serveur, u(str(time.ctime())), u(action), int(etat), msg)
                if res[0] == 0:
                    # erreur d'insertion du log, mais zephir répond, on continue en stockant ce log
                    failed_logs.append(';'.join(log))
            except:
                # echec de la connexion à zephir
                # on stocke les informations de log dans le fichier deffered_logs
                # Ces logs seront parsés au prochain appel de cette fonction
                erreur_zephir = 1
                failed_logs.append(';'.join(log))
        else:
            failed_logs.append(';'.join(log))

    if ignored_logs != []:
        failed_logs.extend(ignored_logs)
    # on sauvegarde tous les logs non envoyés
    try:
        fic_logs=open('%s/deffered_logs' % zephir_dir, 'w')
        for log in failed_logs:
            fic_logs.write(log+'\n')
        fic_logs.close()
    except:
        # pas les droits pour écrire dans le fichier ?
        pass

    # Le log local est géré par les fonctions Zephir et Zecho
    return "ok"

# fonctions de verrouillage

lock_dir = '/var/lock'

def lock(tags):
    """fonction qui crée un ou plusieurs verrous"""
    retour = 1
    if os.path.isdir(lock_dir):
        if not type(tags) == list:
            tags = [tags]
        for tag in tags:
            try:
                fic_temp = open(lock_dir + os.sep + tag, "w").close()
            except:
                retour = 0
    else:
        retour = 0
    return retour

def unlock(tags):
    """fonction qui supprime un verrou"""
    try:
        if not type(tags) == list:
            tags = [tags]
        for tag in tags:
            if os.path.isfile(lock_dir+os.sep+tag):
                os.unlink(lock_dir+os.sep+tag)
    except:
        return 0
    return 1

def is_locked(tags):
    """fonction qui permet de savoir si un verrou particulier est posé"""
    if not type(tags) == list:
        tags = [tags]
    for tag in tags:
        if os.path.isfile(lock_dir+os.sep+tag):
            return 1
    else:
        return 0

def update_conf(id_serveur, adresse_zephir):
    """met à jour le fichier conf_zephir"""
    template_conf = """#!/usr/bin/env python
id_serveur=%s
adresse_zephir="%s"

if __name__ == "__main__":
    print adresse_zephir
"""
    try:
        conf = open(os.path.join(zephir_path, 'zephir_conf/zephir_conf.py'), 'w')
        conf.write(template_conf % (str(id_serveur), str(adresse_zephir)))
        conf.close()
        res = os.system('/bin/chmod 644 %s' % os.path.join(zephir_path, 'zephir_conf/zephir_conf.py'))
        assert res == 0
    except:
        return False
    if os.path.isfile(new_addr_file):
        os.unlink(new_addr_file)
    log('CONFIGURE', 0, """Nouvelle adresse de zephir prise en compte : %s""" % str(adresse_zephir))
    return True


def maj_client_zephir(zephir_proxy, adresse_zephir):
    """met à jour le client"""

    # on regarde si une mise à jour est nécessaire
    # récupération de la version locale
    out = os.popen('/usr/bin/dpkg -p zephir-client | grep ^Version')
    version_client = out.read().split(':')[1]
    out.close()
    version_client = "zephir-client_" + version_client.strip()
    res_maj = 2
    # vérification de la version présente sur zephir
    try:
        res = convert(zephir_proxy.maj_client(version_client))
    except Exception, e:
        # fonction de mise à jour non disponible sur cette version de zephir
        pass
    else:
        if res[0] == 0:
            print("pas de mise à jour disponible sur zephir")
        else:
            if res[1] != "OK":
                # une mise à jour est nécessaire
                rpm_client = res[1].encode(charset).strip()
                res_maj = os.system('%s/scripts/maj_client.sh %s %s' % (zephir_dir, adresse_zephir, rpm_client)) / 256
    return res_maj

def update_zephir_ip():
    """vérifie si zephir répond sur sa nouvelle adresse (envoyée auparavant via change_ip)
    """
    # lecture des données stockées (ancienne/nouvelle clé + nouvelle adresse)
    ssh_dir = "/var/spool/uucp/.ssh/"
    tmp_dir = os.path.join(ssh_dir, 'tmpkeys')
    data_new_key = file(new_addr_file).read().strip()
    old_key, new_key, new_addr = data_new_key.split('%%')
    try:
        proxy = EoleProxy("https://zephir:zephir@%s:7080" % (new_addr),transport=TransportEole())
        # demande de récupération de la nouvelle clé privée sur zephir. On doit envoyer les clés publiques (actuelle et nouvelle)
        code, res = convert(proxy.serveurs.get_key(config.id_serveur, old_key, new_key))
        if code == 0:
            log('CONFIGURE', 1, """Prise en compte de la nouvelle adresse (%s): clé non reconnue par zephir""" % (new_addr))
            return False
    except:
        return False
    fic_priv = os.path.join(tmp_dir, 'new_key')
    try:
        if os.path.exists(fic_priv):
            os.unlink(fic_priv)
        os.system('/bin/touch %s;/bin/chmod 600 %s' % (fic_priv, fic_priv))
        fichier = file(fic_priv, 'a')
        fichier.write(xmlrpclib.base64.decodestring(res))
        fichier.close()
    except:
        print "erreur d'ouverture du fichier %s" %fic_priv
        return False
    # activation de la clé sur zephir
    data = convert(proxy.serveurs.update_key(config.id_serveur))
    if data[0] == 0:
        print "erreur de mise en place de la nouvelle clé sur zephir : %s" % str(res)
        return False
    # sauvegarde de la clé actuelle
    os.system("/bin/mv %s/id_rsa.pub %s/old_key.pub" % (ssh_dir, tmp_dir))
    os.system("/bin/mv %s/id_rsa %s/old_key" % (ssh_dir, tmp_dir))
    # mise en place de la nouvelle clé locale
    os.system("/bin/mv %s/new_key.pub %s/id_rsa.pub" % (tmp_dir, ssh_dir))
    os.system("/bin/mv %s/new_key %s/id_rsa" % (tmp_dir, ssh_dir))
    os.system("/bin/chown uucp.uucp %s/id_rsa*" % ssh_dir)
    # unlock(['configure', 'uucp', 'maj', 'reconfigure'])
    # mise à jour de la configuration uucp
    old_addr = config.adresse_zephir
    for path_uucp in ['/etc/uucp/port', '/etc/uucp/sys']:
        conf_uucp = open(path_uucp).read()
        conf_uucp = conf_uucp.replace(old_addr, new_addr)
        fic_uucp = open(path_uucp, 'w')
        fic_uucp.write(conf_uucp)
        fic_uucp.close()
    # mise à jour de zephir_conf.py avec la nouvelle adresse
    return update_conf(config.id_serveur, new_addr)

def update_sudoers():
    """met à jour la liste des scripts exécutables par sudo en tant que root"""
    uucp_pattern = """uucp    ALL=NOPASSWD"""
    if os.path.isfile('/etc/sudoers'):
        scripts = glob('%s/scripts/*.zephir' % zephir_dir)
        scripts.sort()
        # liste des scripts disponibles
        uucp_conf = ["#ZEPHIR : liste des scripts exécutables par zephir_client, ne pas modifier\n"]
        for script in scripts:
            uucp_conf.append('%s : %s\n' % (uucp_pattern, script))
        uucp_conf.append('#ZEPHIR FIN\n')
        # fichier actuel
        orig_data = file('/etc/sudoers').readlines()
        # supression des lignes concernant uucp
        final_data = []
        for line in orig_data:
            if not (line.startswith(uucp_pattern) or line.startswith('#ZEPHIR')):
                final_data.append(line)
        final_data.extend(uucp_conf)
        # ré-écriture du fichier
        try:
            sudo_file = file('/etc/sudoers', 'w')
            sudo_file.writelines(final_data)
            sudo_file.close()
            os.system('chmod 0440 /etc/sudoers')
            return True
        except:
            print "\n! Client Zephir: Le fichier /etc/sudoers n'a pas pu être mis à jour !\n"
    return False

def verif_transfer(zephir_proxy, archive):
    """vérifie la validité d'une archive recue et confirme sa réception à zephir"""
    verif_archive = convert(zephir_proxy.uucp.get_checksum(config.id_serveur, u(archive)))
    if verif_archive[0] == 0:
        log('ZEPHIR', 1, 'erreur de récupération du checksum pour '+archive+'.tar')
        return verif_archive
    else:
        md5string = xmlrpclib.base64.decodestring(verif_archive[1])
        f_md5 = open(public_dir+os.sep+archive+'.md5', 'w')
        f_md5.write(md5string)
        f_md5.close()
        res = os.system('cd ' + public_dir + ' ; /usr/bin/md5sum -c ' + f_md5.name)
        os.unlink(f_md5.name)
        if res == 0:
            # on informe zephir que le transfert s'est bien passé (rapport ?)
            res = convert(zephir_proxy.uucp.confirm_transfer(config.id_serveur, u(archive)))
            if res[0] == 1:
                return 1, 'ok'
            else:
                #erreur de supression de l'archive sur zephir ?
                return 1, res[1]
        else:
            # log('WARNING', 'checksum invalide pour '+archive+'.tar')
            return 0, 'checksum invalide pour '+archive+'.tar'

def mod_var_path(filepath):
    """change un chemin de fichier pour insérer 'variante' """
    filepath = list(os.path.split(filepath))
    filepath.insert(1, 'variante')
    return os.sep.join(filepath)


def get_container_file(filepath):
    try:
        fpath, container = filepath.split('::')
        cont_path = creole_vars.get_creole('container_path_%s' % container, '')
        if cont_path:
            return os.path.join(cont_path, fpath.lstrip(os.sep))
        else:
            return fpath
    except:
        pass
        # pas de container donné (--> container root)
    return filepath

def check_paqfile(filepath):
    """regarde si un répertoire/fichier est livré par un paquet
    filepath: chemin absolu du fichier à tester
    Si le fichier est dans un conteneur, donner le chemin complet depuis le conteneur maître
    (ex: /var/lib/lxc/internet/rootfs/var/lib/blacklists)
    """
    container = cont_fic = ''
    # détection d'un éventuel conteneur
    if '/rootfs/' in filepath:
        cont_path, cont_filepath = filepath.split('/rootfs')
        cont_name = os.path.basename(cont_path)
        # on vérifie que le chemin correspond bien dans le fichier container.conf
        cont_path = creole_vars.get_creole('container_path_%s' % cont_name, '')
        if cont_path and filepath.startswith(cont_path):
            container = cont_name
    if container == '':
        # lancement sur le conteneur maître ou mode conteneur non actif
        # (system_out gère les cas où container est VIRTMASTER ou None)
        container = VIRTMASTER
        cont_filepath = filepath
    res = system_out(['dpkg', '-S', cont_filepath], container=container)[0]
    return res == 0

def get_file_perms(base_dir, data_path, variante=False, filepath=""):
    """renvoie les informations de permissions associées à un fichier
    """
    data_dir = base_dir + os.sep + data_path
    # lecture des informations sur le fichier si disponibles
    if variante == True:
        permsfile = base_dir + os.sep + 'droits_variante'
    else:
        permsfile = base_dir+os.sep+'droits_zephir'
    if os.path.isfile(permsfile):
        f_rights = file(permsfile)
        data = f_rights.read().strip().split('\n')
        f_rights.close()
    else:
        data = []
    mode = user = group = ""
    recursive = False
    if filepath != "":
        if variante == True:
            result = {mod_var_path(filepath):[mode, user, group, recursive]}
        else:
            result = {filepath:[mode, user, group, recursive]}
    else:
        result = {}
    for line in data:
        if line.startswith(filepath) or filepath == "":
            if line.startswith(data_path):
                try:
                    filename, mode, user, group, recursive = line.split('#')
                    if recursive != '':
                        recursive = eval(recursive)
                    if variante == True:
                        result[mod_var_path(filename)] = [mode, user, group, recursive]
                    else:
                        result[filename] = [mode, user, group, recursive]
                    if filepath != "":
                        break
                except:
                    # fichier vide ?
                    pass
    return result

def sudo_script(cmd, log_prefix='ZEPHIR'):
    res = os.system("sudo %s/scripts/%s 2>&1 >> /var/log/zephir/last_action.log" % (zephir_dir, cmd))
    if res != 0:
        # log de l'erreur sur zephir (par défaut dans la rubrique divers)
        log(log_prefix, 1, "Erreur lors de l'exécution du script %s" % cmd)
        sys.exit(1)

def templates_for_level(level):
    """renvoie la liste des templates livrés à un niveau de configuration
    spécifique (local, variante)
    """
    dicos_lvl = []
    # définition des niveaux supérieurs au niveau demandé
    top_lvl = ['module']
    if level == 'local':
        top_lvl.append('variante')
    ## FIXME : vérifier les dictionnaires livrés par des paquets !!
    # lecture des dictionnaires de variantes et copie des fichiers templates référencés
    try:
        variante_files = creole_vars.get('/containers/files', withoption='level', withvalue=level)
    except NotFoundError:
        variante_files = []
    for file_attr in variante_files:
        if file_attr.endswith('.source'):
            filename = variante_files[file_attr]
            # on regarde si ce template est aussi référencé dans un dictionnaire au niveau module
            try:
                tmpl_instances = creole_vars.get('/containers/files', withoption='source', withvalue=filename)
            except NotFoundError:
                tmpl_instances = []
            in_top_lvl = False
            for file_attr in tmpl_instances:
                if file_attr.endswith('.level') and tmpl_instances[file_attr] in top_lvl:
                    in_top_lvl = True
                    break
            if not in_top_lvl:
                # template non livré d'origine, on doit le remonter sur Zéphir
                path = os.path.join(distrib_dir, os.path.basename(filename))
                if os.path.isfile(path):
                    dicos_lvl.append(path)
                else:
                    print """fichier {0} non trouvé""".format(path)
    return dicos_lvl

def register_log(zephir_proxy, id_serveur, eole_variables, ip_zlog=None, regen=False):
    """
    mise en place d'un certificat pour envoi des logs centralisés si disponible
    @zephir_proxy : objet xmlrpclib.ServeurProxy pour communiquer avec le
    Zéphir.
    @id_serveur : id du serveur qui s'enregistre
    @eole_variables : dictionnaire contenant les chemins des certificats et clé, passés
    en argument pour éviter de recharger le dictionnaire
    @id_zlog (optionnel) : identifiant du ZéphirLog,  si absent, on considère
    que c'est un ZéphirLog qui s'enregistre.
    """
    id_zlog = None

    # Création d'une clé privée si elle n'existe pas
    if regen or not os.path.isfile(eole_variables['rsyslog_privkey']):
        gen_privkey(eole_variables['rsyslog_privkey'])
        # TODO : gérer la révocation
    request_data = {}
    with open(rsyslog_request_template, 'r') as request_template_data:
        request_template = xmlrpclib.base64.encodestring(request_template_data.read())
    request_data['template'] = request_template
    if ip_zlog != None:
        # on considère que c'est un client qui s'enregistre
        # recherche du serveur zephirlog correspondant sur zephir
        res, managers = zephir_proxy.prelude.get_managers('')
        if res != 1:
            print_red("Erreur lors de la récupération des serveurs ZéphirLog")
            return False
        if managers != {}:
            id_zephirlog, ip_manager = select_manager(ip_zlog, managers, 'zephirlog')
            if id_zephirlog == "":
                print_orange("\nMise en place du certificat ZephirLogs ignoré\n\n")
                return True
            else:
                if ip_zlog != ip_manager:
                    if not update_logs_conf(ip_manager):
                        print_red("""\nL'adresse ip du serveur zephirlog n'a pas pu être sauvegardée\n\n""")
                        return False
                    print_green("""\nNouvelle adresse ZephirLogs enregistrée dans la configuration : %s\n\n""" % ip_manager)
            # mise en place de la CA du serveur ZephirLog sélectionné
            request_content = gen_request(rsyslog_request_template,
                                        eole_variables['rsyslog_privkey'])
            request_content = xmlrpclib.base64.encodestring(request_content)
            request_data['request'] = request_content
            request_data['rsyslog'] = xmlrpclib.base64.encodestring("$InputTCPServerStreamDriverPermittedPeer {0}".format(eole_variables['serveur']))
            res, data = zephir_proxy.prelude.gen_certif(request_data, id_serveur, id_zephirlog)
            if res != 1:
                print_red("""\nErreur de récupération des certificats rsyslog sur Zephir.\n\n""")
                return False
            with open(eole_variables['rsyslog_ca'], 'w') as rsyslog_ca:
                rsyslog_ca.write(xmlrpclib.base64.decodestring(data['ca_data']))
            print_green("\nCertificat racine enregistré sous %s\n\n" % eole_variables['rsyslog_ca'])
            with open(eole_variables['rsyslog_cert'], 'w') as rsyslog_crt:
                rsyslog_crt.write(xmlrpclib.base64.decodestring(data['cert_data']))
            print_green("\nCertificat rsyslog enregistré sous %s\n\n" % eole_variables['rsyslog_cert'])
            if data.has_key('rsyslog_data'):
                outgoing_dir = '/etc/rsyslog.d/outgoing_peers'
                if not os.path.exists(outgoing_dir):
                    os.makedirs(outgoing_dir)
                with open(os.path.join(outgoing_dir, 'tls.peers'), 'w') as rsyslog_conf:
                    rsyslog_conf.write(xmlrpclib.base64.decodestring(data['rsyslog_data']))
    else:
        # on considère que c'est un ZéphirLog qui s'enregistre
        request_content = gen_request(rsyslog_request_template,
                eole_variables['rsyslog_privkey'])
        request_data['request'] = xmlrpclib.base64.encodestring(request_content)
        request_data['rsyslog'] = xmlrpclib.base64.encodestring("$ActionSendStreamDriverPermittedPeer {0}".format(eole_variables['serveur']))
        res, data = zephir_proxy.prelude.gen_certif(request_data, id_serveur)
        with open(eole_variables['rsyslog_ca'], 'w') as rsyslog_ca:
            rsyslog_ca.write(xmlrpclib.base64.decodestring(data['ca_data']))
        print_green("\nCertificat racine enregistré sous %s\n\n" % eole_variables['rsyslog_ca'])
        with open(eole_variables['rsyslog_cert'], 'w') as rsyslog_crt:
            rsyslog_crt.write(xmlrpclib.base64.decodestring(data['cert_data']))
        print_green("\nCertificat rsyslog enregistré sous %s\n\n" % eole_variables['rsyslog_cert'])
        if data.has_key('rsyslog_data'):
            incoming_dir = '/etc/rsyslog.d/incoming_peers'
            if not os.path.exists(incoming_dir):
                os.makedirs(incoming_dir)
            with open(os.path.join(incoming_dir, 'tls.peers'), 'w') as rsyslog_conf:
                rsyslog_conf.write(xmlrpclib.base64.decodestring(data['rsyslog_data']))
    return True


def wait_for_port(addr, port, timeout = 20):
    """attend qu'une connexion soit disponible sur une adresse/port
    timeout : temps d'attente maximum avant d'abandonner (en secondes)
    """
    sock_timeout = 3
    run_time = 0
    while run_time < timeout:
        sock_test = socket.socket()
        sock_test.settimeout(sock_timeout)
        try:
            sock_test.connect((addr, port))
            return True
        except socket.timeout:
            pass
        except socket.error:
            time.sleep(sock_timeout)
        run_time += sock_timeout
    return False

# FIXME 2.4
#def check_prelude_conf():
#    """récupère les options prelude définies dans la configuration creole
#    """
#    ip_conf = ''
#    sondes = []
#    try:
#        # si une adresse_ip est définie, on la propose par défaut
#        conf = EoleDict()
#        conf.read_dir(eoledirs)
#        conf.load_values('/etc/eole/config.eol')
#        try:
#            ip_conf = conf.get_value('adresse_ip_prelude_manager')[0]
#        except IndexError:
#            ip_conf = ""
#        if eole_module == 'zephirlogs':
#            print "** enregistrement prelude-lml"
#            sondes = ['prelude-lml']
#        else:
#            for varname, var in conf.variables.items():
#                if varname.startswith('sonde_') and var.get_final_value() == 'oui':
#                    sondes.append(varname.replace('sonde_', '').replace('__', '-'))
#                    print "** enregistrement ", varname.replace('sonde_', '').replace('__', '-')
#    except:
#        traceback.print_exc()
#        pass
#    return ip_conf, sondes

def select_manager(ip_conf, managers, mgr_type = 'preludemanager'):
    """propose le choix du  manager sur lequel l'enregistrement doit s'effectuer
    """
    # choix du manager
    saisie_default = ""
    choix = [""]
    id_man = ""
    ip_manager = ""
    if ip_conf is not None:
        ip_manager = ip_conf
        # ip du manager donnée en paramètre, on recherche l'id correspondant
        for id_manager, data_man in managers.items():
            ip_man = data_man[0]
            libelle = data_man[1]
            if ip_man == ip_conf:
                id_man = id_manager
    if id_man == "":
        if ip_conf:
            print_orange("\nLe serveur %s correspondant à l'ip %s n'a pas été trouvé." % (mgr_type, ip_conf))
        print "\nserveurs %s disponibles :\n" % mgr_type
        id_default = ""
        # si pas de manager spécifié, on propose un choix
        for id_man in managers.keys():
            ip_man = managers[id_man][0]
            libelle = managers[id_man][1]
            choix.append(id_man)
            print id_man, " -> ", ip_man, "(", libelle, ")"
        id_man = "undef"
        while id_man not in choix:
            id_man = raw_input("\nIdentifiant du serveur %s à utiliser (rien pour ignorer) ? " % (mgr_type))
        if id_man != "":
            ip_manager = managers[id_man][0]
    return id_man, ip_manager

# FIXME 2.4
#def update_prelude_conf(ip_manager):
#    """met à jour la configuration creole du serveur et instancie les templates
#    nécessaires à l'enregistrement des sondes prelude
#    """
#    # mise en place de la configuration
#    conf = EoleDict()
#    conf.read(os.path.join(eoleroot, 'dicos', '1_prelude.xml'))
#    prelude_files = conf.files
#    prelude_filelists = conf.filelists
#    # instanciation des fichier de configuration prelude
#    conf = EoleDict()
#    # on récupère les autres variables
#    conf.read_dir(eoledirs)
#    # on lit la configuration dans config.eol (ou zephir.eol si non instancié)
#    if os.path.isfile('/etc/eole/config.eol'):
#        conf.load_values('/etc/eole/config.eol')
#    else:
#        conf.load_values('/root/zephir.eol')
#    conf.set_value('adresse_ip_prelude_manager' , ip_manager)
#    saved = True
#    for conf_file in ['/etc/eole/config.eol', '/root/zephir.eol']:
#        if os.path.isfile(conf_file):
#            if not conf.save_values(conf_file):
#                saved = False
#    if saved:
#        # et on ne garde que les fichiers prelude
#        conf.files = prelude_files
#        conf.filelists = prelude_filelists
#        # instanciation des fichiers templates avec les valeurs chargées
#        try:
#            conf.instance()
#        except:
#            traceback.print_exc()
#            print '\n!! erreur de génération de la configuration prelude !!\n'
#            saved = False
#    return saved

# FIXME 2.4
#def update_logs_conf(ip_manager):
#    """met à jour la configuration creole du serveur
#    """
#    # mise en place de la configuration
#    try:
#        conf = EoleDict()
#        conf.read(os.path.join(eoleroot, 'dicos', '1_logs.xml'))
#        # instanciation des fichier de configuration prelude
#        conf = EoleDict()
#        # on récupère les autres variables
#        conf.read_dir(eoledirs)
#        # on lit la configuration dans config.eol (ou zephir.eol si non instancié)
#        if os.path.isfile('/etc/eole/config.eol'):
#            conf.load_values('/etc/eole/config.eol')
#        else:
#            conf.load_values('/root/zephir.eol')
#    except:
#        print "Erreur à la lecture de la configuration du serveur"
#        return False
#    conf.set_value('adresse_ip_serveur_logs' , ip_manager)
#    saved = True
#    for conf_file in ['/etc/eole/config.eol', '/root/zephir.eol']:
#        if os.path.isfile(conf_file):
#            if not conf.save_values(conf_file):
#                saved = False
#    return saved

def register_sonde(sonde, id_man, ip_manager, zephir_proxy):
    retry = True
    num_tries = 0
    while retry:
        retry = False
        # lancement du serveur d'enregistrement à distance
        code, pass_register = convert(zephir_proxy.prelude.register_server(id_man))
        if code == -1:
            # si le serveur est déjà occupé, on attend au maximum 30 secondes (essai toutes les 5 secondes)
            print "Un enregistrement est déjà en cours sur prelude-manager. nouvelle tentative dans 5 secondes..."
            if num_tries < 6:
                num_tries += 1
                retry = True
                time.sleep(4)
                continue
            else:
                return False
        elif code == 0:
            return False
        # attente de la dispo du serveur
        print "Attente du lancement du serveur d'enregistrement sur prelude-manager"
        conn_ok = wait_for_port(ip_manager, 5553)
        # lancer adduser avec les paramêtres donnés
        if conn_ok:
            print " - enregistrement de la sonde %s" % sonde
            options = get_options(zephir_dir)
            if sonde in options:
                permissions, uid, gid, services = options[sonde]
            else:
                permissions = "idmef:w admin:r"
                uid = "root"
                gid = "root"
                services = [sonde]
            cmd_register = '/usr/bin/prelude-admin register %s "%s" %s --uid %s --gid %s --passwd=%s 2>/dev/null' % (sonde, permissions, ip_manager, uid, gid, pass_register)
            res = os.system(cmd_register)
            if res != 0:
                print "\terreur lors de l'enregistrement de %s \n\t(%s)" % (sonde, cmd_register)
            else:
                pass
                res = os.system('/bin/chown %s.%s /etc/prelude/profile/%s/analyzerid' % (uid, gid, sonde))
                for serv in services:
                    print " - relance du service %s ..." % serv
                    try:
                        manage_service(u'restart', serv)
                    except:
                        print " ** Erreur lors de la relance !"
        else:
            print "\nserveur d'enregistrement non lancé ?"
            return False
    return True

def register_prelude(zephir_proxy):
    """mise en place de la configuration prelude si nécessaire"""
    # recherche des managers disponibles
    try:
        ret_code, managers = convert(zephir_proxy.prelude.get_managers())
    except xmlrpclib.ProtocolError:
        print("Vous n'êtes pas autorisé à utiliser les fonctionnalités prelude")
        return False
    except:
        print "\n!! erreur de lecture de la configuration prelude sur zephir"
        return False
    if managers != {}:
        ip_conf, sondes = check_prelude_conf()
        id_man, ip_manager = select_manager(ip_conf, managers)
        if id_man == "":
            print_orange("\nEnregistrement auprès du serveur PreludeManager ignoré\n\n")
        else:
            if ip_manager != ip_conf:
                if not update_prelude_conf(ip_manager):
                    print_red("""\nL'adresse ip du serveur PreludeManager n'a pas pu être sauvegardée\n\n""")
                    return False
                else:
                    print_green("""\nNouvelle adresse PreludeManager enregistrée dans la configuration : %s\n\n""" % ip_manager)
            # pour chaque sonde définie dans la configuration, on effectue un enregistrement (prelude-adduser)
            err_sonde = False
            for sonde in sondes:
                if not register_sonde(sonde, id_man, ip_manager, zephir_proxy):
                    err_sonde = True
                    print_red ("\n Echec de l'enregistrement de la sonde %s sur le serveur Preludemanager (%s) \n\n" % (sonde, ip_manager))
            if err_sonde:
                return False
    return True

def saisie(variable,message):
    """effectue la saisie d'une variable en utilisant
    une valeur par défaut si disponible
    """
    try:
        val_def = " (%s par défaut)" % defaults[variable]
    except Exception,e:
        val_def = ""
    val = raw_input(message + val_def + " : ")
    if val == "" and val_def != "":
        return defaults[variable]
    else:
        return val

pppoe_int_template = """# zephir_client : template minimum pour montage d'une connexion pppoe
# loopback network interface
auto lo
iface lo inet loopback

# dsl provider
auto dsl-provider
iface dsl-provider inet ppp
pre-up /sbin/ifconfig %%pppoe_interface up
provider dsl-provider

auto %%pppoe_interface
iface %%pppoe_interface inet manual
"""

dsl_provider_template = """
# Minimalistic default options file for DSL/PPPoE connections

noipdefault
defaultroute
replacedefaultroute
hide-password
noauth
persist
updetach
usepeerdns
user "%%pppoe_user"
"""

def conf_network(use_pppoe=False):

    def configure_dns(ip_dns):
        """
        Vérification et configuration du serveur DNS
        """
        testdns = (['/usr/bin/host', '-W2', '-tA', 'bp-eole.ac-dijon.fr', ip_dns])
        res = system_out(testdns)
        if res[0] != 0:
            print "le serveur DNS %s ne répond pas (%s)" % (ip_dns, res[1])
            return False
        server_conf = "nameserver %s" % ip_dns
        f_dns = open('/etc/resolv.conf', 'w')
        f_dns.write(server_conf)
        f_dns.close()
        return True

    # création d'une configuration réseau minimum
    if not use_pppoe:
        # connexion ethernet classique
        ip_eth0 = mask_eth0 = gateway = ""
        while ip_eth0 =="" or mask_eth0 == "" or gateway == "":
            interf = saisie("interf","interface connectée sur l'extérieur")
            ip_eth0 = saisie("ip_eth0","adresse_ip %s" % interf)
            mask_eth0 = saisie("mask_eth0","masque de réseau pour %s" % interf)
            gateway = saisie("gateway","adresse de la passerelle")
        system_code(['/sbin/ifconfig', interf, ip_eth0, 'netmask', mask_eth0])
        system_code(['/sbin/route', 'add', 'default', 'gw', gateway, 'dev', interf])
        system_code(['/sbin/ifconfig', interf, 'up'])
        dns_ok = False
        while not dns_ok:
            ip_dns = saisie("ip_dns", "adresse du serveur DNS (ou rien)")
            if ip_dns == "" or configure_dns(ip_dns):
                dns_ok = True
    else:
        eole_module = creole_vars.get_creole(u'eole_module')
        if not eole_module.startswith("amon"):
            exit_err("""La connexion par pppoe n'est gérée que sur les modules amon et amonecole""")
        configs = {'pap-secrets':'/etc/ppp','chap-secrets':'/etc/ppp', 'dsl-provider':'/etc/ppp/peers'}
        for tmpl in configs.keys():
            if not os.path.isfile(os.path.join(distrib_dir, tmpl)):
                exit_err("""Fichier de configuration non présent : %s""" % tmpl)
        interf_ppp = login_ppp = pass_ppp = mtu_ppp = ""
        while interf_ppp == "" or login_ppp == "" or pass_ppp == "":
            # connexion pppoe - saisie login/pwd et interface
            interf_ppp = saisie("interf","interface utilisée pour la connexion pppoe")
            mtu_ppp = saisie("mtu_ppp","MTU utilisé pour la connexion pppoe (facultatif)")
            login_ppp = saisie("login_ppp", "utilisateur pour la connexion pppoe")
            pass_ppp = getpass.getpass("mot de passe pour la connexion pppoe : ")
        # mise en place des fichiers de configuration : pap(/chap)-secrets et dsl-provider
        try:
            for tmpl_name, dest_dir in configs.items():
                if tmpl_name == 'dsl-provider':
                    conf_data = dsl_provider_template
                    # gestion du MTU pour dls-provider
                    if mtu_ppp == "":
                        conf_data += 'pty "pppoe -I %s -T 80"' % (interf_ppp)
                    else:
                        conf_data += 'pty "pppoe -I %s -T 80 -m %s"' % (interf_ppp, mtu_ppp)
                else:
                    tmpl = os.path.join(distrib_dir, tmpl_name)
                    conf_data = open(tmpl).read()
                # remplacement des variables
                conf_data = conf_data.replace("%%pppoe_user", login_ppp)
                conf_data = conf_data.replace("%%pppoe_passwd", pass_ppp)
                conf_data = conf_data.replace("%%pppoe_interface", interf_ppp)
                # écriture du résultat dans sa destination
                f_conf = open(os.path.join(dest_dir, tmpl_name), 'w')
                f_conf.write(conf_data)
                f_conf.close()
            # fichier interfaces minimum
            tmpl_name = "interfaces"
            f_int = open('/etc/network/interfaces', 'w')
            f_int.write(pppoe_int_template.replace("%%pppoe_interface", interf_ppp))
            f_int.close()
        except:
            exit_err("erreur de mise en place du fichier %s" % tmpl_name)
        # lancement de la connexion ppp
        print_orange("""\nRelance des services réseaux ...\n""")
        try:
        # XXX FIXME moyen de tester le status du service avec pyeole 2.4 ?
            manage_service(u'restart', u'networking')
            manage_service(u'status', u'networking')
        except:
            print_red("""Erreur au redémarrage du réseau""")

def get_module_var(zephir_proxy, module, default=None):
    # affiche les variantes disponibles pour le module choisi
    liste_variantes = convert(zephir_proxy.modules.get_variante())
    print_line('\n** liste des variantes de ce module **\n')
    choix = [""]
    var_std = -1
    if liste_variantes[0] == 1:
        for var in liste_variantes[1]:
            if var['module'] == int(module):
                if var['libelle'] == 'standard':
                    var_std = var['id']
                    if default == None:
                        # si pas de variante par défaut, on prend la variante standard
                        default = var_std
                if default == var['id']:
                    print_line('%s * %s' % (str(var['id']), str(var['libelle'])))
                else:
                    print_line('%s - %s' % (str(var['id']), str(var['libelle'])))
                choix.append(str(var['id']))
    else:
        exit_err('Erreur : '+str(liste_modules[1]))
    variante = flushed_input("\nvariante (%s par défaut): " % str(default))
    while variante not in choix:
        print_red("\n** choix non valide **\n")
        variante = flushed_input("variante (%s par défaut): " % str(default))
    if variante == "":
        if var_std == -1:
            exit_err('Erreur : variante standard non trouvée')
        else:
            variante = default
    return variante

def migrate_data(zephir_proxy, id_serveur, check=False):
    """récupération des données de configuration après une migration de serveur
    (amon seulement pour l'instant)
    """
    # copie des données côté zephir
    try:
        res = convert(zephir_proxy.serveurs.migrate_data(int(id_serveur),check))
    except xmlrpclib.ProtocolError:
        if check == False:
            res = 0, "vous n'êtes pas autorisé à migrer les données"
        else:
            res = 1, False
    except socket.error, e:
        exit_err("Erreur lors de l'appel au serveur Zéphir (%s)" % str(e))
    return res

def get_paqs_from_logs():
    """
    affichage des logs d'installation / désinstallation des paquets
    """
    conf_logs = []
    try:
        conf_logs = open('/var/log/zephir/last_action.log').read().split('\n')
    except:
        print_orange('\nImpossible de lire les logs de mise en place de la configuration (/var/log/zephir/last_action.log)\n')
    paq_list = []
    errs_list = []
    for ligne in conf_logs:
        if 'Erreur' in ligne:
            # erreurs
            errs_list.append(ligne)
        elif 'installé' in ligne:
            # paquets (dés)installés
            paq_list.append(ligne)
    if errs_list:
        print ""
        print_red("Problème rencontré lors de l'installation des paquets supplémentaires :")
        print ""
        print_red('\n'.join(errs_list))
    if paq_list:
        print ""
        print_green('\n'.join(paq_list))
    print ""

def exit_err(msg):
    print_red("\n\n%s\n\n" % msg)
    sys.exit(1)

