# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Statut d'un agent.

Les statuts utilisables sont définis par les sous-classes de C{Statut} :

  - C{OK} : tout fonctionne correctement.

  - C{Warn} : l'agent donne toujours des mesures significatives malgré
    certains problèmes ; par exemple la mesure peut être partielle.

  - C{Error} : l'agent ne peut pas effectuer de mesure.

  - C{Unknown} : le statut est inconnu.
"""

try: _ # localized string fetch function
except NameError: _ = str




class Status:

    def __init__(self, message=""):
        self.message = message

    def level(self):
        return self.__class__.__name__

    def num_level(self):
        return STATUS_ORDER.index(self.__class__)

    def localized_name(self):
        return self.level()

    def __str__(self):
        assert self.level() != "Status"
        if self.message == "":
            return self.localized_name()
        else:
            return self.localized_name() + " : " + self.message

    # arithmétique sur les statuts

    def __cmp__(self, other):
        return cmp(self.num_level(), other.num_level())

    def to_dict(self):
        return { 'level': self.level(),
                 'message': self.message }




class OK(Status):
    def localized_name(self): return "OK"

class Warn(Status):
    def localized_name(self): return "Avertissement"
    
class Error(Status):
    def localized_name(self): return "Erreur"
    
class Unknown(Status):
    def localized_name(self): return "Indéterminé"

class Dependant(Status):
    def localized_name(self): return "Non disponible"




STATUS_ORDER = [Unknown, OK, Warn, Error, Dependant]
action_map = {0:'action_unknown',1:'action_ok',2:'action_warn',3:'action_error',4:'action_dependant'}


# def test_main():
#     test_support.run_unittest(UserStringTest)
 
# if __name__ == "__main__":
#     test_main()
