# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent zephir informant de la personnalisation de Samba
"""

from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import HTMLData, TableData
from zephir.monitor.agentmanager import status
from os import listdir

class ConfigPerso(Agent):
    def __init__(self, name, **params):
        Agent.__init__(self, name, **params)
        self.table = TableData([
            ('share', 'Partages personnalisés', {'align':'center'}, None)])
        #title1 = HTMLData("<h3>Derniers virus détectés<h3>")
        self.table2 = TableData([
            ('script', 'Scripts de connexion personnalisés', {'align':'center'}, None)])
        self.data = [self.table, HTMLData('<br>'), self.table2]
 
    def measure(self):
        sharepath = '/usr/share/eole/backend/conf/'
        scriptpath = '/home/netlogon/scripts/'
        tscripts = ['users', 'groups', 'os', 'machine']
        noresult = '** AUCUN **'
        
        ## partages personnalisés
        try:
            allshare = listdir(sharepath)
        except:
            allshare = []
        res1 = []
        for share in allshare :
            # partage.conf
            if share.endswith('.conf') and share != 'smb.conf' :
                res1.append({ 'share' : share[0:-5] })
        if res1 == [] :
            res1.append({ 'share' : noresult })
            
        ## scripts personnalisés
        res2 = []
        for tscript in tscripts:
            try:
                allscript = listdir(scriptpath+tscript)
            except:
                allscript = []
            for script in allscript:
                # script.bat
                if script.endswith('.bat'):
                    res2.append({ 'script' : tscript+' : '+script[0:-4] })
        if res2 == [] :
            res2.append({ 'script' : noresult })
          
        
        return { 'statistics' : res1,
                 'statistics2' : res2 }
             

    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value['statistics']
            self.table2.table_data = self.last_measure.value['statistics2']
            
    def check_status(self):
        return status.OK()
 
