# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2014
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent Dansguardian
"""

from zephir.monitor.agentmanager.agent import RRDAgent
from zephir.monitor.agentmanager import status
from pyeole.process import system_out
from creole.client import CreoleClient


def test_instance_dansguardian(ip, max_instance, use_e2guardian):
    prct_instance = None
    if ip is not None:
        cmd = ['ss', '-ltnp', 'sport = {0}:3128'.format(ip)]
        stat, instance, err = system_out(cmd, container='proxy')
        if stat == 0:
            if use_e2guardian:
                prct_name = 'e2guardian'
            else:
                prct_name = 'dansguardian'
            prct_instance = min(instance.count(prct_name) * 100 / max_instance, 100)
    return prct_instance


class Dansguardian(RRDAgent):
    """
    Utilisateurs connectes
    """
    def __init__(self, name, **params):
        RRDAgent.__init__(self, name, **params)
        self.instance_1_activate = None
        self.instance_2_activate = None
        client = CreoleClient()
        self.max_instance1 = int(client.get_creole('maxchildren1'))
        self.max_instance2 = int(client.get_creole('maxchildren2'))
        self.use_e2guardian = client.get_creole('use_e2guardian') == 'oui'
        mode_conteneur_actif = client.get_creole('mode_conteneur_actif') == 'oui'
        if mode_conteneur_actif:
            mask_ip = 'adresse_ip_eth{0}_proxy_link'
        else:
            mask_ip = 'adresse_ip_eth{0}'
        nb_int = int(client.get_creole('nombre_interfaces'))
        if nb_int == 1:
            min_int = 0
        else:
            min_int = 1
        for numint in range(min_int, nb_int):
            num_instance = client.get_creole('dansguardian_eth{0}'.format(numint))
            if num_instance == '1':
                self.instance_1_activate = client.get_creole(mask_ip.format(numint), None)
            if num_instance == '2':
                self.instance_2_activate = client.get_creole(mask_ip.format(numint), None)


    def measure(self):
        resultat = {"1": 0, "2": 0}
        ret = test_instance_dansguardian(self.instance_1_activate, self.max_instance1, self.use_e2guardian)
        stat = status.Unknown()
        if ret is not None:
            resultat['1'] = ret
            if stat == status.Unknown():
                stat = status.OK()
            if ret == 100:
                stat = status.Error()
            elif ret > 90:
                stat = status.Warn()
        ret = test_instance_dansguardian(self.instance_2_activate, self.max_instance2, self.use_e2guardian)
        if ret is not None:
            if stat == status.Unknown():
                stat = status.OK()
            resultat['2'] = ret
            if ret > 90:
                stat = status.Error()
        self.status = stat
        return resultat

    def check_status(self):
        try:
            return self.status
        except:
            return status.Unknown()
