# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent diagnostic
"""

from zephir.monitor.agentmanager.agent import Agent
from twisted.internet.utils import getProcessOutput
from zephir.monitor.agentmanager import status
from os.path import isfile

PROG = '/usr/share/creole/diag.py'

class Diag(Agent):
    """
    Diagnostic
    """
    def measure(self):
        """ lancement du diagnostic """
        if isfile(PROG):
            res = getProcessOutput(PROG, env = {'LC_ALL': 'C'})
            res.addCallback(self.measure_process)
            return res
        else:
            return {}

    def measure_process(self, result):
        """ retour du programme """
        return {}

    def check_status(self):
        """ envoi du statut (toujours OK) """
        return status.OK()

