# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
Agent zephir testant l'application des patches présents sur le serveur
"""
import os
from glob import glob
from cgi import escape
from creole.config import templatedir, distrib_dir, eoleroot
from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager import status
from zephir.monitor.agentmanager.util import status_to_img
from zephir.monitor.agentmanager.data import TableData

COMMENTS = ['#', ';']

def verify_patch(filename):
    """vérifie qu'un patch est bien appliqué"""
    bad_patches = {}
    patch_lines = open(filename).read().split('\n')
    fic_dest = ""
    for line in patch_lines:
        if line.startswith('+++'):
            dest_not_found = False
            if os.path.exists(templatedir):
                fic_dest = os.path.join(templatedir, os.path.basename(line.split()[1]))
            else:
                fic_dest = os.path.join(distrib_dir, os.path.basename(line.split()[1]))

            if not os.path.exists(fic_dest):
                # pas de fichier dans /etc/eole: patch sur un fichier quelconque ?
                fic_dest = line.split()[1]
                if not os.path.exists(fic_dest):
                    # fichier de destination inexistant
                    dest_not_found = True
            bad_patches[fic_dest] = []
            if dest_not_found:
                bad_patches[fic_dest].append("Fichier de destination non trouvé !")
        elif line.startswith('+') and len(line) > 1 and not dest_not_found:
            pattern = line[1:]
            if pattern[0] in COMMENTS:
                #la ligne débute par un commentaire, on l'ignore (#4121)
                continue
            # recherche du pattern dans le fichier de destination
            f_dest = open(fic_dest)
            data = f_dest.read().split('\n')
            f_dest.close()
            if not pattern in data:
                if len(pattern) > 40:
                    pattern = pattern[:40]
                if bad_patches[fic_dest] == []:
                    bad_patches[fic_dest].append(pattern)
    return bad_patches

class Patches(Agent):

    def __init__(self, name,
                 **params):
        Agent.__init__(self, name, **params)
        self.status = status.OK()
        self.table = TableData([
            ('patch', 'Nom du patch', {'align':'left'}, None),
            ('dest', 'Fichier modifié', {'align':'left'}, None),
            ('etat', 'Etat', {'align':'center'}, status_to_img),
            ('pattern', 'Chaine non trouvée', {'align':'left'}, None)])
        self.data = [self.table]

    def measure(self):
        patchs = glob('%s/patch/*.patch' % eoleroot)
        patchs.extend(glob('%s/patch/variante/*.patch' % eoleroot))
        results = []
        meas_data = {}
        self.status = status.OK()
        for patch in patchs:
            patch_name = patch
            bad_patches = verify_patch(patch)
            for dest, pattern in bad_patches.items():
                if pattern == []:
                    etat = 'On'
                else:
                    etat = 'Off'
                    self.status = status.Error()
                results.append({'patch':patch_name, 'dest':dest, 'etat':etat,
                                'pattern':escape('<br>'.join(pattern))})
                patch_name = ''
            meas_data[patch] = bad_patches
        self.measure_data = meas_data
        return {'statistics':results}

    def check_status(self):
        return self.status

    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value['statistics']
