# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent zephir pour la charge squid
"""

from zephir.monitor.agentmanager.agent import RRDAgent
from zephir.monitor.agentmanager import status
from zephir.monitor.agentmanager.util import log
from twisted.internet.utils import getProcessOutput

class Squid(RRDAgent):
    """Mesure de la charge squid
    """

    def measure(self):
        """Récupération des infos sur l'agent snmp de squid"""

        res = getProcessOutput("./bin/squid_snmp.sh",
                               env = {'LC_ALL': 'C'})
        res.addCallbacks(self.measure_process, self.error_process)
        return res

    def error_process(self, *args):
        log.msg("erreur retournée par bin/squid_snmp.sh")
        return None

    def measure_process(self, data):
        resultat={}
        try:
            lines = data.split('\n')
            resultat['inko'] = int(float(lines[0].strip()) * 1000)
            resultat['outko'] = int(float(lines[1].strip()) * 1000)
            resultat['hitsratio'] = lines[2].strip()
            resultat['bytesratio'] = lines[3].strip()
            resultat['server'] = lines[4].strip()
            resultat['client'] = lines[5].strip()
        except Exception, e:
            log.msg(str(e))
        return resultat

    def check_status(self):
        if self.last_measure is None:
            # erreur de récupération des stats snmp
            return status.Unknown()
        # pas d'alerte sur les statistiques ?
        return status.OK()

