from py.test import raises
import os, sys

HERE = os.path.join(os.path.abspath(os.path.dirname(__file__)), "..")
ZEPHIR_PATH = os.path.normpath(HERE)
sys.path.append(ZEPHIR_PATH)

from entpool import *

def setup_module(module):
    module.code_ent = 'LC'
    module.pool = IdPool(module.code_ent)

def test_exc_id_to_string():
    raises(TypeError, pool.id_to_string, "toto")
    raises(OutOfRangeError, pool.id_to_string, 10000000)
    raises(OutOfRangeError, pool.id_to_string, -5)

def test_res_id_to_string():
    assert pool.id_to_string(0) == 'LaaC0000'
    assert pool.id_to_string(pool.max_id) == 'LzzC9999'

def test_exc_string_to_id():
    raises(TypeError, pool.string_to_id, 5)
    raises(ValueError, pool.string_to_id, 'aaa')
    raises(ValueError, pool.string_to_id, 'L1aC0000')

def test_res_string_to_id():
    assert pool.string_to_id('LaaC0000') == 0
    assert pool.string_to_id('LzzC9999') == pool.max_id
