#!/usr/bin/env python
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# init_base.py
#
# Script d'insertion des données par défaut dans la base de données
# (types établissement et modules par défaut)
#
###########################################################################

# insertion des types d'établissement
from zephir.backend import nomenclature
import getpass, os, sys, glob
from zephir.config import *
from zephir.eolerpclib import xmlrpclib, EoleProxy
from creole.client import CreoleClient
from pyeole.ansiprint import print_orange

reload(sys)
sys.setdefaultencoding('utf-8')

# récupération du login admin
dictionnaire = CreoleClient()
admin_zephir = dictionnaire.get_creole('admin_zephir')

def init_data(z):
    """mise en place des données de base (modules, types etablissements)"""

    # import des types d'établissement
    print "Création des types d'établissement par défaut ...\n"

    for libelle in nomenclature.nomenclature_ramses.values():
        z.etabs.add_type(libelle)

    # création des modules
    print "Création des modules EOLE ...\n"

    res = z.modules.get_module()
    if res[0] == 0:
        modules_actuel = []
    else:
        modules_actuel = res[1]

    libelles = []

    for module in modules_actuel:
        libelles.append(module['libelle'])

    print "\nInsertion des données de base terminée\n"

def check_admin():
    """vérifie que l'admin a bien des droits dans la base"""
    import psycopg2
    from zephir.backend.config import DB_PASSWD, DB_HOST, DB_USER, DB_NAME
    cx = psycopg2.connect(host=DB_HOST, database=DB_NAME, user=DB_USER, password=DB_PASSWD)
    db_cursor = cx.cursor()
    db_cursor.execute("""select droits from users where login='%s'""" % admin_zephir)
    res = db_cursor.fetchone()
    db_cursor.close()
    if res != None:
        admin_perms = eval(res[0])
    else:
        admin_perms = []
    if 1 in admin_perms and 4 in admin_perms:
        # droits minimums ok
        cx.close()
        sys.exit(0)
    else:
        # on ajoute les droits
        try:
            db_cursor = cx.cursor()
            if res == None:
                # pas d'infos existantes
                db_cursor.execute("""insert into users (login,mail_actif,sms_actif,droits) values ('%s',0,0,'[1,4]')""" % admin_zephir)
            else:
                if 1 not in admin_perms:
                    admin_perms.append(1)
                if 4 not in admin_perms:
                    admin_perms.append(4)
                # update du champs droits
                db_cursor.execute("""update users set droits='%s' where login='%s'""" % (str(admin_perms),admin_zephir))
            db_cursor.close()
        except:
            # pas d'admin défini ou erreur de maj des droits
            print_orange("\nErreur de mise en place des droits de l'administrateur zephir")
            cx.rollback()
            sys.exit(1)
        cx.commit()
        print "Droits mis à jour pour %s\n" % admin_zephir

if __name__ == '__main__':
    if "--verify" in sys.argv:
        check_admin()
    else:
        # connexion à l'application zephir
        try:
            passwd = sys.argv[1]
        except:
            passwd = getpass.getpass("mot de passe de %s : " % admin_zephir)

        init_data(EoleProxy('https://%s:%s@%s:%s' % (admin_zephir, passwd, ADRESSE_ZEPHIR, PORT_ZEPHIR)))
