# -*- coding: UTF-8 -*-
###########################################################################
#
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# libsecure.py
#
# classes utilitaires pour lancement des services en https
#
###########################################################################
"""
points d'entrée de l'api

- gen_certif -> génère **un** certif
- gen_certs -> génère tous les certifs

cf creole/doc/certifs.txt

"""
from os.path import join, splitext, basename, dirname, isdir, isfile
import os, glob
from shutil import copy
from subprocess import Popen, PIPE
from OpenSSL import SSL
import re
from grp import getgrnam

from creole.client import CreoleClient
from creole2.eosfunc import load_container_var
# chemin du certificat eole par défaut
from creole2.config import cert_file, key_file
from pyeole2.process import system_out, system_code

# chargement de la configuration creole
dico = CreoleClient()

def prep_dir() :
    """
    Création de l'arborescence pour openssl
    """
    #on génère le random
    rand_file = os.path.join(ssl_dir, ".rand")
    if not os.path.isfile(rand_file) :
        cmd_random = "/bin/dd if=/dev/urandom of=%s bs=1k count=16 >/dev/null 2>&1" % (rand_file)
        cmd = Popen(cmd_random, shell=True)
        res = cmd.wait()
        if res != 0:
            raise Exception("! erreur lors de la génération du fichier d'entropie !")
    #on crée les fichiers pour gerer la pki
    file_serial = os.path.join(ssl_dir, "serial")
    if not os.path.isfile(file_serial) :
        f = file(file_serial, "w")
        f.write(str(start_index))
        f.close()
    file_index = os.path.join(ssl_dir, "index.txt")
    if not os.path.isfile(file_index) :
        f = file(file_index, "w")
        f.close()
    newcerts = os.path.join(ssl_dir, "newcerts")
    if not os.path.isdir(newcerts):
        os.makedirs(newcerts)
    if not os.path.isdir(key_dir):
        os.makedirs(key_dir)
    if not os.path.isdir(cert_dir):
        os.makedirs(cert_dir)
    if not os.path.isdir(req_dir):
        os.makedirs(req_dir)
    if not os.path.isdir(local_ca_dir):
        os.makedirs(local_ca_dir)
    ##cmd = Popen("chmod 611 %s" % (key_dir), shell=True)
    dhfile = os.path.join(ssl_dir, "dh")
    if not os.path.isfile(dhfile):
        gen_dh = "/usr/bin/openssl dhparam -out %s 1024 >/dev/null 2>&1" % (dhfile)
        Popen(gen_dh, shell=True)

def sup_passwd(tmp_keyfile, keyfile) :
    """
    Supression de la passphrase sur la clef privée
    """
    key_cmd = "/usr/bin/openssl rsa -in %s -passin pass:secret -out %s >/dev/null 2>&1" % (tmp_keyfile, keyfile)
    cmd = Popen(key_cmd, shell=True)
    res = cmd.wait()
    if res != 0:
        raise Exception('! erreur lors de la génération de la clé ssl dans %s !' % keyfile)

def finalise_cert (certfile, keyfile, key_user='', key_grp='', key_chmod='',
        cert_user='', cert_grp='', cert_chmod=''):
    """
    Finalisation du certif
    """
    if key_user != '':
        try:
            res = Popen("chown %s %s" % (key_user, keyfile), shell=True).wait()
            assert res == 0
        except:
            print "\n! Impossible de changer les droits de %s" % keyfile
            return False
    if key_grp != '':
        try:
            res=Popen("/bin/chgrp %s %s" % (key_grp, keyfile), shell=True).wait()
            assert res == 0
        except:
            print "\n! Impossible de changer les droits de %s" % keyfile
            return False
    if key_chmod != '':
        try:
            res = Popen("/bin/chmod %s %s" % (key_chmod, keyfile), shell=True).wait()
            assert res == 0
        except:
            print "\n! Impossible de changer les droits de %s" % keyfile
            return False
    if cert_user != '':
        try:
            res = Popen("/bin/chown %s %s" % (cert_user, certfile), shell=True).wait()
            assert res == 0
        except:
            print "\n! Impossible de changer les droits de %s" % certfile
            return False
    if cert_grp != '':
        try:
            res = Popen("/bin/chgrp %s %s" % (cert_grp, certfile), shell=True).wait()
            assert res == 0
        except:
            print "\n! Impossible de changer les droits de %s" % certfile
            return False
    if cert_chmod != '':
        try:
            res = Popen("/bin/chmod %s %s" % (cert_chmod, certfile), shell=True).wait()
            assert res == 0
        except:
            print "\n! Impossible de changer les droits de %s" % certfile
            return False
    return True


def is_simple_cert(cert_file):
    """
    Teste si le fichier contient un simple certificat ou une chaîne
    :param cert_file: chemin du fichier à tester
    :type cert_file: str
    """
    with open(cert_file, 'r') as pem:
        cert_num = len(re.findall(r'-+BEGIN CERTIFICATE-+', pem.read()))
    return cert_num == 1


def get_certs_catalog(simple=True):
    """
    Créer un dictionnaire des certificats présents
    pour accélérer la reconstitution de la chaîne
    de certificats intermédiaires.
    :param simple: filtre sur les certificats à référencer
    :type simple: booléen
    """
    certs_catalog = {}
    for cert_file in glob.glob(os.path.join(ssl_dir, 'certs/*')):
        try:
            if simple and is_simple_cert(cert_file):
                certs_catalog[get_subject(certfile=cert_file)] = cert_file
        except:
            continue
    return certs_catalog


def get_certs_chain(certs):
    """
    Récupération de la chaîne de certificats
    :param certs: liste des certificats dans l'ordre de la chaîne.
    :type certs: liste de chemins
    """
    subject = get_subject(certfile=certs[-1])
    issuer = get_issuer_subject(certfile=certs[-1])
    if subject != issuer:
        try:
            certs.append(certs_catalog[issuer])
            get_certs_chain(certs)
        except KeyError as e:
            print "Chaîne de certificats incomplète."
    return certs


def get_intermediate_certs(cert):
    """
    Récupération de la liste des certificats intermédiaires.
    :param cert: chemin du certificat pour lequel on reconstitue la chaîne
    :type cert:
    """
    try:
        chain = get_certs_chain([cert,])[1:-1]
    except Exception as err:
        chain = []
    return chain


def concat_fic(dst_fic, in_fics, overwrite=False):
    """
    Concaténation d'une liste de fichiers dans un fichier de destination
    (le contenu d'origine est conservé)
    """
    if type(in_fics) != list:
        in_fics = [in_fics]
    for fic in in_fics:
        if not os.path.isfile(fic):
            print "Erreur le fichier %s n'existe pas" % fic
    data = ""
    for fic_src in in_fics:
        f_src = file(fic_src)
        data += f_src.read().rstrip() + '\n'
        f_src.close()
    if overwrite:
        f_dst = file(dst_fic, "w")
    else:
        f_dst = file(dst_fic, "a+")
    f_dst.write(data)
    f_dst.close()

def gen_certs(regen=False, merge=True):
    """
    Génère la ca puis les certificats
    """
    verif_ca()
    ca_generated = gen_ca(regen)
    if merge:
        merge_ca()
    if ca_generated:
        regen = True
    certif_loader(regen=regen)

def verif_ca():
    """
    vérifie que la ca est générée correctement (serial > 0xstart_index) et cn valide
    """
    # gestion des anciennes version de ca.crt
    if os.path.isfile(ca_dest_file) and not os.path.isfile(ca_file):
        # on reprend le premier certificat présent dans ca.crt dans ca_local.crt
        ca_certs = open(ca_dest_file).read().strip()
        tag_begin = '-----BEGIN CERTIFICATE-----'
        try:
            ca_data = tag_begin + ca_certs.split(tag_begin)[1]
            local_ca = open(ca_file, 'w')
            local_ca.write(ca_data)
            local_ca.close()
        except IndexError:
            # impossible de reprendre la ca actuelle, elle sera regénérée
            pass
    serial = int(eval('0x%s'%start_index))
    # vérification de la valeur actuelle du ca
    # vérification du cn de la ca
    if os.path.isfile(ca_file):
        cmd = Popen(['/usr/bin/openssl', 'x509', '-in', ca_file, '-subject', '-noout'], stdout=PIPE)
        if cmd.wait() != 0:
            os.unlink(ca_file)
            prep_dir()
        else:
            res = cmd.communicate()[0]
            cn = res[res.rindex('CN=')+3:res.rindex('CN=')+15].strip()
            if cn == str('self signed ') or cn == str('CA auto sign'):
                os.unlink(ca_file)
                prep_dir()
    if os.path.isfile(file_serial):
        serial = open(file_serial).read().strip()
        # conversion en hexa
        serial = int(serial, 16)
        if serial < min_serial:
            if os.path.isfile(ca_file):
                os.unlink(ca_file)
            os.unlink(file_serial)
            for f_index in glob.glob(os.path.join(ssl_dir, 'index*')):
                os.unlink(f_index)
            for f_cert in glob.glob(os.path.join(newcerts_dir, '*.pem')):
                os.unlink(f_cert)
            prep_dir()

def gen_ca(regen=False, del_passwd=True):
    """
    Generation ca
    """
    generated = False
    prep_dir()
    if not os.path.isfile(ca_conf_file):
        raise Exception("Fichier template de la configuration du certificat non trouvé :\n\t%s\n" % ca_conf_file)
    if regen or (not os.path.isfile(ca_keyfile)) or (not os.path.isfile(ca_file)):
        print("Génération du certificat de la CA")
        ## On genère le certif de l'ac
        ca_gen = "/usr/bin/openssl req -x509 -config %s -newkey rsa:%s -days %s -keyout %s -out %s >/dev/null 2>&1" % (ca_conf_file, ssl_default_key_bits, ssl_default_cert_time, tmp_keyfile, ca_file)
        cmd = Popen(ca_gen, shell=True)
        if cmd.wait() != 0:
            raise Exception("Erreur lors de la génération de la CA")
        if del_passwd:
            sup_passwd(tmp_keyfile, ca_keyfile)
        if os.path.isfile(tmp_keyfile):
            os.unlink(tmp_keyfile)
        generated = True
    ## génération d'une crl
    if not os.path.isfile(os.path.join(ssl_dir, 'eole.crl')):
        print("Génération de la liste de révocation")
        crl_gen = "/usr/bin/openssl ca -gencrl -config %s -crldays %s -out %s/eole.crl >/dev/null 2>&1" % (ca_conf_file, dico.get_creole('ssl_default_cert_time'), ssl_dir)
        cmd = Popen(crl_gen, shell=True)
        if cmd.wait() != 0:
            raise Exception("Erreur lors de la génération de la CRL (%s/eole.crl)" % ssl_dir)
    ## application des droits
    finalise_cert(ca_file, ca_keyfile, key_chmod='600')
    return generated

def merge_ca():
    """
    concatène toutes les ca utiles dans ca.crt
    """
    ## concaténation des certificats education
    ca_list = [ca_file, os.path.join(cert_dir, 'ACInfraEducation.pem')]
    ## concaténation de certificats supplémentaires si définis
    for ca_perso in glob.glob(os.path.join(local_ca_dir,'*.*')):
        if os.path.isfile(ca_perso):
            ca_list.append(ca_perso)
    concat_fic(ca_dest_file, ca_list, True)

def gen_certif(certfile, keyfile=None, key_user='', key_grp='', key_chmod='',
        cert_user='', cert_grp='', cert_chmod='', regen=False, copy_key=False,
        del_passwd=True, signe_req=True, container=None):
    """
    Génération des requêtes de certificats et signature par la CA
    """
    if not os.path.isfile(conf_file):
        raise Exception("Fichier template de la configuration du certificat non trouvé :\n\t%s\n" % conf_file)

    basefile = os.path.splitext(certfile)[0]
    if keyfile is None:
        keyfile = "%s.key" % (basefile)

    if container != None:
        container_dico = load_container_var()
        container_path = container_dico.get('container_path_%s' % container, "")
        certfile = container_path + certfile
        keyfile =  container_path + keyfile

    if regen or not os.path.isfile(certfile) or not os.path.isfile(keyfile):

        if not isdir(dirname(certfile)):
            raise Exception("le repertoire %s n'existe pas" % dirname(certfile))
        if not isdir(dirname(keyfile)):
            raise Exception("le repertoire %s n'existe pas" % dirname(keyfile))

        # certificat absent ou regénération demandée
        fic_p10 = os.path.join(req_dir, "%s.p10" % (os.path.basename(basefile)))
        # génération de la requête de certificat x509 et d'un simili certificat auto-signé
        gen_req = "/usr/bin/openssl req -new -newkey rsa:%s -days %s -config %s -keyout %s -out %s >/dev/null 2>&1" % (
                  ssl_default_key_bits, ssl_default_cert_time, conf_file, tmp_keyfile, fic_p10)
        cmd = Popen(gen_req, shell=True)
        if cmd.wait() != 0:
            raise Exception('! Erreur lors de la génération de la requête ssl dans %s !' % fic_p10)
        if del_passwd:
            sup_passwd(tmp_keyfile, keyfile)
        else:
            copy(tmp_keyfile, keyfile)
        if os.path.isfile(tmp_keyfile):
            os.unlink(tmp_keyfile)
        if signe_req:
            # on signe la requête
            ca_signe = "/usr/bin/openssl ca -in %s -config %s -out %s -batch -notext >/dev/null 2>&1" % (fic_p10, conf_file, certfile)
            cmd = Popen(ca_signe, shell=True)
            if cmd.wait() != 0:
                raise Exception('! Erreur lors de la signature de la requête dans %s !' % fic_p10)
            print("* Certificat %s généré" % certfile)
        if copy_key:
            concat_fic(certfile, [keyfile])
    finalise_cert(certfile, keyfile, key_user=key_user,
                            key_grp=key_grp, key_chmod=key_chmod,
                            cert_user=cert_user, cert_grp=cert_grp,
                            cert_chmod=cert_chmod)
    return True

def gen_privkey(path_privkey, bits=dico.get_creole('ssl_default_key_bits')):
    """
    Génération et écriture d'une clé rsa.
    @path_privkey : chemin du fichier de sortie
    @bits (optionnel) : longueur de la clé à générer
    """
    if not os.path.exists(os.path.dirname(path_privkey)):
        os.makedirs(os.path.dirname(path_privkey))
    res = system_out(["/usr/bin/certtool",
                     "--generate-privkey",
                     "--outfile", path_privkey,
                     "--bits", bits])
    os.chmod(path_privkey, 0640)
    try:
        ssl_cert_id = getgrnam('adm')[2]
    except KeyError:
        ssl_cert_id = -1
        print("Le groupe adm n'existe pas ; la clé appartient au groupe root.")
    os.chown(path_privkey, -1, ssl_cert_id)
    return path_privkey


def gen_request(request_template, path_privkey, path_request=None):
    """
    Génération de la requête.
    Si path_request est fourni, la fonction écrit directement la requête
    et renvoie cette variable. Sinon, la fonction renvoie le contenu de
    la requête.
    @request_template : modèle pour générer la requête sans question
    @path_privkey : chemin du fichier de la clé privée
    @path_request (optionnel) : chemin du fichier de sortie
    """
    if path_request:
        res, data, msg = system_out(["/usr/bin/certtool",
                                    "--generate-request",
                                    "--template", request_template,
                                    "--load-privkey", path_privkey,
                                    "--outfile", path_request])
        return path_request
    else:
        res, data, msg = system_out(["/usr/bin/certtool",
                                    "--generate-request",
                                    "--template", request_template,
                                    "--load-privkey", path_privkey])
        return data



def gen_selfsigned_cert(request_template, path_privkey, path_cert=None):
    """
    Génération d'un certificat auto-signé.
    Si path_cert est fourni, la fonction écrit directement la requête
    et renvoie cette variable. Sinon, la fonction renvoie le contenu de
    la requête.
    @request_template : modèle pour générer la requête sans question
    @path_privkey : chemin du fichier de la clé privée
    @path_cert (optionnel) : chemin du fichier de sortie
    """
    if path_cert:
        res, data, msg = system_out(["/usr/bin/certtool",
                                    "--generate-self-signed",
                                    "--template", request_template,
                                    "--load-privkey", path_privkey,
                                    "--outfile", path_cert])
        return path_cert
    else:
        res, data, msg = system_out(["/usr/bin/certtool",
                                    "--generate-self-signed",
                                    "--template", request_template,
                                    "--load-privkey", path_cert])
        return data


class ServerContextFactory:
    """
    Factory permettant de créer un contexte SSL
    à utiliser pour les serveurs twisted (xmlrpc ...)
    """

    # recherche d'un éventuel certificat configuré
    cert_file = dico.get_creole('server_cert', cert_file)
    key_file = dico.get_creole('server_key', key_file)
    def __init__(self, certfile='', keyfile='', cafile=''):
        self.keyfile = None
        if certfile != '':
            self.certfile = certfile
        else:
            self.certfile = cert_file
        if keyfile != '':
            self.keyfile = keyfile
        else:
            self.keyfile = key_file
        if cafile != '':
            self.cafile = cafile
        else:
            self.cafile = ca_dest_file

    def getContext(self):
        """Initialisation du contexte SSL et chargement des certificats
        """
        ctx = SSL.Context(SSL.SSLv23_METHOD)
        ctx.use_certificate_file(self.certfile)
        try:
            ctx.use_privatekey_file(self.certfile)
        except:
            if self.keyfile is not None:
                alt_keyfile = self.keyfile
            else:
                # impossible de charger la clé depuis le fichier du certificat on regarde si il n'y a pas un fichier .key associé
                alt_keyfile = os.path.splitext(self.certfile)[0] + '.key'
            ctx.use_privatekey_file(alt_keyfile)
        if self.cafile and os.path.isfile(self.cafile):
            try:
                # chargement des ca à envoyer au client
                ctx.load_client_ca(self.cafile)
            except Exception, e:
                # En cas d'erreur, on continue quand même.
                print 'Erreur au chargement des CA à envoyer aux clients (%s) : %s' % (self.cafile, str(e))
        return ctx

# gen_certif utils reader

def certif_loader(regen=None):
    """charge les fichiers permettant de générer les certificats
    """
    # XXX FIXME : changer le path de data vers les paquets container,
    # XXX FIXME et déplacer les .gen_cert
    files = glob.glob(join('/usr/share/eole/certs', '*_*.gen_cert'))
    files.sort()
    for fname in files:
        # puts name in global namespace because we need it in execfile's
        # namespace in rules_loader
        name = splitext(basename(fname))[0].split('_')[1]
        # exec gen_certs
        execfile(fname, globals(),locals())

def get_subject(cert=None, certfile=None):
    """
    récupère le subject d'un certificat.
    spécifier obligatoirement un des deux paramètres :
    - cert : contenu du certificat
    - certfile : nom du fichier du certificat
    """
    if None not in (cert, certfile):
        raise Exception('cert or certfile must be None')
    if cert == certfile:
        raise Exception('cert or certfile must be set')
    if certfile != None:
        cmd = ['openssl', 'x509', '-in', certfile, '-subject', '-noout']
        stdin = None
    else:
        cmd = ['openssl', 'x509', '-subject', '-noout']
        stdin = cert
    ret = system_out(cmd=cmd, stdin=stdin)
    if ret[0] != 0:
        raise Exception('error in %s: %s' % (' '.join(cmd), str(ret[2])))
    ret = ret[1].rstrip()
    if not ret.startswith("subject= "):
        raise Exception('Sujet du certificat invalide : %s '% ret)
    regexp = '^subject= (.*)/CN=(.*)'
    return re.findall(regexp, ret)[0]

def get_issuer_subject(cert=None, certfile=None):
    """
    récupère le subject de la CA d'un certificat.
    spécifier obligatoirement un des deux paramètres :
    - cert : contenu du certificat
    - certfile : nom du fichier du certificat
    """
    if None not in (cert, certfile):
        raise Exception('cert or certfile must be None')
    if cert == certfile:
        raise Exception('cert or certfile must be set')
    if certfile != None:
        cmd = ['openssl', 'x509', '-in', certfile, '-issuer', '-noout']
        stdin = None
    else:
        cmd = ['openssl', 'x509', '-issuer', '-noout']
        stdin = cert
    ret = system_out(cmd=cmd, stdin=stdin)
    if ret[0] != 0:
        raise Exception('error in %s: %s' % (' '.join(cmd), str(ret[2])))
    ret = ret[1].rstrip()
    if not ret.startswith("issuer= "):
        raise Exception('Sujet de la CA du certificat invalide : %s '% ret)
    regexp = '^issuer= (.*)/CN=(.*)'
    return re.findall(regexp, ret)[0]

def load_conf(ssl_dico):
    global ssl_dir, cert_dir, key_dir, tmp_keyfile, file_serial, req_dir
    global local_ca_dir, newcerts_dir, ca_conf_file, conf_file
    global ca_file, ca_dest_file, ca_keyfile, start_index, min_serial
    global ssl_default_key_bits, ssl_default_cert_time

    ssl_dir = ssl_dico.get('ssl_dir', ssl_dir)
    cert_dir = ssl_dico.get('cert_dir', os.path.join(ssl_dir, "certs"))
    key_dir = ssl_dico.get('key_dir', os.path.join(ssl_dir, "private"))
    tmp_keyfile = ssl_dico.get('tmp_keyfile', os.path.join(key_dir, "tmpkey.key"))
    file_serial = ssl_dico.get('file_serial', os.path.join(ssl_dir, "serial"))
    req_dir = ssl_dico.get('req_dir', os.path.join(ssl_dir, "req"))
    local_ca_dir = ssl_dico.get('local_ca_dir', os.path.join(ssl_dir, "local_ca"))
    newcerts_dir = ssl_dico.get('newcerts_dir', os.path.join(ssl_dir, "newcerts"))
    ca_conf_file = ssl_dico.get('ca_conf_file', ca_conf_file)
    conf_file = ssl_dico.get('conf_file', conf_file)
    # chemin de la CA
    ca_file = ssl_dico.get('ca_file', os.path.join(cert_dir, "ca_local.crt"))
    ca_dest_file = ssl_dico.get('ca_dest_file', os.path.join(cert_dir, "ca.crt"))
    ca_keyfile = ssl_dico.get('ca_keyfile', os.path.join(key_dir, "ca.key"))
    # index
    start_index = ssl_dico.get('start_index', 30)
    min_serial = int(eval('0x%s' % start_index))
    ssl_default_key_bits = ssl_dico.get('ssl_default_key_bits', dico.get_creole('ssl_default_key_bits'))
    ssl_default_cert_time = ssl_dico.get('ssl_default_cert_time', dico.get_creole('ssl_default_cert_time'))

ssl_dir=None
ca_conf_file=None
conf_file=None
load_conf({'ssl_dir': '/etc/ssl',
           'ca_conf_file': '/etc/eole/ssl/ca-eole.conf',
           'conf_file': '/etc/eole/ssl/certif-eole.conf'})
certs_catalog = get_certs_catalog()
