# -*- coding: utf-8 -*-
"""
fichier de configuration pour créole

"""
from os import getuid
from os.path import isfile, isdir, join
from sys import stderr
from creole2.error import VirtError

KERNEL_FILE = '/usr/share/eole/noyau/current'
LOCALKERNEL_FILE = '/usr/share/eole/noyau/local'
REBOOT_FILE = '/var/run/reboot-required'

logfile = '/var/log/creole.log'
#info, debug, ...
loglevel = 'debug'

charset = 'UTF8'

# chemin par defaut des templates, fichier config.eol, etc
configeoldir = '/etc/eole/'
eoleroot = '/usr/share/eole/creole/'
vareole = '/var/lib/eole'

configeol = join(configeoldir, 'config.eol')
containers_bridge_file = join(configeoldir, 'containers_bridge.conf')
containers_default_network = '192.0.2'

# certificats
cert_file = '/etc/ssl/certs/eole.crt'
key_file = '/etc/ssl/certs/eole.key'
# rsyslog pki
rsyslog_ca_file = '/etc/rsyslog.d/ssl/certs/rsyslog_ca.pem'
rsyslog_request_template = '/etc/rsyslog.d/ssl/rsyslog-request.tmpl'
rsyslog_ca_template = '/etc/rsyslog.d/ssl/rsyslog-ca.tmpl'
# port du serveur creole_serv
port_rpc = 4333

# chemin du répertoire source des fichiers templates
templatedir = '/var/lib/creole'

dicos_dir = join(eoleroot, 'dicos')
modif_dir = join(eoleroot, 'modif')
distrib_dir = join(eoleroot, 'distrib')
patch_dir = join(eoleroot, 'patch')

# chemin pour les fichiers de données
datadir = '/usr/share/creole'
# chemin pour les modules de fonctions supplémentaires
func_dir = join(datadir,'funcs_creole2')

# repertoire du ou des dictionnaires xml creole
eoledirs = [dicos_dir, join(dicos_dir, 'variante'), join(dicos_dir, 'local')]

# repertoire de la dtd
dtddir = datadir

# fichier avec dictionnaire exporte pour bash
conf_file = '/etc/eole/eole.conf'
containers_file = '/etc/eole/containers.conf'
network_containers_file = '/etc/eole/network_containers.conf'
init_services_file = '/etc/eole/init_service.conf'
container_ssh_config_file = '/etc/eole/ssh_config'
container_instance_lockfile = '/etc/eole/.container_instance.lock'
container_fstab_dir = '/usr/share/eole/lxc/fstab'

# repertoire avec le fichier lock
LOCK_PATH = '/var/lock'
LOCK_FILES = ['eolemaj-auto', 'eolesauvegarde', 'eolereconfigure',
              'eoleimport', 'eolemaj-cd']

# Nom du serveur maitre
VIRTMASTER = 'root'
VIRTROOT = '/var/lib/lxc'
VIRTBASE = 'rootfs'
# Desactiver les conteneurs
#egalement dans dans FonctionEoleNg
VIRTDISABLED = True

# Egalement dans FonctionEoleNg
VIRTDISABLED_LOCKFILE = '/etc/eole/.VirtDisabled.lock'
VIRTENABLED_LOCKFILE = '/etc/eole/.VirtEnabled.lock'

# services dont l'arrêt peut provoquer la déconnexion Ead2
EAD_SERVICES = ['ead-server', 'ead-web', 'eole-sso']

if not isdir('/usr/share/doc/eolebase-conteneur'):
    # les définitions suivantes ne sont pas disponibles en mode conteneur

    # firewall
    firewall_rules_dir = '/usr/share/eole/firewall'

    # template et cibles pour les services actifs
    tserv = join(templatedir, 'services')
    dserv = '/etc/eole/services'


    eole_module = ""
    eole_version = ""

    def log(type_action, etat, msg, date=''):
        from zephir.lib_zephir import log
        log(type_action, etat, msg, date)

    try:
        from zephir.zephir_conf.zephir_conf import id_serveur
        zephir_actif = True
    except:
        zephir_actif = False

    if isfile('/usr/share/eole/lxc_install.sh'):
        if isfile(VIRTDISABLED_LOCKFILE):
            raise VirtError("incohérence : serveur configuré sans conteneur, mais le paquet eole-conteneur est installé")
        if getuid() == 0:
            if not isfile(VIRTENABLED_LOCKFILE):
                fh = file(VIRTENABLED_LOCKFILE, 'w')
                fh.write("## please don't touch this file ##")
                fh.close()

        VIRTDISABLED = False
    else:
        if isfile(VIRTENABLED_LOCKFILE):
            raise VirtError("incohérence : serveur configuré avec conteneur, mais le paquet eole-conteneur n'est pas installé")
        # on ecrit le fichier lock
        if getuid() == 0:
            if not isfile(VIRTDISABLED_LOCKFILE):
                fh = file(VIRTDISABLED_LOCKFILE, 'w')
                fh.write("## please don't touch this file ##")
                fh.close()

## __all__ est utilisee pour lister les variables de conf qui peuvent etre ecrasees
#__authorize_update__ = ['VIRTDISABLED']

#def update_config(fname= '/etc/eole/creole.conf', context=[]):
#    """modification eventuelle ``config.py``
#    provenant de variables definies dans ``/etc/eole/``
#    """
#    # retrieves the external datas
#    if isfile(fname):
#        local = {}
#        execfile(fname, {}, local)
#        # is it authorized to import it in the config globals ?
#        globs = globals()
#        for key, value in local.items():
#            if key in globs:
#                if key in __authorize_update__:
#                    globs[key] = value
#            else:
#                # I don't care !
#                pass
## ecrasement eventuel de la config de base
#update_config()
