# -*- coding: UTF-8 -*-
u"""
librairie d'instanciation de fichiers templates à partir d'un dictionnaire xml
"""

import os.path as osp
from creole2.cfgparser import EoleDict
from creole2.template import Template
from creole2.config import eoledirs
from creole2.error import ConfigError

def instance(inputfile, xmlfile, outputfile, inifile):
    """
    renommer le fichier source en un .ori
    car le template va le copier au mme endroit
    """
    datadir = osp.join(osp.dirname(inputfile))
    t = Template(inputfile, templatedir=datadir)
    eoledict = EoleDict(templatedir=datadir)
    if xmlfile == None:
        xmlfile = eoledirs
    else:
        xmlfile = xmlfile.split(',')
    for xmlf in xmlfile:
        if osp.isdir(xmlf):
            eoledict.read_dir(xmlf)
        else:
            eoledict.read(xmlf)
    if not eoledict.load_values(inifile):
        raise ConfigError("Fichier de configuration non valide : %s" % str(inifile))
    # on vérifie que la configuration est valide
    eoledict.save_values('/dev/null')
    t.target = outputfile
    t.process(eoledict)

