# -*- coding: utf-8 -*-

import sys,os,getopt,re,csv
from creole2 import config
from os.path import join
# import des fonctions de validation des données
# from eosfuncs import  *

class InvalidDataError(Exception):
    def __init__(self, reason):
        self.value=reason
    def __str__(self):
        return self.value

class PositionError(Exception):
    def __init__(self, reason):
        self.value=reason
    def __str__(self):
        return self.value

class VariableInconnue(Exception):
    def __init__(self, var_name):
        self.value=var_name
    def __str__(self):
        return "la variable eole <"+self.value+"> est inconnue !"

class FonctionInconnue(Exception):
    def __init__(self, func_name):
        self.value=func_name
    def __str__(self):
        return "la fonction <"+self.value+"> est inconnue !"

class CreoleError(Exception):
    def __init__(self, msg):
        self.value=msg
    def __str__(self):
        return str(self.value)

def read_convert(filename):
    data = {}
    if not os.path.isfile(filename):
        raise IOError, "fichier %s introuvable" % filename
    for line in file(filename):
        if line.strip() != '' and not line.strip().startswith('#'):
            oldvar, newvar = line.strip().split()
            if data.has_key(newvar):
                data[newvar].append(oldvar)
            else:
                data[newvar] = [oldvar]
    return data

def detect_module(creole_vars):
    if 'url_crl_1' in creole_vars:
        return 'sphynx'
    elif 'install_rvp' in creole_vars:
        return 'amon'
    elif 'domaine_messagerie_etab' in creole_vars:
        return 'scribe'
    elif 'adresse_netware' in creole_vars:
        return 'horus'
    elif 'admin_zephir' in creole_vars:
        return 'zephir'
    else:
        return ''

class DicoEole:


    def __init__(self,filename=config.configeol,rep_perso=None,encoding=None,dico_zephir=[],verbose=0):
        self.sections = 1
        # initialisation du dictionnaire depuis un fichier
        self.dictionnaire = {}
        self.liste_vars = {}
        # position actuelle dans la liste des variables (pointeur pour la saisie)
        self.position = 0
        # nombre total de variables dans le dictionnaire
        self.nbvars = 0
        self.verbose = verbose

        in_buffer = self._lecture_dico(filename,rep_perso,encoding,dico_zephir)

        commentaires = ""
        num_var = 0
        self.fichiers = in_buffer[0]
        for ligne in in_buffer[1]:
            if ligne.count('@@') == 0 or ligne.strip().startswith('#'):
                # on stocke les commentaires précédant la variable
                commentaires += ligne
            else:
                nom_var,commandes,valeur,libelle,options,fin_ligne = self._parse_ligne_(ligne)
                # liste ordonnées des variables
                self.dictionnaire[num_var]=[nom_var,valeur,libelle,options,commandes,fin_ligne,commentaires]
                # liste permettant de retrouver le numéro depuis un nom de variable
                # pour optimiser les recherches
                self.liste_vars[nom_var]=num_var
                commentaires = ""
                num_var += 1

        self.nbvars = num_var

    def _lecture_dico(self,filename,rep_perso,encoding,dico_zephir):
        buffer_debut = []
        buffer_fin = []

        # on ouvre le fichier, et on lit son contenu
        if dico_zephir == []:
            # travail en mode fichier local
            try:
                in_file = open(filename,"r")
                in_buffer = in_file.readlines()
                in_file.close()
            except:
                sys.exit("erreur, fichier %s non trouvé" % filename)
        else:
            # travail avec les données envoyées par zephir
            in_buffer = dico_zephir[0]

        debut = 1
        for ligne in in_buffer:
            if not ligne.startswith('%%'):
                if debut == 0:
                    if encoding != None:
                        buffer_fin.append(unicode(ligne,"ISO-8859-1").encode(encoding))
                    else:
                        buffer_fin.append(ligne)
                else:
                    # si le fichier n'est pas encore listé, on l'ajoute
                    if ligne not in buffer_debut or ligne.strip().startswith('#'):
                        if encoding != None:
                            buffer_debut.append(unicode(ligne,"ISO-8859-1").encode(encoding))
                        else:
                            buffer_debut.append(ligne)
            else:
                self.sections += 1
                debut = 0


        # traitement des fichiers additionnels
        if dico_zephir == []:
            if rep_perso is not None and os.path.isdir(rep_perso):
                liste_dicos = []
                for file_perso in os.listdir(rep_perso):
                    if file_perso.endswith('.eol'):
                        liste_dicos.append(rep_perso+os.sep+file_perso)
                # fichiers de variante si présent
                if os.path.isdir(rep_perso+os.sep+'variante'):
                    for file_perso in os.listdir(rep_perso+os.sep+'variante'):
                        if file_perso.endswith('.eol'):
                            liste_dicos.append(rep_perso+os.sep+'variante'+os.sep+file_perso)
                # traitement des différents dictionnaires additionnels trouvés
                for dico_ad in liste_dicos:
                    if os.path.isfile(dico_ad):
                        in_file = open(dico_ad,"r")
                        in_buffer = in_file.readlines()
                        in_file.close()
                        debut = 1
                        for ligne in in_buffer:
                            if not ligne.startswith('%%'):
                                if debut == 0:
                                    buffer_fin.append(ligne)
                                else:
                                    # si le fichier n'est pas encore listé, on l'ajoute
                                    if ligne not in buffer_debut or ligne.strip().startswith('#'):
                                        buffer_debut.append(ligne)
                            else:
                                debut = 0

                # on vérifie qu'il n'existe pas de doublons dans les noms de variables
                dico_var = {}
                for ligne in buffer_fin:
                    if ligne.count('@@') > 0:
                        champs = ligne.split('@@')
                        if dico_var.has_key(champs[0]):
                            sys.exit("erreur, la variable '%s' est définie plus d'une fois dans l'ensemble des dictionnaires" % champs[0])
                        else:
                            dico_var[champs[0]] = champs[1]
        else:
            # mode zephir
            for in_buffer in dico_zephir[1:]:
                debut = 1
                for ligne in in_buffer:
                    if not ligne.startswith('%%'):
                        if debut == 0:
                            buffer_fin.append(ligne)
                        else:
                            # si le fichier n'est pas encore listé, on l'ajoute
                            if ligne not in buffer_debut or ligne.strip().startswith('#'):
                                buffer_debut.append(ligne)
                    else:
                        debut = 0

            # on vérifie qu'il n'existe pas de doublons dans les noms de variables
            dico_var = {}
            for ligne in buffer_fin:
                if ligne.count('@@') > 0:
                    champs = ligne.split('@@')
                    if dico_var.has_key(champs[0]):
                        sys.exit("erreur, la variable '%s' est définie plus d'une fois dans l'ensemble des dictionnaires" % champs[0])
                    else:
                        dico_var[champs[0]] = champs[1]

        # création du tampon complet
        in_buffer =[]
        fichiers=[]
        # fichiers templatisés
        for ligne in buffer_debut:
            in_buffer.append(ligne)
            fichiers.append(ligne.strip())
        # séparateur
        in_buffer.append("%%\n")
        # variables éole
        for ligne in buffer_fin:
            in_buffer.append(ligne)

        return [fichiers,in_buffer]


    def _calcul_commandes_(self):
        """ fonction interne de calcul des valeurs par défaut et de la visibillité des variables """
        invisible = 0
        data = self.dictionnaire[self.position]
        valeur = data[1]
        if data[4] != "":
            invisible,valeur = self._input_cmd_(data[4],data[1])
            if valeur != data[1]:
                data[1] = valeur
                self.dictionnaire[self.position]=data
        return [data[0],data[1],data[2],invisible]

    def _input_cmd_(self,commandes,valeur):
        """ fonction générale d'affectation de valeur à une variable du dictionnaire
        valeur : valeur par défaut de la variable
        """
        arguments=commandes.split(';')

        ret_invisible = 0
        new_val = valeur

        # définition de la fonction d'évaluation des valeurs par défaut
        for commande in arguments:
            calcul_func = ""
            if commande != 'invisible' and commande != '':
                # on récupère la fonction associée et les arguments donnés dans le dictionnaire
                func = commande.split('??')
                if calcul_functions.has_key(func[0]):
                    # la fonction existe, on définit son appel
                    calcul_func += calcul_functions[func[0]]+"("
                    first_arg = 1
                    for arg in func[1:]:
                        if first_arg == 0:
                            calcul_func += ','
                        else:
                            first_arg=0

                        if arg.startswith('$'):
                            # on utilise une autre donnée du dictionnaire
                            calcul_func += "self.dictionnaire[self.liste_vars['"+arg[1:]+"']][1]"
                        else:
                            calcul_func += arg
                    #on termine la définition de l'appel de fonction
                    calcul_func += ")"

                    # on fait appel à la fonction
                    invisible,calc_val=eval(calcul_func)
                    if commande.count("optionnel??") < 1:
                        new_val=calc_val
                    if invisible == 1:
                        ret_invisible = 1

                else:
                    raise FonctionInconnue(func[0])

        return ret_invisible, new_val

    def _verif_data_(self,force,data,options):
        """ fonction principale de test
            force : permet de passer outre le parametre 'obligatoire'
            (utilisé dans gen_dico pour saisir un dico partiel)
            data : valeur saisie
            options : fonctions de controle et arguments
            fait appel au autres fonctions selon les options demandées
            retourne un tuple (résultat, raison de l'echec)
        """
        result=1
        if (data.count(" ") > 0 or data.count('\t')) > 0 and not 'varchar' in options:
            result = 0
            error_msg = "Les espaces sont interdits, recommencez"
        else:
            for option in options:
                if option != 'varchar':
                    # on sépare le nom de la fonction de test et ses arguments
                    args  = option.split('??')
                    if args[0] != '':
                        if test_functions.has_key(args[0]):
                            # construction de l'appel de la fonction
                            func_string = test_functions[args[0]]+'(%s,data ' % force
                            for argument in args[1:]:
                                func_string+=','
                                if argument.startswith('$'):
                                    # on utilise une autre donnée du dictionnaire
                                    if donnees_dispo.has_key(argument[1:]):
                                        func_string += "self.dictionnaire[self.liste_vars['"+argument[1:]+"']][1]"
                                else:
                                    func_string += argument

                            func_string += ')'

                            result,error_msg = eval(func_string)
                            if result == 0:
                                # au premier test échoué
                                # on arrete les tests et on demande une nouvelle saisie
                                break
                        else:
                            raise FonctionInconnue(args[0])

        if result == 1:
            return (1,"")
        else:
            return (0,error_msg)


    def _parse_ligne_(self,ligne):
        """ fonction de lecture d'une ligne contenant une variable
        """
        # récupération des options de commande (champ caché, valeur par défaut calculée, ...)
        champs = ligne.split('§§')
        try:
            fin_ligne = ligne[ligne.index("#"):]
        except ValueError:
            fin_ligne = ""
        ligne = champs[0].rstrip()
        try:
            commandes = champs[1].strip()
        except IndexError:
            # pas de commande définie
            commandes = ""

        # nom de la variable
        champs = ligne.split('@@')
        nom_var = champs[0]
        # libelle, valeur par défaut et options de vérification
        try:
            liste = champs[1].split('#')
            valeur = liste[0].strip()
            libelle = liste[1].strip()
        except IndexError:
            sys.exit("""ligne malformée (variable@@val.defaut#question) :
            \n %s""" % champs)
        try:
            # on regarde si des vérifications sont demandées pour ce champ
            options = liste[2].strip().split(';')
        except IndexError:
            # pas de vérification spécifiée
            options = []
        # préparation du libellé pour affichage
        libelle.replace('\n','')
        libelle.replace('\t','')
        libelle.lstrip()
        return nom_var,commandes,valeur,libelle,options,fin_ligne

    ###########################
    ## fonctions utilisateur
    ###########################

    def validate_syntax(self):
        # vérification du nombre de sections
        if self.verbose:
            sys.stderr.write("\nVérification de la structure ...\n")
        if self.sections != 2:
            if self.sections > 2:
                raise CreoleError('plus de deux sections')
            else:
                raise CreoleError('moins de deux sections')

        # vérification des noms de variables et de
        # la présence des valeurs
        if self.verbose:
            sys.stderr.write("\nAnalyse de la section 2 ...\n\n")
        i=1
        for nom_var in self.liste_vars.keys():
            if len(nom_var.split()) != 1:
                raise CreoleError("nom de variable incorrect : '%s'" % nom_var)
            # si valeur obligatoire et pas de valeur : erreur
            data = self.dictionnaire[self.liste_vars[nom_var]]
            if 'obligatoire' in data[3] and data [1] == "" and data[4].count('optionnel') == 0:
                raise CreoleError("pas de valeur pour la variable : %s" % nom_var)
            if self.verbose:
                sys.stderr.write("\t%s : SYMBOLE = '%s' ; VALEUR = '%s' \n" % (i,nom_var,data[1]))
            i += 1
        return i


    def ParseDico(self,encoding=None):
        """renvoie un dictionnaire eole du type dico[variable]=[valeur,libelle,options]
        pour compatibilité ascendante (à revoir)
        """
        Dico={}
        for num_var in self.dictionnaire.keys():
            data = self.dictionnaire[num_var]
            if encoding != None:
                Dico[unicode(data[0],"ISO-8859-1").encode(encoding)]=[unicode(data[1],"ISO-8859-1").encode(encoding),unicode(data[2],"ISO-8859-1").encode(encoding),data[3]]
            else:
                Dico[data[0]]=[data[1],data[2],data[3]]
        return Dico

    def get_nb_var(self):
        return self.nbvars

    def get_position(self):
        return self.position

    def get_value(self,var_name):
        """récupère la valeur d'une variable en fonction de son nom"""
        try:
            data=self.dictionnaire[self.liste_vars[var_name]]
        except KeyError:
            raise VariableInconnue(var_name)
        return data[1]

    def get_first(self):
        """ retourne la première valeur du dictionnaire sous la forme suivante :
            [nom,valeur,libelle,invisible]
            invisible est un booléen indiquant si la donnée doit être saisie dans
            le cas d'une saisie optionnelle
        """
        self.position = 0
        return self._calcul_commandes_()

    def get_current(self):
        """ retourne la valeur actuelle du dictionnaire sous la forme suivante :
            [nom,valeur,libelle,invisible]
            invisible est un booléen indiquant si la donnée doit être saisie dans
            le cas d'une saisie optionnelle
        """
        return self._calcul_commandes_()

    def get_next(self):
        """ retourne la valeur suivante du dictionnaire sous la forme suivante :
            [nom,valeur,libelle,invisible]
            invisible est un booléen indiquant si la donnée doit être saisie dans
            le cas d'une saisie optionnelle
        """
        if self.position > self.nbvars-2:
            raise PositionError('fin du dictionnaire atteinte')
        else:
            self.position += 1
        return self._calcul_commandes_()

    def get_prev(self):
        """ retourne la valeur précédente du dictionnaire sous la forme suivante :
            [nom,valeur,libelle,invisible]
            invisible est un booléen indiquant si la donnée doit être saisie dans
            le cas d'une saisie optionnelle
        """
        if self.position < 1:
            raise PositionError('début du dictionnaire atteint')
        else:
            self.position -= 1
        return self._calcul_commandes_()

    def get_var(self,nom_var):
        """ retourne une valeur actuelle du dictionnaire sous la forme suivante :
            [nom,valeur,libelle,invisible]
            invisible est un booléen indiquant si la donnée doit être saisie dans
            le cas d'une saisie optionnelle
        """
        self.position = self.liste_vars[nom_var]
        return self._calcul_commandes_()

    def set_value(self,value,invisible=0,force=0):
        """fonction de vérification et mise à jour d'une valeur saisie dans le dictionnaire"""
        if invisible != 1:
            resultat,raison = self._verif_data_(force,value,self.dictionnaire[self.position][3])
            if resultat == 0:
                raise InvalidDataError(raison)
        # mise à jour de la valeur
        self.dictionnaire[self.position][1]=value
        return 1

    def get_dico(self):
        return self.dictionnaire

    def save(self,out_path="zephir.eol",raw=0):
        """ sauvegarde l'objet dictionnaire en mémoire dans un fichier """
        # création du buffer en mémoire
        out_buffer = ""
        for num_var in self.dictionnaire.keys():
            data = self.dictionnaire[num_var]
            out_buffer+= "%s%s@@%s%s" % (data[6],data[0],data[1],data[5])

        # écriture dans le fichier
        out_file = open(out_path,"w")
        out_file.writelines(out_buffer)
        out_file.close()
        return out_buffer

def ParseDico(filename=config.configeol, encoding=None):
    dico=DicoEole(filename,encoding)
    return dico.ParseDico()


class FichierCreole:
    """classe de gestion des fichiers templatisés créole"""
    def __init__(self,filename,verbose=0):
        self.filename=filename
        self.verbose=verbose
        # lecture du contenu du fichier template
        try:
            fic_eole = file('/etc/eole/'+os.path.basename(self.filename),'r')
            fic_eole.close()
        except IOError:
            raise CreoleError("erreur de lecture de /etc/eole/%s" % os.path.basename(self.filename))
        # on vérifie que le fichier est accessible en écriture
        try:
            if os.path.isfile(self.filename):
                test=open(self.filename,'a')
            else:
                test=open(self.filename,'w')
            test.close()
        except IOError:
            self.writable = 0
            if self.verbose:
                if not os.path.isdir(os.path.dirname(self.filename)):
                    sys.stderr.write("\n !!! Attention, la destination du fichier %s n'existe pas !!! \n" % self.filename)
                else:
                    sys.stderr.write("\n !!! Attention, le fichier %s ne peut pas être écrit !!! \n" % self.filename)
        else:
            self.writable = 1

    def process(self,dico,check_mode):
        """fonction de remplacement des variables par leur valeur"""
        nb_subst=0

        # lecture du contenu
        fic_eole = file('/etc/eole/'+os.path.basename(self.filename),'r')
        contenu_ori = fic_eole.read()
        fic_eole.close()

        # on sépare le fichier en lignes pour détecter les lignes de commentaires
        lignes_ori = contenu_ori.split('\n')
        # détection des variables eole dans le fichier (%%variable%%)
        # utilisation des expressions régulières pour détecter les métacaractères eole
        occurences=[]
        for ligne in lignes_ori:
            if not ligne.strip().startswith('#'):
                occurences.extend(re.findall('%%(\w+)%%',ligne))
        nb_subst = len(occurences)
        # on crée un dictionnaire variable : valeur pour toutes les variables du dico
        variables = {}
        for var in dico.liste_vars.keys():
            variables[var] = dico.get_value(var)

        # on crée un dico variable : valeur (évite de traiter plusieurs fois la même variable)
        variables_utiles = {}
        for variable in occurences:
            variables_utiles[variable.replace('%%','')] = dico.get_value(variable.replace('%%',''))

        # pour chaque variable détectée
	if variables_utiles == {} and (contenu_ori.count('??') > 1):
		# beurk! on force à passer au moins une fois dans la boucle
		# si pas de variables à remplacer mais que le fichier contient
		# des conditions creole
		variables_utiles[dico.liste_vars.keys()[0]]=""

        for variable in variables_utiles.keys():
            lignes = []
            # on récupère la valeur indiquée dans le dictionnaire
            valeur = dico.get_value(variable)
            for ligne in lignes_ori:
                if ligne.strip().startswith('#'):
                    # ligne de commentaire
                    lignes.append(ligne)
                elif re.match('^\?\?(.*)\?\?',ligne) is not None:
                    # ligne avec code de test : on execute le test
                    parts = ligne.split('??')
                    try:
                        if eval(parts[1]):
                            ligne = parts[2]
                            lignes.append(ligne.replace('%%'+str(variable)+'%%', variables[variable]))
                    except Exception, e:
                        raise CreoleError(str(parts[1])+' -> '+str(e))
                else:
                    # on remplace la variable par sa valeur dans le contenu du fichier
                    lignes.append(ligne.replace('%%'+str(variable)+'%%', variables[variable]))
            # on enregistre le nouveau contenu avant de passer à la variable suivante
            lignes_ori=lignes

        # toutes les variables ont été remplacées
        content = lignes_ori

        if check_mode == 0 and self.writable == 1:
            # les variables sont remplacées : on sauvegarde
            fic_eole=file(self.filename,'w')
            fic_eole.write("\n".join(content))
            fic_eole.close()

        # on renvoie le nombre de substitutions effectuées
        return nb_subst



if __name__ == "__main__":
    try:
        filename = sys.argv[1]
    except:
        filename = config.configeol
    print ParseDico(filename)
