# -*- coding: UTF-8 -*-
from os import listdir
from os.path import isfile
from creole2 import config, utils
from creole2.error import NoneError, OutOfRange, TypeEoleError
from creole2.cfgparser import EoleDict
from creole2.utils import stringify
# eosfunc est nécessaire pour les eval()
from creole2 import eosfunc

class GenDico:
    """fonctions ligne de commande pour gen_dico
    """

    def __init__(self, dir_config=config.eoledirs):
        self.dir_config = dir_config
        self.mode = 'normal'
        self.modified = False
        self.filename = ''
        # lecture des dictionnaires
        self.eole_dico = EoleDict(templatedir=config.templatedir)
        self.eole_dico.read_dir(self.dir_config)

    def do_expert(self, args):
        #if self.modified :
        #    next = utils.raw(stringify(_("Your modifications are not saved, continue (yes/no) ?")))
        #    if next.lower() not in ('y', 'yes', 'o', 'oui'):
        #        return
        print _("** Expert Mode **")
        self.mode = 'expert'
        # relecture des dictionnaires en mode expert
        #self.eole_dico = EoleDict(templatedir=config.templatedir, mode='expert')
        #self.eole_dico.read_dir(self.dir_config)

    def do_normal(self, args):
        print _("** Standard Mode **")
        self.mode = 'normal'

    def do_open(self, args):
        """Charger un fichier"""
        if args.split() != [] :
            filename = args.split()[0]
        else:
            files = listdir('.')
            default = ''
            print stringify(_("Current directory files :"))
            for fil in files:
                if isfile(fil) and not fil.startswith('.') and not fil.endswith('~'):
                # affichage des fichiers normaux séparés par des espaces
                    print ' ', fil,
                    if default == '' and fil.endswith('.eol'):
                        # par défaut on propose le 1er .eol trouvé
                        default = fil
            # retour à la ligne
            print
            try:
                filename = utils.raw(stringify(_("Enter the name of the file to open [%s]")) % default)
            except NoneError:
                if default != "":
                    filename = default
                else:
                    print stringify(_("No filename given"))
                    return

        if isfile(filename):
            try:
                self.eole_dico.load_values(filename)
                print stringify(_("File %s successfully loaded")) % filename
                self.filename = filename
                ## test
            except TypeEoleError, e:
                print stringify(_("Error while opening file %s")) % filename
                print e.args[0]
        else:
            print stringify(_("File %s not found")) % filename

    def do_save(self, args):
        """Enregister dans un fichier"""
        filename = raw_input(stringify(_("Enter the name of the file to save [%s] : ")) % self.filename)
        filename = filename.strip()
        if filename == '':
            if self.filename != '':
                filename = self.filename
            else:
                print stringify(_("No filename given"))
                return
        try:
            self.eole_dico.save_values(filename)
            print stringify(_("File %s successfully saved")) % filename
            self.modified = False
        except TypeEoleError, e:
            print stringify(_("Unable to register file %s")) % filename
            print e.args[0]

    def do_showgroups(self, args):
        """Affiche les groupes existants"""
        if self.mode == 'expert':
            groups = self.eole_dico.get_families().keys()
        else:
            groups = self.eole_dico.get_normal_families().keys()
        for group in self.eole_dico.family_order:
            if group in groups:
                print ' ', stringify(group),
        print

    def do_choosegroup(self, args):
        """Choix d'un groupe dans une liste"""
        if self.mode == 'expert':
            groups = self.eole_dico.get_families()
        else:
            groups = self.eole_dico.get_normal_families()
        # liste ordonnée des familles
        ord_list = []
        for fam in self.eole_dico.family_order:
            if fam in groups.keys():
                if not groups[fam]['hidden']:
                    ord_list.append(fam)
        try:
            selgroup = utils.select_list(ord_list)
        except NoneError:
            # FIXME
            return
        except OutOfRange:
            # FIXME
            return

        #exceptions.KeyboardInterrupt
        nvar = 0
        variables = groups[ord_list[selgroup]]['vars']
        masters = self.eole_dico.groups
        slave_size = {}
        while nvar < len(variables):
            var = variables[nvar]
            variable = self.eole_dico.variables[var]
            if variable.hidden:
                # saute les variables cachées
                nvar += 1
                continue
            if var in slave_size.keys() and slave_size[var] == 0:
                # esclave avec 0 valeur (ne devrait pas arriver)
                print self.eole_dico.get_description(var), ': vide'
                self.eole_dico.set_value(var, '')
                nvar += 1
                continue
            while True:
                try:
                    enum = False
                    checks = self.eole_dico.variables[var].checks
                    for check in checks:
                        if check[0] == 'valid_enum':
                            # FIXME ???
                            #checkval = "True"
                            #for param in check[1]:
                            #    if param['name'] == 'checkval':
                            #        checkval = param['value']
                            liste = check[1][0]['value']
                            enum = True
                            break

                    if enum:
                        print "%s (%s)" % (self.eole_dico.get_description(var),
                                           ', '.join(eval(liste)))
                    else:
                        print self.eole_dico.get_description(var)

                    if var in slave_size.keys():
                        ## variable esclave ##
                        if slave_size[var] == 1:
                            print "** variable esclave : 1 seule valeur attendue **"
                        else:
                            print "** variable esclave, séparez les *%d* valeur(s) par des virgules **" % slave_size[var]
                        try:
                            value = []
                            vals = utils.raw('[%s]' % ','.join(self.eole_dico.get_value(var)))
                            for val in vals.split(','):
                                value.append(val.strip())
                        except NoneError:
                            # ENTREE -> on remet la valeur d'origine :)
                            value = self.eole_dico.get_value(var)
                        if value == ['']:
                            value = []
                        if len(value) != slave_size[var]:
                            raise TypeEoleError, "%s : %d valeurs attendues pour cette variable, %d fournies" % (var, slave_size[var], len(value))

                    elif variable.multi:
                        ## variable mutliple (maitre) ##
                        print """** variable multiple, séparez les valeurs par des virgules **"""
                        try:
                            value = utils.raw('[%s]' % ','.join(self.eole_dico.get_value(var)))
                            if value == ",":
                                # "," pour vide
                                value = []
                            else:
                                value = value.split(',')
                        except NoneError:
                            # on remet la valeur d'origine :)
                            value = self.eole_dico.get_value(var)
                        if value == ['']:
                            value = []
                    else:
                        ## variable "normale" ##
                        value = utils.raw('[%s]'%self.eole_dico.get_value(var)[0])
                    self.eole_dico.set_value(var, value)
                    # enregistrement de la taille du maître pour ses esclaves
                    if masters.has_key(var) and variable.multi:
                        for slave in masters[var]:
                            if value == ['']:
                                slave_size[slave] = 0
                            else:
                                slave_size[slave] = len(value)
                    self.modified = True
                    nvar += 1 #ok -> suite
                    break
                except NoneError:
                    try:
                        # chaîne vide : on essaie d'enregistrer au cas où c'est autorisé !
                        self.eole_dico.set_value(var, self.eole_dico.get_value(var))
                        nvar += 1 #ok -> suite
                        break
                    except TypeEoleError, e:
                        print e
                        continue
                except TypeEoleError, e:
                    print e
                    continue
                except KeyboardInterrupt:
                    print
                    if nvar > 0:
                        nvar -= 1 #var préc sur ctrl-c
                    break
                except EOFError:
                    print
                    print _("Exiting from group %s") % ord_list[selgroup]
                    return
                except Exception, e:
                    # FIXME : d'autres exceptions
                    print e.__class__, e
                    return
        print
        print "-- %s --" % stringify(_("end of the group"))
        print

    def do_exit(self, args):
        """Exits from the console"""
        if self.modified :
            save = utils.raw(stringify(_("Do you want to save your configuration yes/no ?")))
            if save.lower() in ('y', 'yes', 'o', 'oui'):
                self.do_save('')
        return -1




#    def do_get_output(self,args):
#        """prints stdout of last action"""
#        if self._action != None:
#            print self.msg
#
#    def do_list_actions(self,args):
#        """prints list of available actions"""
#        if self.id_server == '':
#            print _("no active server")
#        else:
#            print "\n"+_("Available actions on server %s:")%self.id_server+'\n'
#            menu = self.menu['menu']
#            self._affiche(menu)
#            print ""
#
#    def get_magic_number_from_server(self, server, server_addr):
#        """
#        obtient un magic number d'un server
#        on envoi aussi le session_id pour calculer les droits de l'utilisateur au niveau du backend
#        @param server: proxy xmlrpc
#        @param server_addr: adresse au format http(s)://xxx.xxx.xxx.xxx
#        """
#        ip_server = server_addr.split('//')[1]
#        return server.get_magic_number(self.backend_key_dict[ip_server], self.app_ticket, self.login, self.session_id)
#

