# -*- coding: UTF-8 -*-
"""

internationalisation gen_dico (console)

"""

import gettext
from os.path import join
from creole2 import config

I18N_DIR = join(config.datadir, 'i18n')
APP_NAME = "creole"

def enable_i18n():
    """
    activation et configuration de l'internationalisation
    """
    gettext.bindtextdomain (APP_NAME, I18N_DIR)
    gettext.textdomain (APP_NAME)
    # installons la fonction _() dans les builtins
    gettext.install (APP_NAME, I18N_DIR, unicode=1)
    # si _() n'est pas présent, on la remplace par str
    if not '_' in globals().keys():
        globals()['_'] = str

