# -*- coding: UTF-8 -*-
from creole2.config import logfile, loglevel
import logging

class Logger:

    def __init__(self):
        """
        on ne veut pas definir le logger a l'init car le fichier de log
        n'est pas forcement connu
        """
        self.handler = False
        self.filename = None

    def set_logfile(self, filename=logfile, minimal=False, mode='normal'):

        self.logger = logging.getLogger()

        if self.handler:
            self.remove_handler()

        self.filename = filename
        if filename != "NOLOG":
            # si filename spécifié à nologs: désactivation des logs (Zéphir)
            hdlr = logging.FileHandler(filename)
            self.handler = hdlr
            if minimal:
                formatter = logging.Formatter('%(message)s')
            else:
                formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s')
            hdlr.setFormatter(formatter)
            self.logger.addHandler(hdlr)
            loglevl = loglevel.upper()
            self.logger.setLevel(getattr(logging, loglevl))

    def remove_handler(self):
        "kill handler"
        # logging ne referme plus le handler avant suppression -> on le fait
        if self.handler:
            self.handler.close()
        self.logger.removeHandler(self.handler)

    def info(self, message):
        """Loggue un message donné
        """
        if self.filename != "NOLOG":
            self.logger.info(message)

    def error(self, message):
        """Loggue une exception
        """
        if self.filename != "NOLOG":
            self.logger.error(message)

    def debug(self, message):
        if self.filename != "NOLOG":
            self.logger.debug(message)

logger = Logger()
