# -*- coding: utf-8 -*-
###########################################################################
#
# Eole NG - 2010
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr
#
###########################################################################
"""
Librairie pour la gestion des mises à jour
"""
from os import system
from pyeole2 import schedule
from pyeole2.process import system_out

# fichier d'information pour la mise à jour unique
DIFF_FILENAME = '/var/lib/eole/reports/maj-diff.txt'

#########################################
## Mise à jour hebdomadaire (maj_auto) ##
#########################################

def maj_enabled():
    """
    vérifie si la mise à jour est activée ou non
    """
    if ('weekly', 'majauto') in schedule._list_all_enable_file('post'):
        return True
    else:
        return False

def get_maj_day():
    """
    renvoie le jour et l'heure des mises à jour
    """
    shed = schedule.load_schedule()
    shed.pop('monthday')
    shed['weekday'] = schedule.DAY_TO_STRING[shed['weekday']]
    return shed

def enable_maj_auto():
    """
    active la mise à jour hebdomadaire
    """
    if not maj_enabled():
        schedule.add_post_schedule('majauto', 'weekly')

def disable_maj_auto():
    """
    désactive la mise à jour hebdomadaire
    """
    if maj_enabled():
        schedule.del_post_schedule('majauto', 'weekly')


#########################################
##  Mise à jour unique (schedule once) ##
#########################################

def maj_once_enabled():
    """
    vérifie si la mise à jour est activée ou non
    """
    if ('once', 'majauto') in schedule._list_all_enable_file('post'):
        return True
    else:
        return False

def enable_maj_once():
    """
    active la mise à jour hebdomadaire
    """
    if not maj_once_enabled():
        cancel_maj_differee()
        schedule.add_post_schedule('majauto', 'once')
        write_diff(True, 'ce soir')
    return True

def disable_maj_once():
    """
    désactive la mise à jour hebdomadaire
    """
    if maj_once_enabled():
        schedule.del_post_schedule('majauto', 'once')


#########################################
##  Mise à jour unique (maj_differee)  ##
#########################################

def write_diff(enable, heure=None):
    """ ecrit les informations du gestionnaire de mise a jour
        dans le fichier de config de l'ead """
    fic = file(DIFF_FILENAME, 'w')
    if enable:
        fic.write('Une mise à jour est programmée pour %s\n' % heure)
    else:
        fic.write("")
    fic.close()

def cancel_maj_differee():
    """
    déprogramme les mises à jour differées
    """
    disable_maj_once()
    cmd = """for i in `grep -l "Maj-Auto" /var/spool/cron/atjobs/* 2>/dev/null`; do rm -f $i ;  done;"""
    system(cmd)
    write_diff(False)
    return True

def prog_maj_differee(heure, options='-R'):
    """
    Programmation une mise à jour différée de quelques heures
    Elle est lancée via la commande at pour l'utilisateur root
    options : options à passer à Maj-Auto
    """
    if heure == 'once':
        return enable_maj_once()
    # suppression des éventuelles autres maj différées
    cancel_maj_differee()
    stdin = "rm -f %s\nMaj-Auto %s\n" % (DIFF_FILENAME, options)
    ret = system_out(['/usr/bin/at', 'now', '+', str(heure), 'hours'], stdin=stdin)
    if ret[0] != 0:
        return False
    parsed = ret[2].splitlines()[1].split()
    write_diff(True , 'le '+' '.join(parsed[3:7]))
    return True

