# -*- coding: UTF-8 -*-
from os.path import isfile
from pyeole2.process import tcpcheck
from creole2 import config
from creole2.client import CreoleClient
from creole2.eosfunc import load_container_var

def parse_dico(hide_vars=False, dico=None, logfile=None):
    if dico == None:
        # configuration par défaut, on apelle le serveur de configuration
        try:
            conf_containers = load_container_var()
            assert tcpcheck(conf_containers['adresse_ip_br0'], config.port_rpc) == True
            client = CreoleClient()
            # vérification de la disponibilité du serveur
            assert client.ping() == True
            return client.parse_dico(hide_vars)
        except:
            # mode dégradé, on utilise directement la librairie creole
            from creole2.cfgparser import EoleDict
            dico = EoleDict(logfile=logfile)
            dico.read_dir(config.eoledirs)
    # parsing d'un objet EoleDict passé en paramètre
    if isfile(config.configeol):
        # lecture des valeurs actuelles si elles sont disponibles
        dico.load_values()
    return dico.todict(hide_vars)
