# -*- coding: UTF-8 -*-
"""
Gestion du mini-langage de template
On travaille sur les fichiers cibles
"""

from shutil import move
from os.path import isfile, isdir, basename, join, dirname
from os import system, makedirs, unlink
from tempfile import mktemp
import traceback
from logging import error

from Cheetah.Template import Template as ChtTemplate
from Cheetah.NameMapper import NotFound as CheetahNotFound

from creole2.error import FileNotFound, TemplateError
from creole2.log import logger
from creole2 import eosfunc
import creole.config as cfg

class CheetahTemplate(ChtTemplate):
    """classe pour personnaliser et faciliter la construction
    du template Cheetah
    """
    def __init__(self, filename, context):
        self.context = context
        eos = {}
        for func in dir(eosfunc):
            if not func.startswith('_'):
                eos[func] = getattr(eosfunc, func)
        # ajout des variables decrivant les conteneurs
        self.context.update(eosfunc.load_container_var())
        ChtTemplate.__init__(self, file=filename,
                             searchList=[context, eos, {'is_defined':self.is_defined}],
                             compilerSettings={'directiveStartToken' : '%',
                                               'cheetahVarStartToken' : '%%',
                                               'EOLSlurpToken' : '%',
                                               'PSPStartToken' : 'µµµµµµµµµµ',
                                               'PSPEndToken' : 'µµµµµµµµµµ',
                                               'commentStartToken' : 'µµµµµµµµµµ',
                                               'commentEndToken' : 'µµµµµµµµµµ',
                                               'multiLineCommentStartToken' : 'µµµµµµµµµµ',
                                               'multiLineCommentEndToken' : 'µµµµµµµµµµ'})

    def is_defined(self, varname):
        """filtre permettant de ne pas lever d'exception au cas où
        la variable ne serait pas définie
        """
        return varname in self.context

class Template:
    """
    Classe qui transforme un fichier template en fichier instanciable
    """
    def __init__(self, target, source='', mode='', owner='', group='',
                 mkdir=False, templatedir=cfg.templatedir, container=cfg.VIRTMASTER, log=None, del_comment=''):
        """
        @param target   : nom long du fichier cible
        @param source : nom du fichier template si different du nom de la cible
        @param templatedir : répertoire des template
        @param mode : droits Unix à appliquer (ex : 0644)
        @param owner : propriétaire du fichier
        @param group : groupe Unix propriétaire du fichier
        @param mkdir : création du répertoire si nécessaire
        """
        # fichier cible
        self.target = target
        # fichier template
        if source:
            self.filename = join(templatedir, source)
        else:
            self.filename = join(templatedir, basename(self.target))
        # attributs Unix
        self.mode = mode
        self.owner = owner
        self.group = group
        self.mkdir = mkdir
        self.log = logger
        self.container = container
        self.var_dict = None
        self.del_comment = del_comment

    def verify(self):
        """
        verifie que les fichiers existent
        """
        if not isfile(self.filename):
            raise FileNotFound, "le fichier %s n'existe pas" % self.filename
        if not isdir(dirname(self.target)):
            if not self.mkdir:
                raise FileNotFound, "le repertoire %r n'existe pas" % dirname(self.target)
            makedirs(dirname(self.target))
        # FIXME: pose plus de problème qu'autre chose (cf. #3048)
        #if not isfile(self.target):
        #    system('cp %s %s' % (self.filename, self.target))


    def __cmp__(self, other):
        """
        comparer deux objets templates
        en pratique : utiliser pour faire un sort sur les noms de fichiers
        """
        if isinstance(other, Template):
            return cmp(self.target, other.target)
        return 1


    def process(self, eoledict):
        """
        traitement du template
        et écriture du fichier cible
        """
        # 0) suppression des commentaires si nécessaire
        if self.del_comment != '':
            self.log.info('Nettoyage du fichier %s' % self.filename)
            tmpfile = mktemp()
            system("grep -v '^{0}' {1} | grep -v '^$' > {2}".format(self.del_comment, self.filename, tmpfile))
            move(tmpfile, self.filename)

        # 1) remplacement des variables EOLE
        if self.var_dict is None:
            self.var_dict = self._eoledict_to_dict(eoledict)
        try:
            cheetah_template = CheetahTemplate(str(self.filename), self.var_dict)
            data = str(cheetah_template)
        except CheetahNotFound, err:
            # XXX Fragile: err.args devrait avoir la
            #              forme ("cannot find 'varname'",)
            varname = err.args[0][13:-1]
            msg = "Erreur: Utilisation d'une variable non existante dans %s : %r" % (str(self.filename), varname)
            self.log.error(msg)
            raise TemplateError, msg
        except UnicodeDecodeError, err:
            msg = "Probleme d'encodage detecte dans le fichier %s" % str(self.filename)
            self.log.error(msg)
            raise TemplateError, msg
        except Exception, err:
            msg = "Erreur lors de l'instanciation du template %s : %s" % (str(self.filename), str(err))
            self.log.error(msg)
            raise TemplateError, msg
        # 2) écriture du fichier cible
        try:
            file_h = file(self.target, 'w')
            file_h.write(data)
            file_h.close()
        except:
            msg = "Impossible d'ecrire dans le fichier %s" % self.target
            self.log.error(msg)
            raise FileNotFound, msg
        # 3) Gestion des attributs Unix
        if cfg.VIRTDISABLED == True or self.container == cfg.VIRTMASTER:
            chroot = ''
            filename = self.target
        else:
            #path = join(cfg.VIRTROOT, self.container, cfg.VIRTBASE)
            cvar = eosfunc.load_container_var()
            path = cvar['container_path_%s'%self.container]
            chroot = 'chroot %s' % path
            filename = self.target.replace(path, '')
        if self.owner != '':
            system("%s chown %s %s" % (chroot, self.owner, filename))
        if self.group != '':
            system("%s chgrp %s %s" % (chroot, self.group, filename))
        if self.mode != '':
            system("%s chmod %s %s" % (chroot, self.mode, filename))
        # resultat
        self.log.info('%s => %s' % (basename(self.filename), self.target))

    def _eoledict_to_dict(self, eoledict):
        """
        génération du tableau de remplacement
        @return : dictionnaire du type { 'variable' : VALEUR }
                  où VALEUR est soit une valeur directement utilisable
                  (entier, chaine, liste, etc.) soit une instance de
                  `MultiVariable` dans le cas d'une variable multiple.
        """
        for varname in eoledict.variables:
            eoledict.get_final_value(varname)
        return dict( (varname, eoledict.get_final_value(varname))
                     for varname in eoledict.variables )

    def remove_destfile(self):
        """
        suppression du fichier de destination
        """
        if isfile(self.target):
            unlink(self.target)
