# -*- coding: UTF-8 -*-
"""
utilitaires créole
"""

from creole2.error import NoneError, OutOfRange
from creole2.config import charset
from pyeole2.ansiprint import *
import time, hashlib, random

# définition des classes d'adresse IP existantes
classes = {
    '128.0.0.0' : '1'
    , '192.0.0.0' : '2'
    , '224.0.0.0' : '3'
    , '240.0.0.0' : '4'
    , '248.0.0.0' : '5'
    , '252.0.0.0' : '6'
    , '254.0.0.0' : '7'
    , '255.0.0.0' : '8'
    , '255.128.0.0' : '9'
    , '255.192.0.0' : '10'
    , '255.224.0.0' : '11'
    , '255.240.0.0' : '12'
    , '255.248.0.0' : '13'
    , '255.252.0.0' : '14'
    , '255.254.0.0' : '15'
    , '255.255.0.0' : '16'
    , '255.255.128.0' : '17'
    , '255.255.192.0' : '18'
    , '255.255.224.0' : '19'
    , '255.255.240.0' : '20'
    , '255.255.248.0' : '21'
    , '255.255.252.0' : '22'
    , '255.255.254.0' : '23'
    , '255.255.255.0' : '24'
    , '255.255.255.128' : '25'
    , '255.255.255.192' : '26'
    , '255.255.255.224' : '27'
    , '255.255.255.240' : '28'
    , '255.255.255.248' : '29'
    , '255.255.255.252' : '30'
    , '255.255.255.254' : '31'
    , '255.255.255.255' : '32'
}

def string_to_bool(string):
    """
    Transforme les chaines 'True' ou 'False' en valeurs booléennes
    """
    if string == "":
        raise ValueError, 'empty string'
    result = eval(string)
    if result not in [True, False]:
        raise TypeError, """string must be like 'True' or 'False' """
    else: return result


def get_text_node(node):
    """
    @param node: node minidom contenant du texte
    Utilitaire minidom permettant de récupérer le texte d'un node texte
    """
    texte = ""
    nodelist = node.childNodes
    for textnode in nodelist:
        if textnode.nodeType == textnode.TEXT_NODE:
            texte = texte + textnode.data
    return texte


# utilitaires pour la
# ligne de commande

def raw(text):
    """
    Question en ligne de commande : permet de repérer si l'utilisateur a renvoyé quelque chose

    @param text: le libellé de message
    @return: la variable demandée
    """
    var = raw_input(text + " : ")
    if var:
        return var
    else:
        raise NoneError


def stringify(string):
    """
    Encodage des chaînes avec le charset local
    """
    try:
        return string.encode(charset)
    except:
        return string

def encode_list(_list):
    """ encode une liste en utf-8 si les éléments sont de type dico ou str ou liste, unicode"""
    encoded_list = []
    for element in _list:
        if type(element) == str:
            encoded_list.append(encode_str(element))
        elif type(element) == dict:
            encoded_list.append(encode_dico(element))
        elif type(element) == list:
            encoded_list.append(encode_list(element))
        elif type(element) == unicode:
            encoded_list.append(encode_str(element))
        else:
            encoded_list.append(element)
    return encoded_list

def encode_str(string):
    """ encode une string ou un unicode en utf8 """
    try:
        string = string.encode(charset)
    except:
        pass
    return string

def encode_dico(dico):
    """ encode un dico en utf8 dans le cas ou les valeurs soient de type dico, liste, str, unicode """
    for key in dico.keys():
        if type(dico[key]) == str:
            dico[key] = encode_str(dico[key])
        elif type(dico[key]) == unicode:
            dico[key] = encode_str(dico[key])
        elif type(dico[key]) == dict:
            dico[key] = encode_dico(dico[key])
        elif type(dico[key]) == list:
            dico[key] = encode_list(dico[key])
    return dico


def select_list(selection):
    """
    Utilitaire de construction d'une sélection en ligne de commande
    @param selection : liste
    @return :  l'identifiant sélectionné (entier)
    """
    # affichage de la liste (ordonnée)
    for i in selection:
        print selection.index(i) , ':', stringify(i)
        # print selection.index(i) , ':', i[0]

    # recuperation du numero
    try:
        number = int(raw(stringify(_("Choose a number in the list"))))
    except:
        raise OutOfRange
    if number not in range(len(selection)):
        raise OutOfRange
    return number

def gen_random(length=None):
    """
        length: longueur de la chaine aléatoire attendu
    """
    random_id = str(time.time()).split('.')[0]
    random_str = hashlib.sha224('%s/%s' % (random_id, random.randrange(2**100))).hexdigest()
    return random_str[:length]

