#! /usr/bin/env python
# -*- coding: UTF-8 -*-


import base64

KEY_LENGTH = 40
KEYS = [
    0x50,
    0xF7,
    0x82,
    0x69,
    0xEA,
    0x2D,
    0xDD,
    0x2D,
    0x6A,
    0xB4,
    0x33,
    0x8F,
    0xD5,
    0xC7,
    0x90,
    0x9C,
    0x22,
    0x95,
    0x61,
    0xE5,
    0x65,
    0xF6,
    0xB0,
    0x4B,
    0x94,
    0x47,
    0xB0,
    0xBD,
    0x73,
    0x58,
    0x56,
    0x87,
    0x79,
    0x7B,
    0xE6,
    0xB0,
    0xD2,
    0x20,
    0x28,
    0xE1
]

def bitwise(s):
    res = ''
    idx = 0
    for i in range(len(s)):
        res += chr(ord(s[i]) ^ KEYS[idx])
        idx+=1
        if idx > (KEY_LENGTH - 1):
            idx = 0
    return res

def wcrypt(s):
    s = bitwise(s)
    return base64.encodestring(s)[:-1] # encodestring renvoie la chaine avec un '\n', on le vire

def wdecrypt(s):
    s = base64.decodestring(s)
    return bitwise(s)
