# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# eosfuncs.py
#  
# fonction de validation et calcul de valeurs pour Creole1
#       
###########################################################################
import os,sys,re,string
# permet un accès à os.environ si besoin

# mots clés gérés : obligatoire, option, ip, network, netmask, booleen, nombre
# le dicitionnaire suivant décrit tous les mot-clés gérés, et les fonctions de validation qui leur  sont associés

test_functions = {
    'obligatoire':'valid_obligatoire',
    'ip':'valid_ip',
    'plage_ip':'valid_intervalle',
    'network':'valid_network',
    'netmask':'valid_netmask',
    'booleen':'valid_booleen',
    'entier':'valid_entier',
    'enumeration':'valid_enum',
    'regexp':'valid_regexp',
    'shell':'valid_system'
    }

calcul_functions = {
    'calc_network':'calcul_network',
    'calc_broadcast':'calcul_broadcast',
    'optionnel':'calcul_optionnel',
    'val_defaut':'calcul_val',
    'classe_ip':'calcul_classe'
    }


# dictionnaire des valeurs déjà renseignées
donnees_dispo = {}

#############################
## Fonctions de vérification
#############################

def valid_ip(force,data):
    """fonction de validation de la saisie d'une adresse ip"""
    
    if data == "":
        return 1,""
    
    # découpage de l'ip
    ip = data.split('.')
    if len(ip) != 4:
        return 0, "mauvaise syntaxe d'adresse ip, recommencez"
    
    # vérification des nombres
    for part in ip:
        try:
            nb = int(part)
        except ValueError:
            return 0, "l'ip doit être constituée de 4 nombres séparés par des points, recommencez"
        else:
            if not (0 <= nb < 256):
                return 0, "les nombres doivent être compris entre 0 et 255, recommencez"
        
    # on n'a pas rencontré d'erreur        
    return 1,""

def valid_intervalle(force,data):
    """ fonction de validation d'une plage d'ip """
    if data == "":
        return 1,""
    
    liste = data.split()
    if len(liste) != 2:
        return 0,"vous devez spécifier 2 adresses ips"
    else:
        # on vérifie la syntaxe des ips
        for ip in liste:
            result, raison = valid_ip(force,ip)
            if result == 0:
                return result, raison
    return 1,""

def valid_network(force,data,ip=None):
    """fonction de validation de la saisie d'un réseau"""
    if data == "":
        return 1,""
    
    # on utilise la fonction de test d'adresse ip pour la syntaxe
    result, raison = valid_ip(force,data)
    if result == 0:
        return result,raison
    else:
        if ip is not None:
            # on effectue les tests spécifiques au réseau (fonction de l'ip ?)
            ip_parts = ip.split(".")
            network_parts = data.split(".")
            for i in range(4):
                if (int(network_parts[i]) != 0) and (network_parts[i] != ip_parts[i]):
                    return 0,"le réseau spécifié ne correspond pas à l'ip "+ip
        
    # aucune erreur rencontrée
    return 1,""

def valid_netmask(force,data):
    """fonction de validation de la saisie d'un masque réseau"""
    if data == "":
        return 1,""
    
    # on utilise la fonction de test d'adresse ip pour la syntaxe
    result, raison = valid_ip(force,data)
    if result == 0:
        return result,raison
    else:
        # on effectue les tests spécifiques aux masques réseaux
        netmask = []
        for part in data.split("."):
            netmask.append(int(part))
        error = 0
        mask_len=0
        done = 0
        for part in netmask:
            bitmask = 0x80
            for bit in range(8):
                if not done:
                    if part & bitmask:
                        mask_len = mask_len + 1
                    else:
                        done = 1
                else:
                    if part & bitmask:
                        error = 1
                bitmask = bitmask >> 1

        if error == 1:
            return 0,"erreur, syntaxe de masque réseau invalide (ex : 255.255.0.0)"
        
    # pas d'erreur rencontrée
    return 1,""

def valid_booleen(force,data,type_bool="alpha"):
    """fonction de validation d'une réponse booléenne
       type_bool : alpha ou num (O/N ou 0/1)
    """
    if data == "":
        return 1,""
    
    if (data[0].upper() != 'O') and (data[0].upper() != 'N'):
        return 0, "vous devez répondez par 'O' ou 'N'"
    # pas d'erreurs détectées
    return 1,""

def valid_enum(force,data,liste=['oui','non','Oui','Non','OUI','NON','o','n','O','N']):
    """fonction de validation d'une réponse en fonction
    d'une liste de valeur possibles
    """
    if data == "":
        return 1,""
    
    if data not in liste:
        return 0,"répondez par un des choix suivants : "+str(liste)
    return 1,""


def valid_regexp(force,data,*args):
    """fonction de validation d'une saisie par expression régulière"""
    # construction de la chaine d'expression régulière
    if data == "":
        return 1,""

    exp_reg = ""
    for arg in args:
        exp_reg += arg
        
    m=re.match(exp_reg,data)
    if m is None:
        return 0,"la syntaxe est incorrecte, recommencez : "
    else:
        return 1,""
     

def valid_entier(force,data,mini=None,maxi=None):
    """ fonction de validation d'un nombre (intervalle optionnel)"""
    if data == "":
        return 1,""
    
    try:
        value = int(data)
    except ValueError:
        return 0,"vous devez saisir un nombre, recommencez"
    else:
        if mini is not None and value < mini:
            return 0,"donnez un entier supérieur à "+str(mini)
        if maxi is not None and value > maxi:
            return 0,"donnez un entier inférieur à "+str(maxi)
        return 1,""

def valid_system(force,data,cmd,result,*args):
    if data == "":
        return 1,""
    
    cmd_string =  cmd
    for arg in args:
        cmd_string += " "+arg
    
    # exécution de la fonction
    code_retour = os.system(cmd_string)
    
    if code_retour == result:
        return 1,""
    else:
        return 0,"la commande "+cmd_string+" a échoué, recommencez"
    
def valid_obligatoire(force,data):
    """ fonction qui vérifie que les données ne sont pas vides
    """
    # l'option force permet de ne pas rendre la valeur obligatoire
    # (ex : saisie de quelques valeurs par défaut pour dico.eol)
    if force == 1:
        return 1,""
    if data.strip() == "":
        return 0,"cette valeur est obligatoire, veuillez remplir le champ"
    else:
        return 1,""

#############################################
## Fonctions de saisie et calcul des valeurs
#############################################

#def calcul_network(ip,netmask):
#    """ calcule le réseau par défaut à partir d'un masque et d'une ip """
#    # si les ip et netmask viennent du dictionnaire, on les récupère
#    if ip == "" or netmask == "":
#        return 0,""
#        
#    ip_parts = ip.split(".")
#    netmask_parts = netmask.split(".")
#    network = ""
#    
#    for i in range(4):
#        if i > 0:
#            network += "."
#        network += str(int(ip_parts[i]) & int(netmask_parts[i]))
#            
#    return 0,network

def calcul_network(ip, netmask):
    """ calcule le réseau par défaut à partir d'un masque et d'une ip """
    # si les ip et netmask viennent du dictionnaire, on les récupère
    if ip == "" or netmask == "":
        return 0,""
    broadcast, network = calc_adresses(ip, netmask)
            
    return 0, network

def calcul_broadcast(ip, netmask):
    """ calcule l'adresse de broadcast par défaut à partir d'un masque et d'une ip """
    # si les ip et netmask viennent du dictionnaire, on les récupère
    if ip == "" or netmask == "":
        return 0,""
    broadcast, network = calc_adresses(ip, netmask)
            
    return 0, broadcast

def create_ip(ip_list):
    template = """%i.%i.%i.%i"""
    return template%tuple(ip_list)

    
def create_ip_list(ip):
    a,b,c,d=ip.split('.')
    return [int(a),int(b),int(c),int(d)]

    
def calc_adresses(ip, mask):
    """calcul l'adresse de broadcast à partir de l'ip et du netmask
    """
    mask_list = create_ip_list(mask)
    ip_list = create_ip_list(ip)
    broadcast_list = []
    network_list = []
    for i in range(4):
        #calcul de l'adresse réseau
        network_list.append(int(ip_list[i]) & int(mask_list[i]))
        for j in range(256):
            if mask_list[i]&j == 0:
                broadcast_part = j
        #calcul du masque spécial
        if broadcast_part != 255:
            broadcast_part += mask_list[i]&ip_list[i]
        broadcast_list.append(broadcast_part)
    broadcast = create_ip(broadcast_list)
    network = create_ip(network_list)
    return broadcast, network


def calcul_classe(netmask):
    """calcule la classe du réseau à partir du netmask"""

    classes = {
    '128.0.0.0' : '1'
    , '192.0.0.0' : '2'
    , '224.0.0.0' : '3'
    , '240.0.0.0' : '4'
    , '248.0.0.0' : '5'
    , '252.0.0.0' : '6'
    , '254.0.0.0' : '7'
    , '255.0.0.0' : '8'
    , '255.128.0.0' : '9'
    , '255.192.0.0' : '10'
    , '255.224.0.0' : '11'
    , '255.240.0.0' : '12'
    , '255.248.0.0' : '13'
    , '255.252.0.0' : '14'
    , '255.254.0.0' : '15'
    , '255.255.0.0' : '16'
    , '255.255.128.0' : '17'
    , '255.255.192.0' : '18'
    , '255.255.224.0' : '19'
    , '255.255.240.0' : '20'
    , '255.255.248.0' : '21'
    , '255.255.252.0' : '22'
    , '255.255.254.0' : '23'
    , '255.255.255.0' : '24'
    , '255.255.255.128' : '25'
    , '255.255.255.192' : '26'
    , '255.255.255.224' : '27'
    , '255.255.255.240' : '28'
    , '255.255.255.248' : '29'
    , '255.255.255.252' : '30'
    , '255.255.255.254' : '31'
    , '255.255.255.255' : '32'
    }

    if classes.has_key(netmask):
        return 0, classes[netmask]
    else:
        return 0, netmask


def calcul_optionnel(variable,valeurs):
    if variable in valeurs:
        return 1,""
    else:
        return 0,""


def calcul_val(valeur):
    if valeur.startswith('$'):
        return 0,donnees_dispo(valeur[1:])
    else:
        return 0,valeur


def main():
    """fonction de test  de la bibliothèque"""
    resultat,msg = valid_netmask(0,sys.argv[1]) 
    print str(resultat)+", message : "+msg+"!"

if __name__ == "__main__":
    main()
