#!/usr/bin/env python
"""Restauration du config.eol du volume en /root/zephir.eol"""
from pyeole2.bacularestore import exit_if_running_jobs, extract_file
from pyeole2.bacula import mount_bacula_support, umount_bacula_support, \
        BACULA_SUPPORT
from os.path import isfile
from sys import exit

def execute(option, opt_str, value, parser, jobid, test_jobs=True):
    """config_eol helper"""
    if len(parser.rargs) > 0:
        option = parser.rargs[0]
        if option == 'pre':
            pre()
        elif option == 'post':
            post()
    else:
        if test_jobs:
            exit_if_running_jobs()
        job(jobid)

def pre():
    print "pre config_eol"

def post():
    print "post config_eol"

def job(jobid):
    print "Restauration du config.eol"
    if not isfile(BACULA_SUPPORT):
        print "Erreur, le support de sauvegarde n'est pas configurer"
        print "Veuillez le configurer avec le script :"
        print "/usr/share/eole/bacula/baculaconfig.py"
        exit(1)
    mount_bacula_support()
    extract_file('/etc/eole/config.eol', dest_file='/root/zephir.eol')
    umount_bacula_support()

priority=1
